/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.remote;

import db.buffers.ManagedBufferFileHandle;
import ghidra.framework.remote.RepositoryChangeEvent;
import ghidra.framework.remote.RepositoryItem;
import ghidra.framework.remote.User;
import ghidra.framework.store.CheckoutType;
import ghidra.framework.store.ItemCheckoutStatus;
import ghidra.framework.store.Version;
import ghidra.util.InvalidNameException;
import ghidra.util.SystemUtilities;
import java.io.IOException;

public interface RepositoryHandle {
    public static final int CLIENT_CHECK_PERIOD = SystemUtilities.isInTestingMode() ? 2000 : 30000;

    public String getName() throws IOException;

    public User getUser() throws IOException;

    public User[] getUserList() throws IOException;

    public boolean anonymousAccessAllowed() throws IOException;

    public String[] getServerUserList() throws IOException;

    public void setUserList(User[] var1, boolean var2) throws IOException;

    public String[] getSubfolderList(String var1) throws IOException;

    public int getItemCount() throws IOException;

    public RepositoryItem[] getItemList(String var1) throws IOException;

    public RepositoryItem getItem(String var1, String var2) throws IOException;

    public RepositoryItem getItem(String var1) throws IOException;

    public void createTextDataFile(String var1, String var2, String var3, String var4, String var5, String var6) throws InvalidNameException, IOException;

    public ManagedBufferFileHandle createDatabase(String var1, String var2, String var3, int var4, String var5, String var6) throws IOException, InvalidNameException;

    public ManagedBufferFileHandle openDatabase(String var1, String var2, int var3, int var4) throws IOException;

    public ManagedBufferFileHandle openDatabase(String var1, String var2, long var3) throws IOException;

    public Version[] getVersions(String var1, String var2) throws IOException;

    public void deleteItem(String var1, String var2, int var3) throws IOException;

    public void moveFolder(String var1, String var2, String var3, String var4) throws InvalidNameException, IOException;

    public void moveItem(String var1, String var2, String var3, String var4) throws InvalidNameException, IOException;

    public ItemCheckoutStatus checkout(String var1, String var2, CheckoutType var3, String var4) throws IOException;

    public void terminateCheckout(String var1, String var2, long var3, boolean var5) throws IOException;

    public ItemCheckoutStatus getCheckout(String var1, String var2, long var3) throws IOException;

    public ItemCheckoutStatus[] getCheckouts(String var1, String var2) throws IOException;

    public boolean folderExists(String var1) throws IOException;

    public boolean fileExists(String var1, String var2) throws IOException;

    public long getLength(String var1, String var2) throws IOException;

    public boolean hasCheckouts(String var1, String var2) throws IOException;

    public boolean isCheckinActive(String var1, String var2) throws IOException;

    public void updateCheckoutVersion(String var1, String var2, long var3, int var5) throws IOException;

    public RepositoryChangeEvent[] getEvents() throws IOException;

    public void close() throws IOException;
}

