/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree;

import ghidra.util.exception.CancelledException;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.TaskMonitor;

public class TreeTaskMonitor
implements TaskMonitor {
    private static long MAX_VALUE = 0x1000000000000000L;
    private final TaskMonitor monitor;
    private final long currentRangeMin;
    private final long currentRangeMax;
    private long chunkSize;
    private long max;
    private long progress;

    public TreeTaskMonitor(TaskMonitor monitor, long max) {
        if (monitor instanceof TreeTaskMonitor) {
            TreeTaskMonitor treeTaskMonitor = (TreeTaskMonitor)monitor;
            this.monitor = treeTaskMonitor.monitor;
            this.currentRangeMin = treeTaskMonitor.getTrueProgress();
            this.currentRangeMax = this.currentRangeMin + treeTaskMonitor.chunkSize;
        } else {
            this.monitor = monitor;
            this.currentRangeMin = 0L;
            this.currentRangeMax = MAX_VALUE;
            monitor.initialize(MAX_VALUE);
        }
        this.setMaximum(max);
        this.progress = 0L;
    }

    private long getTrueProgress() {
        return this.monitor.getProgress();
    }

    public boolean isCancelled() {
        return this.monitor.isCancelled();
    }

    public void setShowProgressValue(boolean showProgressValue) {
        this.monitor.setShowProgressValue(showProgressValue);
    }

    public void setMessage(String message) {
        this.monitor.setMessage(message);
    }

    public String getMessage() {
        return this.monitor.getMessage();
    }

    public void setProgress(long value) {
        this.progress = value;
        this.monitor.setProgress(this.currentRangeMin + value * this.chunkSize);
    }

    public void initialize(long maxValue) {
        this.setMaximum(maxValue);
    }

    public void setMaximum(long maxValue) {
        if (maxValue > 0L) {
            this.max = maxValue;
            long currentRange = this.currentRangeMax - this.currentRangeMin;
            this.chunkSize = Math.max(currentRange / this.max, 1L);
        } else {
            this.max = 0L;
            this.chunkSize = 0L;
        }
    }

    public long getMaximum() {
        return this.max;
    }

    public void setIndeterminate(boolean indeterminate) {
        this.monitor.setIndeterminate(indeterminate);
    }

    public boolean isIndeterminate() {
        return this.monitor.isIndeterminate();
    }

    public void checkCanceled() throws CancelledException {
        this.monitor.checkCancelled();
    }

    public void incrementProgress(long incrementAmount) {
        this.progress += incrementAmount;
        this.monitor.setProgress(this.currentRangeMin + this.progress * this.chunkSize);
    }

    public long getProgress() {
        return this.progress;
    }

    public void cancel() {
        this.monitor.cancel();
    }

    public void addCancelledListener(CancelledListener listener) {
        this.monitor.addCancelledListener(listener);
    }

    public void removeCancelledListener(CancelledListener listener) {
        this.monitor.removeCancelledListener(listener);
    }

    public void setCancelEnabled(boolean enable) {
        this.monitor.setCancelEnabled(enable);
    }

    public boolean isCancelEnabled() {
        return this.monitor.isCancelEnabled();
    }

    public void clearCanceled() {
        this.monitor.clearCancelled();
    }
}

