/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filechooser;

import docking.widgets.filechooser.GhidraFileChooser;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FileChooserToggleButton
extends JToggleButton {
    private static final Border RAISED_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    private static final Border LOWERED_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2));
    private static final Color FOCUS_COLOR = new GColor("color.border.button.focused");
    private static final Border FOCUSED_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createLineBorder(FOCUS_COLOR));
    private static final Border UNFOCUSED_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    private static final Border NO_BORDER = new EmptyBorder(4, 4, 4, 4);
    private GhidraFileChooser fileChooser;

    public FileChooserToggleButton(String text, GhidraFileChooser fileChooser) {
        super(text);
        this.fileChooser = fileChooser;
        this.initBorder();
    }

    private void initBorder() {
        this.setForeground((Color)GThemeDefaults.Colors.BACKGROUND);
        this.setOpaque(true);
        this.setHorizontalTextPosition(0);
        this.setVerticalTextPosition(3);
        this.clearBorder();
        this.setContentAreaFilled(false);
        this.addChangeListener(new ButtonStateListener());
        this.addChangeListener(e -> this.updateBorderBasedOnState());
        this.addFocusListener(new ButtonFocusListener());
        this.updateBorderBasedOnState();
    }

    @Override
    public void setBorder(Border border) {
        if (border == RAISED_BORDER || border == LOWERED_BORDER || border == NO_BORDER || border instanceof FocusedBorder) {
            super.setBorder(border);
        }
    }

    private void clearBorder() {
        this.setBorder(NO_BORDER);
    }

    File getFile() {
        return null;
    }

    private void updateBorderBasedOnState() {
        if (!this.isEnabled()) {
            return;
        }
        ButtonModel buttonModel = this.getModel();
        boolean pressed = buttonModel.isPressed();
        boolean rollover = buttonModel.isRollover();
        boolean armed = buttonModel.isArmed();
        boolean selected = buttonModel.isSelected();
        Border border = NO_BORDER;
        if (selected) {
            border = LOWERED_BORDER;
        } else if (pressed && (rollover || armed)) {
            border = LOWERED_BORDER;
        } else if (rollover) {
            border = RAISED_BORDER;
        }
        border = this.createFocusedBorder(border, this.isFocusOwner());
        this.setBorder(border);
    }

    private Border createFocusedBorder(Border outside, boolean isFocused) {
        Border inside = isFocused ? FOCUSED_BORDER : UNFOCUSED_BORDER;
        return new FocusedBorder(outside, inside);
    }

    private class ButtonStateListener
    implements ChangeListener {
        private ButtonStateListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            FileChooserToggleButton.this.updateBorderBasedOnState();
        }
    }

    private class ButtonFocusListener
    implements FocusListener {
        private ButtonFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            FileChooserToggleButton.this.updateBorderBasedOnState();
        }

        @Override
        public void focusLost(FocusEvent e) {
            FileChooserToggleButton.this.updateBorderBasedOnState();
            FileChooserToggleButton.this.fileChooser.updateShortcutPanel();
        }
    }

    private class FocusedBorder
    extends CompoundBorder {
        FocusedBorder(Border outsideBorder, Border insideBorder) {
            super(outsideBorder, insideBorder);
        }
    }
}

