/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.dialogs;

import docking.DialogComponentProvider;
import docking.widgets.table.GTableWidget;
import java.util.List;
import javax.swing.JComponent;

public class ObjectChooserDialog<T>
extends DialogComponentProvider {
    private T selectedObject;
    private List<T> choosableObjects;
    private String[] methodsForColumns;
    private Class<T> objectClass;
    private GTableWidget<T> table;

    public ObjectChooserDialog(String title, Class<T> objectClass, List<T> choosableObjects, String ... methodsForColumns) {
        super(title, true);
        this.objectClass = objectClass;
        this.choosableObjects = choosableObjects;
        this.methodsForColumns = methodsForColumns;
        this.setTransient(true);
        this.addWorkPanel(this.buildWorkPanel());
        this.addOKButton();
        this.addCancelButton();
    }

    @Override
    protected void okCallback() {
        this.close();
    }

    @Override
    protected void cancelCallback() {
        this.selectedObject = null;
        this.close();
    }

    @Override
    protected void dialogShown() {
        this.table.focusFilter();
    }

    public GTableWidget<T> getTable() {
        return this.table;
    }

    private JComponent buildWorkPanel() {
        this.table = new GTableWidget<T>(this.getTitle(), this.objectClass, this.methodsForColumns);
        this.table.setData(this.choosableObjects);
        this.table.addSelectionListener(t -> this.objectSelected(t));
        this.table.setItemPickListener(t -> this.objectPicked(t));
        this.table.getAccessibleContext().setAccessibleName("Object Chooser");
        return this.table;
    }

    protected void objectPicked(T t) {
        this.selectedObject = t;
        this.close();
    }

    protected void objectSelected(T t) {
        this.selectedObject = t;
        this.setOkEnabled(this.selectedObject != null);
    }

    public T getSelectedObject() {
        return this.selectedObject;
    }

    public void setSelectedObject(T t) {
        this.table.selectRowObject(t);
    }

    public void setFilterText(String text) {
        this.table.setFilterText(text);
    }

    @Override
    public void close() {
        this.table.dispose();
        super.close();
    }
}

