/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.extend;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.extend.ElfExtension;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;

public class AVR8_ElfExtension
extends ElfExtension {
    public static final int EF_AVR_MACH = 127;
    public static final int EF_AVR_LINKRELAX_PREPARED = 128;
    public static final int E_AVR_MACH_AVR1 = 1;
    public static final int E_AVR_MACH_AVR2 = 2;
    public static final int E_AVR_MACH_AVR25 = 25;
    public static final int E_AVR_MACH_AVR3 = 3;
    public static final int E_AVR_MACH_AVR31 = 31;
    public static final int E_AVR_MACH_AVR35 = 35;
    public static final int E_AVR_MACH_AVR4 = 4;
    public static final int E_AVR_MACH_AVR5 = 5;
    public static final int E_AVR_MACH_AVR51 = 51;
    public static final int E_AVR_MACH_AVR6 = 6;
    public static final int E_AVR_MACH_XMEGA1 = 101;
    public static final int E_AVR_MACH_XMEGA2 = 102;
    public static final int E_AVR_MACH_XMEGA3 = 103;
    public static final int E_AVR_MACH_XMEGA4 = 104;
    public static final int E_AVR_MACH_XMEGA5 = 105;
    public static final int E_AVR_MACH_XMEGA6 = 106;
    public static final int E_AVR_MACH_XMEGA7 = 107;

    public boolean canHandle(ElfHeader elf) {
        return elf.e_machine() == 83;
    }

    public boolean canHandle(ElfLoadHelper elfLoadHelper) {
        Language language = elfLoadHelper.getProgram().getLanguage();
        return this.canHandle(elfLoadHelper.getElfHeader()) && "AVR8".equals(language.getProcessor().toString());
    }

    public String getDataTypeSuffix() {
        return "_AVR";
    }

    public long getAdjustedMemoryOffset(long elfOffset, AddressSpace space) {
        if ("code".equals(space.getName())) {
            elfOffset >>= 1;
        }
        return elfOffset;
    }

    public Address evaluateElfSymbol(ElfLoadHelper elfLoadHelper, ElfSymbol elfSymbol, Address address, boolean isExternal) {
        if (!address.getAddressSpace().getName().equals("code")) {
            return address;
        }
        if (isExternal) {
            return address;
        }
        return address.getAddressSpace().getAddress(address.subtract(elfSymbol.getValue() << 1).getOffset() + elfSymbol.getValue());
    }
}

