/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import ghidra.framework.options.OptionType;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import java.beans.PropertyEditor;
import java.time.LocalDate;
import java.util.Objects;
import utilities.util.reflection.ReflectionUtilities;

public abstract class Option {
    public static final String UNREGISTERED_OPTION = "Unregistered Option";
    private static final LocalDate ONE_YEAR_AGO = LocalDate.now().minusYears(1L);
    private final String name;
    private Object defaultValue;
    private boolean isRegistered;
    private LocalDate lastRegisteredDate;
    private String description;
    private HelpLocation helpLocation;
    private OptionType optionType;
    private PropertyEditor propertyEditor;
    private String inceptionInformation;

    protected Option(String name, OptionType optionType, String description, HelpLocation helpLocation, Object defaultValue, boolean isRegistered, PropertyEditor editor) {
        this.name = name;
        this.optionType = optionType;
        this.description = description;
        this.helpLocation = helpLocation;
        this.defaultValue = defaultValue;
        this.isRegistered = isRegistered;
        this.propertyEditor = editor;
        if (isRegistered) {
            this.lastRegisteredDate = LocalDate.now();
        } else {
            this.recordInception();
        }
    }

    final void updateRegistration(String updatedDescription, HelpLocation updatedHelp, Object updatedDefaultValue, PropertyEditor updatedEditor) {
        this.description = this.description != null ? this.description : updatedDescription;
        this.helpLocation = this.helpLocation != null ? this.helpLocation : updatedHelp;
        this.defaultValue = this.defaultValue != null ? this.defaultValue : updatedDefaultValue;
        this.propertyEditor = this.propertyEditor != null ? this.propertyEditor : updatedEditor;
        this.isRegistered = true;
        this.lastRegisteredDate = LocalDate.now();
    }

    public abstract Object getCurrentValue();

    public abstract void doSetCurrentValue(Object var1);

    public void setCurrentValue(Object value) {
        this.isRegistered = true;
        this.lastRegisteredDate = LocalDate.now();
        this.doSetCurrentValue(value);
    }

    public String getName() {
        return this.name;
    }

    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    public HelpLocation getHelpLocation() {
        return this.helpLocation;
    }

    public String getDescription() {
        return this.description == null ? UNREGISTERED_OPTION : this.description;
    }

    public Object getValue(Object passedInDefaultValue) {
        Object value = this.getCurrentValue();
        if (value == null && this.defaultValue == null) {
            return passedInDefaultValue;
        }
        return value;
    }

    public boolean wasRegisteredInPreviousSession() {
        return this.lastRegisteredDate != null;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public void setLastRegisteredDate(LocalDate date) {
        this.lastRegisteredDate = date;
    }

    public LocalDate getLastRegisteredDate() {
        LocalDate date = this.lastRegisteredDate;
        if (date == null) {
            date = ONE_YEAR_AGO;
        }
        return date;
    }

    public boolean hasExpired() {
        if (this.lastRegisteredDate == null) {
            return false;
        }
        return this.lastRegisteredDate.isBefore(ONE_YEAR_AGO);
    }

    public void restoreDefault() {
        this.setCurrentValue(this.defaultValue);
    }

    public boolean isDefault() {
        Object value = this.getCurrentValue();
        return Objects.equals(value, this.defaultValue);
    }

    public String toString() {
        return "[current value=" + String.valueOf(this.getCurrentValue()) + ", default value=" + String.valueOf(this.defaultValue) + ", isRegistered=" + this.isRegistered + "]";
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getInceptionInformation() {
        return this.inceptionInformation;
    }

    private void recordInception() {
        if (!SystemUtilities.isInDevelopmentMode()) {
            return;
        }
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        StackTraceElement[] filteredTrace = ReflectionUtilities.filterStackTrace((StackTraceElement[])stackTrace, (String[])new String[]{"option", "OptionsManager"});
        this.inceptionInformation = filteredTrace[0].toString();
    }

    public OptionType getOptionType() {
        return this.optionType;
    }
}

