/*
 * Decompiled with CFR 0.152.
 */
package ghidra.base.widgets.table.constraint.provider;

import docking.widgets.table.constraint.AtLeastColumnConstraint;
import docking.widgets.table.constraint.AtMostColumnConstraint;
import docking.widgets.table.constraint.ColumnConstraint;
import docking.widgets.table.constraint.ColumnConstraintProvider;
import docking.widgets.table.constraint.ColumnTypeMapper;
import docking.widgets.table.constraint.InRangeColumnConstraint;
import docking.widgets.table.constraint.MappedColumnConstraint;
import docking.widgets.table.constraint.NotInRangeColumnConstraint;
import docking.widgets.table.constraint.provider.EditorProvider;
import docking.widgets.table.constrainteditor.UnsignedLongConstraintEditor;
import docking.widgets.table.constrainteditor.UnsignedLongConstraintEditorProvider;
import docking.widgets.table.constrainteditor.UnsignedLongRangeEditorProvider;
import ghidra.program.model.address.Address;
import ghidra.util.NumericUtilities;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;

public class ProgramColumnConstraintProvider
implements ColumnConstraintProvider {
    public Collection<ColumnConstraint<?>> getColumnConstraints() {
        ArrayList list = new ArrayList();
        list.add((ColumnConstraint<?>)new AddressColumnConstraint((ColumnConstraint<BigInteger>)new AtMostColumnConstraint((Comparable)UnsignedLongConstraintEditor.MAX_VALUE, (EditorProvider)new UnsignedLongConstraintEditorProvider())));
        list.add((ColumnConstraint<?>)new AddressColumnConstraint((ColumnConstraint<BigInteger>)new AtLeastColumnConstraint((Comparable)BigInteger.ZERO, (EditorProvider)new UnsignedLongConstraintEditorProvider())));
        list.add((ColumnConstraint<?>)new AddressColumnConstraint((ColumnConstraint<BigInteger>)new InRangeColumnConstraint((Comparable)BigInteger.ZERO, (Comparable)UnsignedLongConstraintEditor.MAX_VALUE, (EditorProvider)new UnsignedLongRangeEditorProvider())));
        list.add((ColumnConstraint<?>)new AddressColumnConstraint((ColumnConstraint<BigInteger>)new NotInRangeColumnConstraint((Comparable)BigInteger.ZERO, (Comparable)UnsignedLongConstraintEditor.MAX_VALUE, (EditorProvider)new UnsignedLongRangeEditorProvider())));
        return list;
    }

    private static class AddressColumnConstraint
    extends MappedColumnConstraint<Address, BigInteger> {
        public AddressColumnConstraint(ColumnConstraint<BigInteger> delegate) {
            super((ColumnTypeMapper)new AddressToBigIntegerMapper(), delegate);
        }

        public ColumnConstraint<Address> copy(ColumnConstraint<BigInteger> value) {
            return new AddressColumnConstraint(value);
        }
    }

    private static class AddressToBigIntegerMapper
    extends ColumnTypeMapper<Address, BigInteger> {
        private AddressToBigIntegerMapper() {
        }

        public BigInteger convert(Address value) {
            return NumericUtilities.unsignedLongToBigInteger((long)value.getOffset());
        }
    }
}

