/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.options;

import generic.theme.GColor;
import java.awt.Color;

public class ScreenElement {
    private String name;
    private String optionsName;
    private Color color;
    private GColor defaultColor;
    private int style;

    ScreenElement(String name, GColor defaultColor) {
        this(name, name, defaultColor, -1);
    }

    ScreenElement(String name, GColor defaultColor, int style) {
        this(name, name, defaultColor, style);
    }

    ScreenElement(String name, String optionsName, GColor defaultColor) {
        this(name, optionsName, defaultColor, -1);
    }

    ScreenElement(String name, String optionsName, GColor defaultColor, int style) {
        this.name = name;
        this.optionsName = optionsName;
        this.defaultColor = defaultColor;
        this.color = defaultColor;
        this.style = style;
    }

    public String getThemeColorId() {
        return this.defaultColor.getId();
    }

    public String getName() {
        return this.name;
    }

    public Color getColor() {
        return this.color;
    }

    public int getStyle() {
        return this.style;
    }

    public GColor getDefaultColor() {
        return this.defaultColor;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public String getColorOptionName() {
        return this.optionsName + " Color";
    }

    public String getStyleOptionName() {
        return this.optionsName + " Style";
    }

    public String toString() {
        return this.name;
    }
}

