/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import ghidra.app.nav.Navigatable;
import ghidra.app.services.GoToService;
import ghidra.app.util.viewer.field.FieldMouseHandlerExtension;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.CollapsedCodeLocation;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramLocation;
import java.awt.event.MouseEvent;

public class CollapsedCodeFieldMouseHandler
implements FieldMouseHandlerExtension {
    private static final Class<?>[] SUPPORTED_CLASSES = new Class[]{CollapsedCodeLocation.class};

    @Override
    public boolean fieldElementClicked(Object clickedObject, Navigatable navigatable, ProgramLocation location, MouseEvent mouseEvent, ServiceProvider serviceProvider) {
        if (mouseEvent.getClickCount() != 2 || mouseEvent.getButton() != 1) {
            return false;
        }
        GoToService goToService = (GoToService)serviceProvider.getService(GoToService.class);
        if (goToService == null) {
            return false;
        }
        Program program = location.getProgram();
        if (location instanceof CollapsedCodeLocation) {
            CollapsedCodeLocation loc = (CollapsedCodeLocation)location;
            Address address = loc.getAddress();
            Function function = program.getListing().getFunctionContaining(address);
            if (function != null) {
                FunctionSignatureFieldLocation gotoLocation = new FunctionSignatureFieldLocation(program, function.getEntryPoint());
                goToService.goTo(navigatable, (ProgramLocation)gotoLocation, program);
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?>[] getSupportedProgramLocations() {
        return SUPPORTED_CLASSES;
    }
}

