/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.app.util.viewer.proxy.CodeUnitProxy;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.CollapsedCodeLocation;
import ghidra.program.util.ProgramLocation;
import java.awt.Color;
import java.math.BigInteger;

public class CollapsedCodeFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "Collapsed Code";

    public CollapsedCodeFieldFactory() {
        super(FIELD_NAME);
    }

    private CollapsedCodeFieldFactory(FieldFormatModel model, ListingHighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        if (!this.enabled || !(proxy instanceof CodeUnitProxy)) {
            return null;
        }
        CodeUnitProxy cuProxy = (CodeUnitProxy)proxy;
        CodeUnit cu = cuProxy.getObject();
        Address address = cu.getAddress();
        Function function = cu.getProgram().getListing().getFunctionContaining(address);
        if (function == null) {
            return null;
        }
        String text = "<Collapsed: " + function.getName() + "()>";
        AttributedString s = new AttributedString(text, (Color)ListingColors.COLLAPSED_CODE, this.getMetrics());
        TextFieldElement element = new TextFieldElement(s, 0, 0);
        return ListingTextField.createSingleLineTextField(this, cuProxy, (FieldElement)element, this.startX + varWidth, this.width, this.hlProvider);
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        Object obj = bf.getProxy().getObject();
        if (obj instanceof CodeUnit) {
            CodeUnit cu = (CodeUnit)obj;
            Address address = cu.getAddress();
            ListingModel layoutModel = bf.getProxy().getListingLayoutModel();
            Program program = layoutModel.getProgram();
            return new CollapsedCodeLocation(program, address);
        }
        return null;
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation programLoc) {
        if (programLoc instanceof CollapsedCodeLocation) {
            return new FieldLocation(index, fieldNum, 0, 0);
        }
        return null;
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        return category == 0;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, ListingHighlightProvider provider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new CollapsedCodeFieldFactory(formatModel, provider, (Options)displayOptions, (Options)fieldOptions);
    }
}

