/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.opinion.DecompileDebugDataTypeManager;
import ghidra.framework.store.LockException;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryConflictException;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlMessageLog;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;
import java.util.Map;

public class DecompileDebugFunctionManager {
    Program prog;
    TaskMonitor monitor;
    DecompileDebugDataTypeManager dataTypeManager;

    public DecompileDebugFunctionManager(Program prog, TaskMonitor monitor, DecompileDebugDataTypeManager dataTypeManager) {
        this.prog = prog;
        this.monitor = monitor;
        this.dataTypeManager = dataTypeManager;
    }

    public void parseFunctionSignature(XmlPullParser parser, Map<Long, Namespace> scopeMap, XmlMessageLog log) {
        XmlElement functionElement = parser.start(new String[]{"function"});
        String functionName = functionElement.getAttribute(AttributeId.ATTRIB_NAME.name());
        boolean noReturn = functionElement.hasAttribute(AttributeId.ATTRIB_NORETURN.name());
        Function createdFunction = null;
        XmlElement localdb = null;
        Address functionAddr = null;
        block16: while (parser.peek().isStart()) {
            String tagName;
            switch (tagName = parser.peek().getName()) {
                case "addr": {
                    try {
                        XmlElement addressTag = parser.start(new String[]{"addr"});
                        functionAddr = AddressXML.restoreXml((XmlElement)addressTag, (CompilerSpec)this.prog.getCompilerSpec()).getFirstAddress();
                        parser.end(addressTag);
                        continue block16;
                    }
                    catch (XmlParseException e) {
                        log.appendException((Throwable)e);
                    }
                }
                case "scope": {
                    XmlElement scopeElement = parser.start(new String[]{"scope"});
                    String scopeName = scopeElement.getAttribute(AttributeId.ATTRIB_NAME.name());
                    Namespace functionNamespace = this.getParentNamespace(parser, scopeMap, scopeName);
                    createdFunction = this.setFunctionNamespaceAndStorage(functionName, functionAddr, functionNamespace, log);
                    createdFunction.setNoReturn(noReturn);
                    this.handleScopeSubtags(createdFunction, parser, log);
                    parser.end(scopeElement);
                    parser.end(localdb);
                    continue block16;
                }
                case "prototype": {
                    XmlElement prototypeElement = parser.start(new String[]{"prototype"});
                    try {
                        createdFunction.setCallingConvention(prototypeElement.getAttribute("model"));
                        createdFunction.setReturnType(this.retrieveReturnType(parser, log), SourceType.IMPORTED);
                        if (parser.peek().isStart("inject")) {
                            parser.start(new String[]{"inject"});
                            String callFixup = parser.end().getText();
                            createdFunction.setCallFixup(callFixup);
                            log.appendMsg("Found an inject tag on the function: " + createdFunction.getName());
                        }
                    }
                    catch (InvalidInputException e) {
                        log.appendException((Throwable)e);
                    }
                    while (!parser.peek().isEnd()) {
                        log.appendMsg(parser.getLineNumber(), "Level " + parser.getCurrentLevel() + " tag not currently supported: " + parser.peek().getName());
                        parser.discardSubTree();
                    }
                    parser.end(prototypeElement);
                    continue block16;
                }
                case "localdb": {
                    localdb = parser.start(new String[]{"localdb"});
                    continue block16;
                }
            }
            log.appendMsg(parser.getLineNumber(), "Level " + parser.getCurrentLevel() + " tag not currently supported: " + parser.peek().getName());
            parser.discardSubTree();
        }
        parser.end(functionElement);
    }

    private Namespace getParentNamespace(XmlPullParser parser, Map<Long, Namespace> scopeMap, String scopeName) {
        XmlElement parentTag = parser.start(new String[]{"parent"});
        Long parentId = SpecXmlUtils.decodeLong((String)parentTag.getAttribute(AttributeId.ATTRIB_ID.name()));
        Namespace parentNamespace = scopeMap.get(parentId);
        parser.end(parentTag);
        return parentNamespace;
    }

    private void handleScopeSubtags(Function createdFunction, XmlPullParser parser, XmlMessageLog log) {
        block8: while (parser.peek().isStart()) {
            String tagName;
            switch (tagName = parser.peek().getName()) {
                case "rangelist": {
                    log.appendMsg(parser.getLineNumber(), "Level " + parser.getCurrentLevel() + " tag not currently supported: " + tagName);
                    parser.discardSubTree();
                    continue block8;
                }
                case "symbollist": {
                    XmlElement symbollistElement = parser.start(new String[]{"symbollist"});
                    this.findFunctionVariables(parser, createdFunction, log);
                    parser.end(symbollistElement);
                    continue block8;
                }
            }
            log.appendMsg(parser.getLineNumber(), "Level " + parser.getCurrentLevel() + " tag not currently supported: " + tagName);
            parser.discardSubTree();
        }
    }

    private DataType retrieveReturnType(XmlPullParser parser, XmlMessageLog log) {
        XmlElement returnElement = parser.start(new String[]{"returnsym"});
        XmlElement addrElement = parser.start(new String[]{"addr"});
        parser.end(addrElement);
        DataType returnType = this.dataTypeManager.parseDataTypeTag(parser, log);
        parser.end(returnElement);
        return returnType;
    }

    private void findFunctionVariables(XmlPullParser parser, Function createdFunction, XmlMessageLog log) {
        ArrayList<ParameterImpl> paramList = new ArrayList<ParameterImpl>();
        try {
            while (parser.peek().isStart()) {
                XmlElement mapsymElement = parser.start(new String[]{"mapsym"});
                XmlElement symbolElement = parser.start(new String[]{"symbol"});
                boolean isParam = SpecXmlUtils.decodeInt((String)symbolElement.getAttribute("cat")) == 0;
                String varName = symbolElement.getAttribute(AttributeId.ATTRIB_NAME.name());
                DataType varType = this.dataTypeManager.parseDataTypeTag(parser, log);
                parser.end(symbolElement);
                XmlElement addrElement = parser.start(new String[]{"addr"});
                if (isParam) {
                    Address address = AddressXML.restoreXml((XmlElement)addrElement, (CompilerSpec)this.prog.getCompilerSpec()).getFirstAddress();
                    ParameterImpl param = new ParameterImpl(varName, varType, address, this.prog);
                    paramList.add(param);
                } else {
                    int offset = (int)AddressXML.restoreXml((XmlElement)addrElement, (CompilerSpec)this.prog.getCompilerSpec()).getOffset();
                    LocalVariableImpl lvar = new LocalVariableImpl(varName, varType, offset, this.prog, SourceType.IMPORTED);
                    createdFunction.addLocalVariable((Variable)lvar, SourceType.IMPORTED);
                }
                parser.end(addrElement);
                while (parser.peek().isStart()) {
                    log.appendMsg(parser.getLineNumber(), "Level " + parser.getCurrentLevel() + " tag not currently supported: " + parser.peek().getName());
                    parser.discardSubTree();
                }
                parser.end(mapsymElement);
                createdFunction.updateFunction(null, null, paramList, Function.FunctionUpdateType.CUSTOM_STORAGE, true, SourceType.IMPORTED);
            }
        }
        catch (DuplicateNameException | InvalidInputException | XmlParseException | NumberFormatException e) {
            log.appendException(e);
        }
    }

    private Function setFunctionNamespaceAndStorage(String functionName, Address functionAddr, Namespace namespace, XmlMessageLog log) {
        Function createdFunction = this.createFunction(functionName, functionAddr, namespace, log);
        try {
            createdFunction.setCustomVariableStorage(true);
            Memory memory = this.prog.getMemory();
            if (!memory.contains(functionAddr)) {
                memory.createInitializedBlock(functionName, functionAddr, 1L, (byte)0, this.monitor, false);
            }
        }
        catch (LockException | AddressOverflowException | MemoryConflictException | CancelledException | IllegalArgumentException e) {
            log.appendException(e);
        }
        return createdFunction;
    }

    private Function createFunction(String functionName, Address functionAddr, Namespace namespace, XmlMessageLog log) {
        FunctionManager funcM = this.prog.getFunctionManager();
        Function generatedFunction = null;
        try {
            generatedFunction = funcM.createFunction(functionName, namespace, functionAddr, (AddressSetView)new AddressSet(functionAddr, functionAddr), SourceType.IMPORTED);
        }
        catch (OverlappingFunctionException | InvalidInputException e) {
            log.appendException(e);
        }
        return generatedFunction;
    }
}

