/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.plugin.processors.generic.MemoryBlockDefinition;
import ghidra.app.util.Option;
import ghidra.app.util.OptionUtils;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.LoadException;
import ghidra.app.util.opinion.LoadResults;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loaded;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.MachoProgramUtils;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.framework.model.DomainObject;
import ghidra.framework.store.LockException;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.program.model.lang.AddressLabelInfo;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.InvalidAddressException;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryConflictException;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.DefaultLanguageService;
import ghidra.program.util.GhidraProgramUtilities;
import ghidra.util.HashUtilities;
import ghidra.util.MD5Utilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractProgramLoader
implements Loader {
    public static final String APPLY_LABELS_OPTION_NAME = "Apply Processor Defined Labels";
    public static final String ANCHOR_LABELS_OPTION_NAME = "Anchor Processor Defined Labels";

    protected abstract List<Loaded<Program>> loadProgram(Loader.ImporterSettings var1) throws IOException, LoadException, CancelledException;

    protected abstract void loadProgramInto(Program var1, Loader.ImporterSettings var2) throws IOException, LoadException, CancelledException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LoadResults<? extends DomainObject> load(Loader.ImporterSettings settings) throws IOException, CancelledException, VersionException, LoadException {
        if (!settings.loadSpec().isComplete()) {
            throw new LoadException("Load spec is incomplete");
        }
        List<Loaded<Loaded>> loadedPrograms = this.loadProgram(settings);
        boolean success = false;
        try {
            for (Loaded<Program> loadResults : loadedPrograms) {
                settings.monitor().checkCancelled();
                Program program = loadResults.getDomainObject(this);
                try {
                    this.applyProcessorLabels(settings.options(), program);
                    program.setEventsEnabled(true);
                }
                finally {
                    program.release((Object)this);
                }
            }
            this.postLoadProgramFixups(loadedPrograms, settings);
            Iterator<Loaded<Program>> iter = loadedPrograms.iterator();
            while (iter.hasNext()) {
                Loaded<Program> loaded = iter.next();
                if (!loaded.check(p -> p.isTemporary())) continue;
                iter.remove();
                loaded.close();
            }
            success = true;
            LoadResults loadResults = new LoadResults(loadedPrograms);
            return loadResults;
        }
        finally {
            if (!success) {
                loadedPrograms.forEach(Loaded::close);
            }
            this.postLoadCleanup(success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void loadInto(Program program, Loader.ImporterSettings settings) throws IOException, LoadException, CancelledException {
        if (!settings.loadSpec().isComplete()) {
            throw new LoadException("Load spec is incomplete");
        }
        program.setEventsEnabled(false);
        int transactionID = program.startTransaction("Loading - " + this.getName());
        boolean success = false;
        try {
            this.loadProgramInto(program, settings);
            success = true;
        }
        finally {
            program.endTransaction(transactionID, success);
            program.setEventsEnabled(true);
        }
    }

    @Override
    public List<Option> getDefaultOptions(ByteProvider provider, LoadSpec loadSpec, DomainObject domainObject, boolean loadIntoProgram, boolean mirrorFsLayout) {
        ArrayList<Option> list = new ArrayList<Option>();
        list.add(new Option(APPLY_LABELS_OPTION_NAME, this.shouldApplyProcessorLabelsByDefault(), Boolean.class, "-loader-applyLabels"));
        list.add(new Option(ANCHOR_LABELS_OPTION_NAME, true, Boolean.class, "-loader-anchorLabels"));
        return list;
    }

    @Override
    public String validateOptions(ByteProvider provider, LoadSpec loadSpec, List<Option> options, Program program) {
        if (options != null) {
            for (Option option : options) {
                String name = option.getName();
                if (!name.equals(APPLY_LABELS_OPTION_NAME) && !name.equals(ANCHOR_LABELS_OPTION_NAME) || Boolean.class.isAssignableFrom(option.getValueClass())) continue;
                return "Invalid type for option: " + name + " - " + String.valueOf(option.getValueClass());
            }
        }
        return null;
    }

    protected void postLoadProgramFixups(List<Loaded<Program>> loadedPrograms, Loader.ImporterSettings settings) throws CancelledException, IOException {
    }

    protected void postLoadCleanup(boolean success) {
    }

    protected boolean shouldApplyProcessorLabelsByDefault() {
        return false;
    }

    protected String generateBlockName(Program program, boolean isOverlay, AddressSpace space) {
        if (!isOverlay) {
            return space.getName();
        }
        AddressFactory factory = program.getAddressFactory();
        int count = 0;
        while (count < 1000) {
            String lname;
            if (factory.getAddressSpace(lname = "ov" + ++count) != null) continue;
            return lname;
        }
        return "ov" + System.currentTimeMillis();
    }

    protected Program createProgram(Address imageBase, Loader.ImporterSettings settings) throws IOException {
        LanguageCompilerSpecPair pair = settings.loadSpec().getLanguageCompilerSpec();
        Language language = this.getLanguageService().getLanguage(pair.languageID);
        CompilerSpec compilerSpec = language.getCompilerSpecByID(pair.compilerSpecID);
        String programName = this.getProgramNameFromSourceData(settings.provider(), settings.importNameOnly());
        ProgramDB prog = new ProgramDB(programName, language, compilerSpec, settings.consumer());
        prog.setEventsEnabled(false);
        int id = prog.startTransaction("Set program properties");
        boolean success = false;
        try {
            AbstractProgramLoader.setProgramProperties((Program)prog, settings.provider(), this.getName());
            try {
                if (this.shouldSetImageBase((Program)prog, imageBase)) {
                    prog.setImageBase(imageBase, true);
                }
                success = true;
                ProgramDB programDB = prog;
                return programDB;
            }
            catch (LockException | AddressOverflowException e) {
                throw new IOException(e);
            }
        }
        finally {
            prog.endTransaction(id, true);
            if (!success) {
                prog.release(settings.consumer());
            }
        }
    }

    protected Program createProgram(Loader.ImporterSettings settings) throws IOException {
        Address imageBaseAddr = this.getLanguageService().getLanguage(settings.loadSpec().getLanguageCompilerSpec().languageID).getAddressFactory().getDefaultAddressSpace().getAddress(settings.loadSpec().getDesiredImageBase());
        return this.createProgram(imageBaseAddr, settings);
    }

    public static void setProgramProperties(Program prog, ByteProvider provider, String executableFormatName) throws IOException {
        FSRL fsrl;
        String md5;
        prog.setExecutablePath(provider.getAbsolutePath());
        if (executableFormatName != null) {
            prog.setExecutableFormat(executableFormatName);
        }
        String string = md5 = (fsrl = provider.getFSRL()) != null && fsrl.getMD5() != null ? fsrl.getMD5() : AbstractProgramLoader.computeBinaryMD5(provider);
        if (fsrl != null) {
            if (fsrl.getMD5() == null) {
                fsrl = fsrl.withMD5(md5);
            }
            FSRL.writeToProgramInfo(prog, fsrl);
        }
        prog.setExecutableMD5(md5);
        String sha256 = AbstractProgramLoader.computeBinarySHA256(provider);
        prog.setExecutableSHA256(sha256);
    }

    private String getProgramNameFromSourceData(ByteProvider provider, String domainFileName) {
        FSRL fsrl = provider.getFSRL();
        if (fsrl != null) {
            return fsrl.getName();
        }
        return domainFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createDefaultMemoryBlocks(Program program, Loader.ImporterSettings settings) {
        MessageLog log = settings.log();
        int id = program.startTransaction("Create default blocks");
        try {
            LanguageCompilerSpecPair pair = settings.loadSpec().getLanguageCompilerSpec();
            Language language = this.getLanguageService().getLanguage(pair.languageID);
            MemoryBlockDefinition[] defaultMemoryBlocks = language.getDefaultMemoryBlocks();
            if (defaultMemoryBlocks == null) {
                return;
            }
            for (MemoryBlockDefinition blockDef : defaultMemoryBlocks) {
                try {
                    blockDef.createBlock(program);
                }
                catch (LockException e) {
                    throw new AssertException("Unexpected Error");
                }
                catch (MemoryConflictException e) {
                    log.appendMsg("Failed to add language defined memory block due to conflict: " + String.valueOf(blockDef));
                }
                catch (AddressOverflowException e) {
                    log.appendMsg("Failed to add language defined memory block due to address error " + String.valueOf(blockDef));
                    log.appendMsg(" >> " + e.getMessage());
                }
                catch (InvalidAddressException e) {
                    log.appendMsg("Failed to add language defined memory block due to invalid address: " + String.valueOf(blockDef));
                    log.appendMsg(" >> Processor specification error (pspec): " + e.getMessage());
                }
            }
        }
        catch (LanguageNotFoundException e) {
            log.appendMsg("Failed get language for: " + String.valueOf(settings.loadSpec().getLanguageCompilerSpec().languageID));
        }
        finally {
            program.endTransaction(id, true);
        }
    }

    public static void markAsFunction(Program program, String name, Address funcStart) {
        FunctionManager functionMgr = program.getFunctionManager();
        if (functionMgr.getFunctionAt(funcStart) != null) {
            return;
        }
        try {
            functionMgr.createFunction(name, funcStart, (AddressSetView)new AddressSet(funcStart, funcStart), SourceType.IMPORTED);
        }
        catch (InvalidInputException invalidInputException) {
        }
        catch (OverlappingFunctionException overlappingFunctionException) {
            // empty catch block
        }
    }

    public static Address addExternalBlock(Program program, long size, MessageLog log) throws Exception {
        Address ret;
        Memory mem = program.getMemory();
        MemoryBlock externalBlock = mem.getBlock("EXTERNAL");
        if (externalBlock != null) {
            ret = externalBlock.getEnd().add(1L);
            MemoryBlock newBlock = mem.createBlock(externalBlock, "EXTERNAL", ret, size);
            mem.join(externalBlock, newBlock);
        } else {
            ret = MachoProgramUtils.getNextAvailableAddress(program);
            externalBlock = mem.createUninitializedBlock("EXTERNAL", ret, size, false);
            externalBlock.setWrite(true);
            externalBlock.setArtificial(true);
            externalBlock.setComment("NOTE: This block is artificial and is used to make relocations work correctly");
        }
        return ret;
    }

    protected LanguageService getLanguageService() {
        return DefaultLanguageService.getLanguageService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyProcessorLabels(List<Option> options, Program program) {
        int id = program.startTransaction("Finalize load");
        try {
            Language lang = program.getLanguage();
            for (Register reg : lang.getRegisters()) {
                Address addr = reg.getAddress();
                if (!addr.isMemoryAddress()) continue;
                AbstractProgramLoader.createSymbol(program, reg.getName(), addr, null, false, true, true);
            }
            if (this.shouldApplyProcessorLabels(options)) {
                boolean anchorSymbols = this.shouldAnchorSymbols(options);
                List labels = lang.getDefaultSymbols();
                for (AddressLabelInfo info : labels) {
                    AbstractProgramLoader.createSymbol(program, info.getLabel(), info.getAddress(), info.getDescription(), info.isEntry(), info.isPrimary(), anchorSymbols);
                }
            }
            GhidraProgramUtilities.resetAnalysisFlags(program);
        }
        finally {
            program.endTransaction(id, true);
        }
    }

    private static void createSymbol(Program program, String labelname, Address address, String comment, boolean isEntry, boolean isPrimary, boolean anchorSymbols) {
        SymbolTable symTable = program.getSymbolTable();
        Address addr = address;
        Symbol s = symTable.getPrimarySymbol(addr);
        try {
            Namespace namespace = program.getGlobalNamespace();
            s = symTable.createLabel(addr, labelname, namespace, SourceType.IMPORTED);
            if (comment != null) {
                program.getListing().setComment(address, CommentType.EOL, comment);
            }
            if (isEntry) {
                symTable.addExternalEntryPoint(addr);
            }
            if (isPrimary) {
                s.setPrimary();
            }
            if (anchorSymbols) {
                s.setPinned(true);
            }
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
    }

    private static String computeBinaryMD5(ByteProvider provider) throws IOException {
        try (InputStream in = provider.getInputStream(0L);){
            String string = MD5Utilities.getMD5Hash((InputStream)in);
            return string;
        }
    }

    private static String computeBinarySHA256(ByteProvider provider) throws IOException {
        try (InputStream in = provider.getInputStream(0L);){
            String string = HashUtilities.getHash((String)HashUtilities.SHA256_ALGORITHM, (InputStream)in);
            return string;
        }
    }

    private boolean shouldSetImageBase(Program prog, Address imageBase) {
        if (imageBase == null || imageBase instanceof SegmentedAddress) {
            return false;
        }
        return imageBase.getAddressSpace() == prog.getAddressFactory().getDefaultAddressSpace();
    }

    private boolean shouldApplyProcessorLabels(List<Option> options) {
        return OptionUtils.getBooleanOptionValue(APPLY_LABELS_OPTION_NAME, options, true);
    }

    private boolean shouldAnchorSymbols(List<Option> options) {
        return OptionUtils.getBooleanOptionValue(ANCHOR_LABELS_OPTION_NAME, options, true);
    }
}

