/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.navigation;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.ReusableDialogComponentProvider;
import docking.widgets.GHyperlinkComponent;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GhidraComboBox;
import ghidra.app.nav.Navigatable;
import ghidra.app.services.GoToOverrideService;
import ghidra.app.services.GoToService;
import ghidra.app.services.GoToServiceListener;
import ghidra.app.services.QueryData;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.util.HelpLocation;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class GoToAddressLabelDialog
extends ReusableDialogComponentProvider
implements GoToServiceListener {
    private static final String DIALOG_TITLE = "Go To ...";
    private static final String EXPRESSION_ANCHOR_NAME = "GoTo_Expression";
    private static final String FILE_OFFSET_ANCHOR_NAME = "GoTo_File_Offset";
    private static final int DEFAULT_MAX_GOTO_ENTRIES = 10;
    private Plugin plugin;
    private JPanel mainPanel;
    private Address currentAddress;
    private GhidraComboBox<String> comboBox;
    private List<String> history = new LinkedList<String>();
    private JCheckBox caseSensitiveBox;
    private boolean cStyleInput = false;
    private GoToService goToService;
    private boolean goToMemory = true;
    private Navigatable navigatable;
    private GHyperlinkComponent hyperlink;
    private JCheckBox includeDynamicBox;

    public GoToAddressLabelDialog(GoToService gotoService, Plugin plugin) {
        super(DIALOG_TITLE, true, true, true, true);
        this.goToService = gotoService;
        this.setHelpLocation(new HelpLocation("Navigation", "Go_To_Address_Label"));
        this.plugin = plugin;
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addCancelButton();
        this.setMinimumSize(this.getPreferredSize());
    }

    public void show(Navigatable nav, Address addr, PluginTool tool) {
        JComponent comp;
        this.navigatable = nav;
        this.currentAddress = addr;
        this.clearStatusText();
        GoToOverrideService override = this.goToService.getOverrideService();
        if (override != null && (comp = override.getOverrideComponent()) != null) {
            this.mainPanel.add((Component)comp, "South");
        }
        this.setDialogEnabled(true);
        tool.showDialog((DialogComponentProvider)this);
    }

    protected void dialogShown() {
        this.initializeContents();
    }

    public void close() {
        TaskMonitorComponent monitor = this.getTaskMonitorComponent();
        if (monitor != null) {
            monitor.cancel();
        }
        this.clearAll();
        super.close();
    }

    @Override
    public void gotoCompleted(String queryString, boolean foundResults) {
        this.navigatable = null;
        this.setDialogEnabled(true);
        if (foundResults) {
            this.close();
            this.addToHistory(queryString);
        } else {
            this.setStatusText("No results for " + queryString);
            this.initializeContents();
        }
    }

    @Override
    public void gotoFailed(Exception exc) {
        this.navigatable = null;
        this.setDialogEnabled(true);
        this.setStatusText("ERROR: " + exc.getMessage());
        this.initializeContents();
    }

    private void initializeContents() {
        if (this.goToMemory) {
            this.comboBox.selectAll();
            this.comboBox.requestFocus();
        } else {
            this.comboBox.setSelectedItem(null);
        }
    }

    protected final JPanel buildMainPanel() {
        JPanel inner = new JPanel();
        GridBagLayout gl = new GridBagLayout();
        inner.setLayout(gl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.hyperlink = new GHyperlinkComponent();
        this.hyperlink.addText("Enter an address, label, ");
        this.hyperlink.addLink("expression,", () -> {
            HelpLocation loc = new HelpLocation("Navigation", EXPRESSION_ANCHOR_NAME);
            DockingWindowManager.getHelpService().showHelp(loc);
        });
        this.hyperlink.addText(" or ");
        this.hyperlink.addLink("file offset:", () -> {
            HelpLocation loc = new HelpLocation("Navigation", FILE_OFFSET_ANCHOR_NAME);
            DockingWindowManager.getHelpService().showHelp(loc);
        });
        inner.add((Component)this.hyperlink, gbc);
        this.comboBox = new GhidraComboBox();
        this.comboBox.setEditable(true);
        String comboName = "Go To Address or Label Text Field / Combobox";
        this.comboBox.setName(comboName);
        this.comboBox.getAccessibleContext().setAccessibleName(comboName);
        gbc.insets = new Insets(2, 5, 2, 0);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        inner.add((Component)this.comboBox, gbc);
        this.caseSensitiveBox = new GCheckBox("Case sensitive", false);
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        String caseSensitiveCheckBoxName = "Case Sensitive Checkbox";
        this.caseSensitiveBox.setName(caseSensitiveCheckBoxName);
        this.caseSensitiveBox.getAccessibleContext().setAccessibleName(caseSensitiveCheckBoxName);
        inner.add((Component)this.caseSensitiveBox, gbc);
        this.includeDynamicBox = new GCheckBox("Dynamic labels", true);
        this.includeDynamicBox.setToolTipText("Include dynamic labels in the search (slower)");
        gbc.gridx = 1;
        inner.add((Component)this.includeDynamicBox, gbc);
        String dynamicCheckBoxName = "Dynamic Checkbox";
        this.includeDynamicBox.setName(dynamicCheckBoxName);
        this.includeDynamicBox.getAccessibleContext().setAccessibleName(dynamicCheckBoxName);
        this.mainPanel = new JPanel(new BorderLayout());
        Border emptyBorder = BorderFactory.createEmptyBorder(5, 5, 0, 5);
        this.mainPanel.setBorder(emptyBorder);
        this.mainPanel.add((Component)inner, "North");
        return this.mainPanel;
    }

    private void writeHistory(SaveState saveState) {
        String[] strs = new String[this.history.size()];
        strs = this.history.toArray(strs);
        saveState.putStrings("GO_TO_HISTORY", strs);
    }

    private void readHistory(SaveState saveState) {
        String[] strs = saveState.getStrings("GO_TO_HISTORY", null);
        if (strs != null) {
            for (String str : strs) {
                if (this.history.contains(str)) continue;
                this.history.add(str);
            }
            this.truncateHistoryAsNeeded();
            this.updateCombo();
        }
    }

    public void readConfigState(SaveState saveState) {
        this.readHistory(saveState);
        boolean caseSensitive = saveState.getBoolean("CASE_SENSITIVE", false);
        this.caseSensitiveBox.setSelected(caseSensitive);
        boolean includeDynamic = saveState.getBoolean("INCLUDE_DYNAMIC", true);
        this.includeDynamicBox.setSelected(includeDynamic);
    }

    public void writeConfigState(SaveState saveState) {
        this.writeHistory(saveState);
        saveState.putBoolean("CASE_SENSITIVE", this.caseSensitiveBox.isSelected());
        saveState.putBoolean("INCLUDE_DYNAMIC", this.includeDynamicBox.isSelected());
    }

    public final void okCallback() {
        String input = this.comboBox.getText().trim();
        if (this.cStyleInput) {
            input = this.parseNumber(input);
        }
        if (input.length() == 0) {
            this.escapeCallback();
            return;
        }
        this.setDialogEnabled(false);
        this.setStatusText("Searching... Please wait.");
        this.goToService.goToQuery(this.navigatable, this.currentAddress, new QueryData(input, this.caseSensitiveBox.isSelected(), this.includeDynamicBox.isSelected()), this, (TaskMonitor)this.getTaskMonitorComponent());
    }

    private void setDialogEnabled(boolean enable) {
        this.setOkEnabled(enable);
        this.caseSensitiveBox.setEnabled(enable);
        if (enable) {
            this.setCursor(Cursor.getDefaultCursor());
        } else {
            this.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    private String parseNumber(String input) {
        try {
            if (input.startsWith("0x")) {
                return input;
            }
            if (input.startsWith("0")) {
                return Integer.toString(Integer.parseInt(input, 8), 16);
            }
            if (input.toLowerCase().endsWith("b")) {
                return Integer.toString(Integer.parseInt(input.substring(0, input.length() - 1), 2), 16);
            }
            return Integer.toString(Integer.parseInt(input, 10), 16);
        }
        catch (Exception e) {
            return input;
        }
    }

    public void maxEntrysChanged() {
        this.truncateHistoryAsNeeded();
        this.updateCombo();
    }

    private void truncateHistoryAsNeeded() {
        ToolOptions opt = this.plugin.getTool().getOptions("Tool");
        int maxEntries = opt.getInt("Max Goto Entries", 10);
        int historySize = this.history.size();
        if (historySize > maxEntries) {
            int numToRemove = historySize - maxEntries;
            for (int i = 0; i < numToRemove; ++i) {
                this.history.remove(this.history.size() - 1);
            }
        }
    }

    private void addToHistory(String input) {
        this.history.remove(input);
        this.history.add(0, input);
        this.truncateHistoryAsNeeded();
        this.updateCombo();
    }

    private void updateCombo() {
        String[] historyElements = new String[this.history.size()];
        this.history.toArray(historyElements);
        this.comboBox.setModel(new DefaultComboBoxModel<String>(historyElements));
    }

    private void clearAll() {
        this.comboBox.setSelectedItem((Object)"");
        this.setStatusText("");
    }

    public void setCaseSensitive(boolean b) {
        this.caseSensitiveBox.setSelected(false);
    }

    public List<String> getHistory() {
        return this.history;
    }

    public void setCStyleInput(boolean cStyleInput) {
        this.cStyleInput = cStyleInput;
    }

    public void setMemory(boolean goToMemory) {
        this.goToMemory = goToMemory;
    }

    public void setText(String text) {
        this.comboBox.setText(text);
    }
}

