/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.headless;

import generic.stl.Pair;
import ghidra.GhidraApplicationLayout;
import ghidra.GhidraLaunchable;
import ghidra.GhidraLauncher;
import ghidra.app.util.headless.HeadlessAnalyzer;
import ghidra.app.util.headless.HeadlessOptions;
import ghidra.app.util.importer.LibrarySearchPathManager;
import ghidra.framework.Application;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.framework.protocol.ghidra.Handler;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.exception.InvalidInputException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class AnalyzeHeadless
implements GhidraLaunchable {
    private static final int EXIT_CODE_ERROR = 1;

    public void launch(GhidraApplicationLayout layout, String[] args) throws Exception {
        int optionStartIndex;
        String projectName = null;
        String rootFolderPath = null;
        URL ghidraURL = null;
        ArrayList<File> filesToImport = new ArrayList<File>();
        if (args.length < 1) {
            this.usage();
        }
        Handler.registerHandler();
        if (args[0].startsWith("ghidra:")) {
            optionStartIndex = 1;
            try {
                ghidraURL = new URI(args[0]).toURL();
            }
            catch (MalformedURLException e) {
                System.err.println("Invalid Ghidra URL: " + args[0]);
                this.usage();
            }
        } else {
            if (args.length < 2) {
                this.usage();
            }
            optionStartIndex = 2;
            String projectNameAndFolder = args[1];
            projectName = projectNameAndFolder = projectNameAndFolder.replaceAll("\\\\", "/");
            rootFolderPath = "/";
            int folderIndex = projectNameAndFolder.indexOf("/");
            if (folderIndex == 0) {
                System.err.println(args[1] + " is an invalid project_name/folder_path.");
                this.usage();
            } else if (folderIndex > 0) {
                projectName = projectNameAndFolder.substring(0, folderIndex);
                rootFolderPath = projectNameAndFolder.substring(folderIndex);
            }
        }
        File logFile = null;
        File scriptLogFile = null;
        for (int argi = optionStartIndex; argi < args.length; ++argi) {
            if (this.checkArgument(Arg.LOG, args, argi)) {
                logFile = new File(args[++argi]);
                continue;
            }
            if (!this.checkArgument(Arg.SCRIPT_LOG, args, argi)) continue;
            scriptLogFile = new File(args[++argi]);
        }
        HeadlessAnalyzer analyzer = null;
        analyzer = Application.isInitialized() ? HeadlessAnalyzer.getInstance() : HeadlessAnalyzer.getLoggableInstance(logFile, scriptLogFile, true);
        HeadlessOptions options = analyzer.getOptions();
        this.parseOptions(options, args, optionStartIndex, ghidraURL, filesToImport);
        Msg.info(AnalyzeHeadless.class, (Object)("Headless startup complete (" + GhidraLauncher.getMillisecondsFromLaunch() + " ms)"));
        ClassSearcher.logStatistics();
        try {
            if (ghidraURL != null) {
                analyzer.processURL(ghidraURL, filesToImport);
            } else {
                analyzer.processLocal(args[0], projectName, rootFolderPath, filesToImport);
            }
        }
        catch (Throwable e) {
            Msg.error(HeadlessAnalyzer.class, (Object)("Abort due to Headless analyzer error: " + e.getMessage()), (Throwable)e);
            System.exit(1);
        }
    }

    private void parseOptions(HeadlessOptions options, String[] args, int startIndex, URL ghidraURL, List<File> filesToImport) throws InvalidInputException {
        String loaderName = null;
        LinkedList<Pair<String, String>> loaderArgs = new LinkedList<Pair<String, String>>();
        String languageId = null;
        String compilerSpecId = null;
        String keystorePath = null;
        String userId = null;
        boolean allowPasswordPrompt = false;
        LinkedList<Pair<String, String[]>> preScripts = new LinkedList<Pair<String, String[]>>();
        LinkedList<Pair<String, String[]>> postScripts = new LinkedList<Pair<String, String[]>>();
        block8: for (int argi = startIndex; argi < args.length; ++argi) {
            String[] scriptArgs;
            String scriptName;
            String arg = args[argi];
            if (this.checkArgument(Arg.LOG, args, argi)) {
                ++argi;
                continue;
            }
            if (this.checkArgument(Arg.SCRIPT_LOG, args, argi)) {
                ++argi;
                continue;
            }
            if (this.checkArgument(Arg.OVERWRITE, args, argi)) {
                options.enableOverwriteOnConflict(true);
                continue;
            }
            if (this.checkArgument(Arg.MIRROR, args, argi)) {
                options.enableMirroring(true);
                continue;
            }
            if (this.checkArgument(Arg.NO_ANALYSIS, args, argi)) {
                options.enableAnalysis(false);
                continue;
            }
            if (this.checkArgument(Arg.DELETE_PROJECT, args, argi)) {
                options.setDeleteCreatedProjectOnClose(true);
                continue;
            }
            if (this.checkArgument(Arg.LOADER, args, argi)) {
                loaderName = args[++argi];
                continue;
            }
            if (this.checkArgument(Arg.LOADER_ARGS, args, argi)) {
                if (this.isExistingArg(args[argi + 1])) {
                    throw new InvalidInputException(args[argi] + " expects value to follow.");
                }
                loaderArgs.add((Pair<String, String>)new Pair((Object)arg, (Object)args[++argi]));
                continue;
            }
            if (this.checkArgument(Arg.PROCESSOR, args, argi)) {
                languageId = args[++argi];
                continue;
            }
            if (this.checkArgument(Arg.CSPEC, args, argi)) {
                compilerSpecId = args[++argi];
                continue;
            }
            if (this.checkArgument(Arg.PRE_SCRIPT, args, argi)) {
                scriptName = args[++argi];
                scriptArgs = this.getSubArguments(args, argi);
                argi += scriptArgs.length;
                preScripts.add((Pair<String, String[]>)new Pair((Object)scriptName, (Object)scriptArgs));
                continue;
            }
            if (this.checkArgument(Arg.POST_SCRIPT, args, argi)) {
                scriptName = args[++argi];
                scriptArgs = this.getSubArguments(args, argi);
                argi += scriptArgs.length;
                postScripts.add((Pair<String, String[]>)new Pair((Object)scriptName, (Object)scriptArgs));
                continue;
            }
            if (this.checkArgument(Arg.SCRIPT_PATH, args, argi)) {
                options.setScriptDirectories(args[++argi]);
                continue;
            }
            if (this.checkArgument(Arg.PROPERTIES_PATH, args, argi)) {
                options.setPropertiesFileDirectories(args[++argi]);
                continue;
            }
            if (this.checkArgument(Arg.IMPORT, args, argi)) {
                File inputFile = null;
                try {
                    inputFile = new File(args[++argi]);
                    inputFile = inputFile.getCanonicalFile();
                }
                catch (IOException e) {
                    throw new InvalidInputException("Failed to get canonical form of: " + String.valueOf(inputFile));
                }
                if (!inputFile.isDirectory() && !inputFile.isFile()) {
                    throw new InvalidInputException(String.valueOf(inputFile) + " is not a valid directory or file.");
                }
                HeadlessAnalyzer.checkValidFilename(inputFile.toString());
                filesToImport.add(inputFile);
                while (argi < args.length - 1) {
                    String nextArg;
                    if (this.isExistingArg(nextArg = args[++argi])) {
                        --argi;
                        continue block8;
                    }
                    File otherFile = new File(nextArg).getAbsoluteFile();
                    if (!otherFile.isFile() && !otherFile.isDirectory()) {
                        throw new InvalidInputException(String.valueOf(otherFile) + " is not a valid directory or file.");
                    }
                    HeadlessAnalyzer.checkValidFilename(otherFile.toString());
                    filesToImport.add(otherFile);
                }
                continue;
            }
            if (this.checkArgument(Arg.CONNECT, args, argi)) {
                if (argi + 1 >= args.length || this.isExistingArg(arg = args[argi + 1])) continue;
                userId = arg;
                ++argi;
                continue;
            }
            if (this.checkArgument(Arg.COMMIT, args, argi)) {
                String comment = null;
                if (argi + 1 < args.length && !this.isExistingArg(arg = args[argi + 1])) {
                    comment = arg;
                    ++argi;
                }
                options.setCommitFiles(true, comment);
                continue;
            }
            if (this.checkArgument(Arg.KEYSTORE, args, argi)) {
                File keystore;
                if ((keystore = new File(keystorePath = args[++argi])).isFile()) continue;
                throw new InvalidInputException(keystore.getAbsolutePath() + " is not a valid keystore file.");
            }
            if (this.checkArgument(Arg.PASSWORD, args, argi)) {
                allowPasswordPrompt = true;
                continue;
            }
            if (this.checkArgument(Arg.ANALYSIS_TIMEOUT_PER_FILE, args, argi)) {
                options.setPerFileAnalysisTimeout(args[++argi]);
                continue;
            }
            if (this.checkArgument(Arg.PROCESS, args, argi)) {
                if (options.runScriptsNoImport) {
                    throw new InvalidInputException("The -process option may only be specified once.");
                }
                String processBinary = null;
                if (argi + 1 < args.length && !this.isExistingArg(arg = args[argi + 1])) {
                    processBinary = arg;
                    ++argi;
                }
                options.setRunScriptsNoImport(true, processBinary);
                continue;
            }
            if (this.checkArgument(Arg.RECURSIVE, args, argi)) {
                Integer depth = null;
                if (argi + 1 < args.length && !this.isExistingArg(arg = args[argi + 1])) {
                    try {
                        depth = Integer.parseInt(arg);
                    }
                    catch (NumberFormatException e) {
                        throw new InvalidInputException("Invalid recursion depth: " + depth);
                    }
                    ++argi;
                }
                options.enableRecursiveProcessing(true, depth);
                continue;
            }
            if (this.checkArgument(Arg.READ_ONLY, args, argi)) {
                options.enableReadOnlyProcessing(true);
                continue;
            }
            if (this.checkArgument(Arg.MAX_CPU, args, argi)) {
                String cpuVal = args[++argi];
                try {
                    options.setMaxCpu(Integer.parseInt(cpuVal));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new InvalidInputException("Invalid value for max-cpu: " + cpuVal);
                }
            }
            if (this.checkArgument(Arg.OK_TO_DELETE, args, argi)) {
                options.setOkToDelete(true);
                continue;
            }
            if (this.checkArgument(Arg.LIBRARY_SEARCH_PATHS, args, argi)) {
                LibrarySearchPathManager.setLibraryPaths(args[++argi].split(";"));
                continue;
            }
            if (this.isExistingArg(args[argi])) {
                throw new AssertionError((Object)("Valid option was not processed: " + args[argi]));
            }
            throw new InvalidInputException("Bad argument: " + arg);
        }
        options.setPreScriptsWithArgs(preScripts);
        options.setPostScriptsWithArgs(postScripts);
        options.setLoader(loaderName);
        options.setLoaderArgs(loaderArgs);
        options.setLanguageAndCompiler(languageId, compilerSpecId);
        try {
            options.setClientCredentials(userId, keystorePath, allowPasswordPrompt);
        }
        catch (IOException e) {
            throw new InvalidInputException("Failed to install Ghidra Server authenticator: " + e.getMessage());
        }
        if (options.runScriptsNoImport) {
            if (filesToImport != null && filesToImport.size() > 0) {
                System.err.print("Must use either -process or -import parameters, but not both.");
                System.err.print(" -process runs scripts over existing program(s) in a project, whereas -import");
                System.err.println(" imports new programs and runs scripts and/or analyzes them after import.");
                System.exit(1);
            }
            if (options.overwrite) {
                Msg.warn(HeadlessAnalyzer.class, (Object)"The -overwrite parameter does not apply to -process mode.  Ignoring overwrite and continuing.");
            }
            if (options.readOnly && options.okToDelete) {
                System.err.println("You have specified the conflicting parameters -readOnly and -okToDelete. Please pick one and try again.");
                System.exit(1);
            }
        } else if (filesToImport == null || filesToImport.size() == 0) {
            if (options.preScripts.isEmpty() && options.postScripts.isEmpty()) {
                System.err.println("Nothing to do ... must specify -import, -process, or prescript and/or postscript.");
                System.exit(1);
            } else {
                Msg.warn(HeadlessAnalyzer.class, (Object)"Neither the -import parameter nor the -process parameter was specified; therefore, the specified prescripts and/or postscripts will be executed without any type of program context.");
            }
        }
        if (options.commit && options.readOnly) {
            System.err.println("Can not use -commit and -readOnly at the same time.");
            System.exit(1);
        }
        if (!options.commit && ghidraURL != null) {
            if (!options.readOnly) {
                options.setCommitFiles(true, null);
            } else {
                Msg.warn(HeadlessAnalyzer.class, (Object)"-readOnly mode is on: for -process, changes will not be saved.");
            }
        }
    }

    public static void usage(String execCmd) {
        StringBuilder sb = new StringBuilder();
        String INDENT = "           ";
        sb.append("Headless Analyzer Usage: %s\n".formatted(execCmd));
        sb.append("           <project_location> <project_name>[/<folder_path>]\n");
        sb.append("             | ghidra://<server>[:<port>]/<repository_name>[/<folder_path>]\n");
        block5: for (Arg arg : Arg.values()) {
            switch (arg.ordinal()) {
                case 0: {
                    sb.append("           " + "[[%s] | [%s]]\n".formatted(arg.usage(), Arg.PROCESS.usage()));
                    continue block5;
                }
                case 1: {
                    continue block5;
                }
                case 25: {
                    sb.append("           " + "[%s<loader argument name> %s]\n".formatted(Arg.LOADER_ARGS.name, Arg.LOADER_ARGS.subArgFormat));
                    continue block5;
                }
                default: {
                    sb.append("           " + "[%s]\n".formatted(arg.usage()));
                }
            }
        }
        if (Platform.CURRENT_PLATFORM.getOperatingSystem() != OperatingSystem.WINDOWS) {
            sb.append("\n");
            sb.append("     - All uses of $GHIDRA_HOME or $USER_HOME in script path must be preceded by '\\'\n");
        }
        sb.append("\n");
        sb.append("Please refer to 'analyzeHeadlessREADME.html' for detailed usage examples and notes.\n");
        sb.append("\n");
        System.out.println(sb);
        System.exit(1);
    }

    private void usage() {
        AnalyzeHeadless.usage("analyzeHeadless");
    }

    private String[] getSubArguments(String[] args, int argi) {
        ArrayList<String> subArgs = new ArrayList<String>();
        int i = argi + 1;
        while (i < args.length && !this.isExistingArg(args[i])) {
            subArgs.add(args[i++]);
        }
        return subArgs.toArray(new String[subArgs.size()]);
    }

    private boolean checkArgument(Arg arg, String[] args, int argi) throws InvalidInputException {
        if (!arg.matches(args[argi])) {
            return false;
        }
        if (arg.requiresSubArgs && argi + 1 == args.length) {
            throw new InvalidInputException(args[argi] + " requires an argument");
        }
        return true;
    }

    private boolean isExistingArg(String s) {
        return Arrays.stream(Arg.values()).anyMatch(e -> e.matches(s));
    }

    private static enum Arg {
        IMPORT("-import", true, "[<directory>|<file>]+"),
        PROCESS("-process", true, "[<project_file>]"),
        PRE_SCRIPT("-preScript", true, "<ScriptName>"),
        POST_SCRIPT("-postScript", true, "<ScriptName>"),
        SCRIPT_PATH("-scriptPath", true, "\"<path1>[;<path2>...]\""),
        PROPERTIES_PATH("-propertiesPath", true, "\"<path1>[;<path2>...]\""),
        SCRIPT_LOG("-scriptlog", true, "<path to script log file>"),
        LOG("-log", true, "<path to log file>"),
        OVERWRITE("-overwrite", false),
        MIRROR("-mirror", false),
        RECURSIVE("-recursive", false),
        READ_ONLY("-readOnly", false),
        DELETE_PROJECT("-deleteProject", false),
        NO_ANALYSIS("-noanalysis", false),
        PROCESSOR("-processor", true, "<languageID>"),
        CSPEC("-cspec", true, "<compilerSpecID>"),
        ANALYSIS_TIMEOUT_PER_FILE("-analysisTimeoutPerFile", true, "<timeout in seconds>"),
        KEYSTORE("-keystore", true, "<KeystorePath>"),
        CONNECT("-connect", false, "[<userID>]"),
        PASSWORD("-p", false),
        COMMIT("-commit", false, "[\"<comment>\"]]"),
        OK_TO_DELETE("-okToDelete", false),
        MAX_CPU("-max-cpu", true, "<max cpu cores to use>"),
        LIBRARY_SEARCH_PATHS("-librarySearchPaths", true, "<path1>[;<path2>...]"),
        LOADER("-loader", true, "<desired loader name>"),
        LOADER_ARGS("-loader-", true, "<loader argument value>"){

            @Override
            public boolean matches(String arg) {
                return arg.startsWith("-loader-");
            }
        };

        private String name;
        private boolean requiresSubArgs;
        private String subArgFormat;

        private Arg(String name, boolean requiresSubArgs, String subArgFormat) {
            this.name = name;
            this.requiresSubArgs = requiresSubArgs;
            this.subArgFormat = subArgFormat;
        }

        private Arg(String name, boolean requiresSubArgs) {
            this(name, requiresSubArgs, "");
        }

        public String usage() {
            return "%s%s%s".formatted(this.name, this.subArgFormat.isEmpty() ? "" : " ", this.subArgFormat);
        }

        public boolean matches(String arg) {
            return arg.equalsIgnoreCase(this.name);
        }

        public String toString() {
            return this.name;
        }
    }
}

