/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objectiveC;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Constants;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Utilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ObjectiveC1_InstanceVariable
implements StructConverter {
    private ObjectiveC1_State _state;
    private long _index;
    private String name;
    private String type;
    private int offset;

    ObjectiveC1_InstanceVariable(ObjectiveC1_State state, BinaryReader reader) throws IOException {
        this._state = state;
        this._index = reader.getPointerIndex();
        this.name = ObjectiveC1_Utilities.dereferenceAsciiString(reader, state.is32bit);
        this.type = ObjectiveC1_Utilities.dereferenceAsciiString(reader, state.is32bit);
        this.offset = reader.readNextInt();
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("objc_ivar", 0);
        struct.setCategoryPath(ObjectiveC1_Constants.CATEGORY_PATH);
        struct.add((DataType)PointerDataType.getPointer((DataType)ASCII, (int)this._state.pointerSize), "ivar_name", null);
        struct.add((DataType)PointerDataType.getPointer((DataType)ASCII, (int)this._state.pointerSize), "ivar_type", null);
        struct.add(DWORD, "ivar_offset", null);
        return struct;
    }

    public void applyTo() throws Exception {
        if (this._state.beenApplied.contains(this._index)) {
            return;
        }
        this._state.beenApplied.add(this._index);
        Address address = this._state.program.getAddressFactory().getDefaultAddressSpace().getAddress(this._index);
        DataType dt = this.toDataType();
        this._state.program.getListing().clearCodeUnits(address, address.add((long)(dt.getLength() - 1)), false);
        this._state.program.getListing().createData(address, dt);
    }
}

