/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands.dyld;

import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.Section;
import ghidra.app.util.bin.format.macho.commands.DynamicSymbolTableCommand;
import ghidra.app.util.bin.format.macho.commands.NList;
import ghidra.app.util.bin.format.macho.commands.SymbolTableCommand;
import ghidra.app.util.bin.format.macho.commands.dyld.AbstractClassicProcessor;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class ClassicLazyBindProcessor
extends AbstractClassicProcessor {
    public ClassicLazyBindProcessor(MachHeader header, Program program) {
        super(header, program);
    }

    public void process(TaskMonitor monitor) throws Exception {
        SymbolTableCommand symbolTableCommand = this.header.getFirstLoadCommand(SymbolTableCommand.class);
        List<DynamicSymbolTableCommand> commands = this.header.getLoadCommands(DynamicSymbolTableCommand.class);
        for (DynamicSymbolTableCommand command : commands) {
            if (monitor.isCancelled()) break;
            List<Section> sections = this.header.getAllSections();
            for (Section section : sections) {
                String segmentName;
                String sectionName;
                long address;
                String fromDylib;
                boolean isWeak;
                NList nList;
                int symbolIndex;
                int i;
                long count;
                int indirectOffset;
                if (monitor.isCancelled()) {
                    return;
                }
                if (section.getSize() == 0L) continue;
                int sectionType = section.getFlags() & 0xFF;
                if (sectionType == 7) {
                    indirectOffset = section.getReserved1();
                    count = section.getSize() / (long)this.program.getDefaultPointerSize();
                    i = 0;
                    while ((long)i < count) {
                        symbolIndex = command.getIndirectSymbols().get(indirectOffset + i);
                        nList = symbolTableCommand.getSymbolAt(symbolIndex);
                        isWeak = (nList.getDescription() & 0x40) != 0;
                        fromDylib = this.getClassicOrdinalName(nList.getLibraryOrdinal());
                        address = section.getAddress() + (long)(i * this.program.getDefaultPointerSize());
                        sectionName = section.getSectionName();
                        segmentName = section.getSegmentName();
                        this.perform(segmentName, sectionName, address, fromDylib, nList, isWeak, monitor);
                        ++i;
                    }
                    continue;
                }
                if (sectionType != 8 || (section.getFlags() & 0x4000000) == 0 || section.getReserved2() != 5) continue;
                indirectOffset = section.getReserved1();
                count = section.getSize() / 5L;
                i = 0;
                while ((long)i < count) {
                    symbolIndex = command.getIndirectSymbols().get(indirectOffset + i);
                    if (symbolIndex != 0x40000000) {
                        nList = symbolTableCommand.getSymbolAt(symbolIndex);
                        isWeak = (nList.getDescription() & 0x40) != 0;
                        fromDylib = this.getClassicOrdinalName(nList.getLibraryOrdinal());
                        address = section.getAddress() + (long)(i * 5);
                        sectionName = section.getSectionName();
                        segmentName = section.getSegmentName();
                        this.perform(segmentName, sectionName, address, fromDylib, nList, isWeak, monitor);
                    }
                    ++i;
                }
            }
        }
    }
}

