/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.info;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfProgramHeader;
import ghidra.app.util.bin.format.elf.info.ElfComment;
import ghidra.app.util.bin.format.elf.info.ElfInfoItem;
import ghidra.app.util.bin.format.elf.info.ElfInfoProducer;
import ghidra.app.util.bin.format.elf.info.ElfNote;
import ghidra.app.util.bin.format.elf.info.GnuBuildAttributes;
import ghidra.app.util.bin.format.elf.info.GnuDebugLink;
import ghidra.app.util.bin.format.elf.info.NoteAbiTag;
import ghidra.app.util.bin.format.elf.info.NoteGnuBuildId;
import ghidra.app.util.bin.format.elf.info.NoteGnuProperty;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.classfinder.ExtensionPointProperties;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Map;

@ExtensionPointProperties(priority=-1000)
public class StandardElfInfoProducer
implements ElfInfoProducer {
    public static final CategoryPath ELF_CATEGORYPATH = new CategoryPath("/ELF");
    private static final Map<String, ElfInfoItem.ReaderFunc<ElfInfoItem>> STANDARD_READERS = Map.of(".gnu_debuglink", GnuDebugLink::read, ".note.ABI-tag", (br, prg) -> NoteAbiTag.read(ElfNote.read(br), prg), ".note.gnu.build-id", (br, prg) -> NoteGnuBuildId.read(ElfNote.read(br), prg), ".note.gnu.property", (br, prg) -> NoteGnuProperty.read(ElfNote.read(br), prg), ".comment", ElfComment::read, ".gnu.build.attributes", GnuBuildAttributes::read);
    private ElfLoadHelper elfLoadHelper;

    @Override
    public void init(ElfLoadHelper elfLoadHelper) {
        this.elfLoadHelper = elfLoadHelper;
    }

    @Override
    public void markupElfInfo(TaskMonitor monitor) throws CancelledException {
        Program program = this.elfLoadHelper.getProgram();
        for (Map.Entry<String, ElfInfoItem.ReaderFunc<ElfInfoItem>> noteEntry : STANDARD_READERS.entrySet()) {
            monitor.checkCancelled();
            String sectionName = noteEntry.getKey();
            ElfInfoItem.ReaderFunc<ElfInfoItem> readFunc = noteEntry.getValue();
            ElfInfoItem.markupElfInfoItemSection(program, sectionName, readFunc);
        }
        this.markupPtNoteSegments(monitor);
    }

    private void markupPtNoteSegments(TaskMonitor monitor) throws CancelledException {
        Program program = this.elfLoadHelper.getProgram();
        Memory memory = program.getMemory();
        for (ElfProgramHeader elfProgramHeader : this.elfLoadHelper.getElfHeader().getProgramHeaders(4)) {
            monitor.checkCancelled();
            Address addr = this.elfLoadHelper.findLoadAddress(elfProgramHeader, 0L);
            if (addr == null) {
                this.elfLoadHelper.log("Failed to identify PT_NOTE load address");
                continue;
            }
            try {
                long loadSize;
                Address endAddr = null;
                MemoryBlock memBlock = memory.getBlock(addr);
                if (memBlock != null && (loadSize = elfProgramHeader.getAdjustedLoadSize()) > 0L) {
                    endAddr = addr.add(loadSize - 1L);
                }
                if (endAddr == null) {
                    this.elfLoadHelper.log("Failed to markup non-loaded PT_NOTE at " + String.valueOf(addr));
                    continue;
                }
                try (MemoryByteProvider bp = new MemoryByteProvider(program.getMemory(), addr, endAddr);){
                    BinaryReader br = new BinaryReader(bp, !program.getMemory().isBigEndian());
                    this.markupPtNote(br, program, addr, monitor);
                }
            }
            catch (Exception e) {
                this.elfLoadHelper.log("Failed to parse and markup ELF Note starting at " + String.valueOf(addr));
            }
        }
    }

    private void markupPtNote(BinaryReader br, Program program, Address noteAddr, TaskMonitor monitor) throws CancelledException, AddressOutOfBoundsException, IOException {
        while (br.hasNext()) {
            monitor.checkCancelled();
            long start = br.getPointerIndex();
            ElfNote note = br.readNext(ElfNote::read);
            br.align(4);
            long noteLength = br.getPointerIndex() - start;
            if (DataUtilities.isUndefinedData((Program)program, (Address)noteAddr)) {
                try {
                    StructureDataType struct = note.toStructure((DataTypeManager)program.getDataTypeManager());
                    DataUtilities.createData((Program)program, (Address)noteAddr, (DataType)struct, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA);
                    String comment = "ELF Note \"%s\", %xh".formatted(note.getName(), note.getVendorType());
                    program.getListing().setComment(noteAddr, CommentType.EOL, comment);
                }
                catch (CodeUnitInsertionException e) {
                    this.elfLoadHelper.log("Failed to markup ELF Note at " + String.valueOf(noteAddr) + ": data conflict");
                }
            }
            noteAddr = noteAddr.add(noteLength);
        }
    }
}

