/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.sectionprovider;

import ghidra.app.util.Option;
import ghidra.app.util.bin.FileByteProvider;
import ghidra.app.util.bin.format.dwarf.external.ExternalDebugFilesService;
import ghidra.app.util.bin.format.dwarf.external.ExternalDebugInfo;
import ghidra.app.util.bin.format.dwarf.sectionprovider.BaseSectionProvider;
import ghidra.app.util.bin.format.dwarf.sectionprovider.DWARFSectionProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.ElfLoader;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.plugin.importer.ImporterUtilities;
import ghidra.program.database.ProgramDB;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.nio.file.AccessMode;
import java.util.List;

public class ExternalDebugFileSectionProvider
extends BaseSectionProvider {
    public static final String PROGRAM_INFO_DWARF_EXTERNAL_DEBUG_FILE = "DWARF External Debug File";
    private final FSRL externalDebugFileLocation;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DWARFSectionProvider createExternalSectionProviderFor(Program program, TaskMonitor monitor) {
        try {
            ExternalDebugInfo extDebugInfo = ExternalDebugInfo.fromProgram(program);
            if (extDebugInfo == null) {
                return null;
            }
            Msg.info(ExternalDebugFileSectionProvider.class, (Object)("DWARF external debug information found: " + String.valueOf(extDebugInfo)));
            ExternalDebugFilesService edfs = ExternalDebugFilesService.forProgram(program);
            File extDebugFile = edfs.find(extDebugInfo, monitor);
            if (extDebugFile == null) {
                return null;
            }
            Msg.info(ExternalDebugFileSectionProvider.class, (Object)("DWARF External Debug File: found: " + String.valueOf(extDebugFile)));
            FSRL fsrl = FileSystemService.getInstance().getLocalFSRL(extDebugFile);
            try (FileByteProvider debugFileByteProvider = new FileByteProvider(extDebugFile, fsrl, AccessMode.READ);){
                Object consumer = new Object();
                Language lang = program.getLanguage();
                LoadSpec origLoadSpec = ImporterUtilities.getLoadSpec(program);
                if (origLoadSpec == null) {
                    DWARFSectionProvider dWARFSectionProvider = null;
                    return dWARFSectionProvider;
                }
                CompilerSpec compSpec = origLoadSpec.getLanguageCompilerSpec().getCompilerSpec();
                ProgramDB debugProgram = new ProgramDB("temp external debug info for " + program.getName(), lang, compSpec, consumer);
                Loader origLoader = origLoadSpec.getLoader();
                List<Option> defaultOptions = origLoader.getDefaultOptions(debugFileByteProvider, origLoadSpec, (DomainObject)debugProgram, false, false);
                ElfLoader elfLoader = new ElfLoader();
                Loader.ImporterSettings settings = new Loader.ImporterSettings(debugFileByteProvider, debugProgram.getName(), null, null, false, origLoadSpec, defaultOptions, consumer, new MessageLog(), monitor);
                elfLoader.load((Program)debugProgram, settings);
                ExternalDebugFileSectionProvider result = new ExternalDebugFileSectionProvider((Program)debugProgram, debugFileByteProvider.getFSRL());
                debugProgram.release(consumer);
                ExternalDebugFileSectionProvider externalDebugFileSectionProvider = result;
                return externalDebugFileSectionProvider;
            }
        }
        catch (CancelledException | IOException throwable3) {
            return null;
        }
    }

    ExternalDebugFileSectionProvider(Program program, FSRL externalDebugFileLocation) {
        super(program);
        this.externalDebugFileLocation = externalDebugFileLocation;
        program.addConsumer((Object)this);
    }

    @Override
    public void close() {
        if (this.program != null) {
            this.program.release((Object)this);
        }
        super.close();
        this.program = null;
    }

    public Program getExternalProgram() {
        return this.program;
    }

    @Override
    public void updateProgramInfo(Program program) {
        Options options = program.getOptions("Program Information");
        options.setString(PROGRAM_INFO_DWARF_EXTERNAL_DEBUG_FILE, this.externalDebugFileLocation.toString());
    }

    public static FSRL getExternalDebugFileLocation(Program program) {
        Options options = program.getOptions("Program Information");
        String fsrlStr = options.getString(PROGRAM_INFO_DWARF_EXTERNAL_DEBUG_FILE, null);
        try {
            return fsrlStr != null ? FSRL.fromString(fsrlStr) : null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

