/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.funcfixup;

import ghidra.app.util.bin.format.dwarf.DWARFFunction;
import ghidra.app.util.bin.format.dwarf.DWARFVariable;
import ghidra.app.util.bin.format.dwarf.funcfixup.DWARFFunctionFixup;
import ghidra.util.classfinder.ExtensionPointProperties;

@ExtensionPointProperties(priority=2000)
public class ParamSpillDWARFFunctionFixup
implements DWARFFunctionFixup {
    @Override
    public void fixupDWARFFunction(DWARFFunction dfunc) {
        for (DWARFVariable param : dfunc.params) {
            long paramStackOffset;
            if (!param.isStackStorage() || !dfunc.isInLocalVarStorageArea(paramStackOffset = param.getStackOffset())) continue;
            if (dfunc.getLocalVarByOffset(paramStackOffset) == null) {
                DWARFVariable paramSpill = DWARFVariable.fromDataType(dfunc, param.type);
                String paramName = param.name.getName();
                paramSpill.name = param.name.replaceName(paramName + "_local", paramName + "_local");
                paramSpill.setStackStorage(paramStackOffset);
                paramSpill.comment = param.comment;
                dfunc.localVars.add(paramSpill);
            }
            param.clearStorage();
            param.comment = null;
        }
    }
}

