/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.external.gui;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.button.BrowseButton;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.label.GHtmlLabel;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.layout.ThreeColumnLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class FilePromptDialog
extends DialogComponentProvider {
    private GhidraFileChooser chooser;
    private GhidraFileFilter[] fileFilters;
    private File directory;
    private File file;
    private String approveButtonText;
    private JTextField filePathTextField;
    private GhidraFileChooserMode chooserMode;
    private File chosenValue;

    public static File chooseDirectory(String title, String prompt, File initialValue) {
        return FilePromptDialog.chooseFile(title, prompt, "Choose", null, initialValue, GhidraFileChooserMode.DIRECTORIES_ONLY, new GhidraFileFilter[0]);
    }

    public static File chooseFile(String title, String prompt, String chooseButtonText, File directory, File initialFileValue, GhidraFileChooserMode chooserMode, GhidraFileFilter ... fileFilters) {
        FilePromptDialog filePromptDialog = new FilePromptDialog(title, prompt, chooseButtonText, directory, initialFileValue, chooserMode, fileFilters);
        DockingWindowManager.showDialog((DialogComponentProvider)filePromptDialog);
        File file = filePromptDialog.chosenValue;
        filePromptDialog.dispose();
        return file;
    }

    protected FilePromptDialog(String title, String prompt, String approveButtonText, File directory, File file, GhidraFileChooserMode chooserMode, GhidraFileFilter ... fileFilters) {
        super(title, true, false, true, false);
        this.approveButtonText = approveButtonText;
        this.directory = directory;
        this.file = file;
        this.chooserMode = chooserMode;
        this.fileFilters = fileFilters;
        this.setRememberSize(false);
        this.build(prompt);
        this.updateButtonEnablement();
    }

    private void build(String prompt) {
        GHtmlLabel promptLabel = new GHtmlLabel(prompt);
        promptLabel.getAccessibleContext().setAccessibleName(prompt);
        this.filePathTextField = new JTextField(this.file != null ? this.file.getPath() : null, 40);
        this.filePathTextField.getAccessibleContext().setAccessibleName("File Path");
        this.filePathTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                FilePromptDialog.this.updateButtonEnablement();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FilePromptDialog.this.updateButtonEnablement();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FilePromptDialog.this.updateButtonEnablement();
            }
        });
        BrowseButton browseButton = new BrowseButton();
        browseButton.addActionListener(e -> this.browse());
        browseButton.getAccessibleContext().setAccessibleName("Browse");
        JPanel mainPanel = new JPanel((LayoutManager)new ThreeColumnLayout());
        mainPanel.add((Component)promptLabel);
        mainPanel.add(this.filePathTextField);
        mainPanel.add((Component)browseButton);
        mainPanel.getAccessibleContext().setAccessibleName("File Prompt");
        Dimension size = mainPanel.getPreferredSize();
        size.width = Math.max(size.width, 500);
        mainPanel.setPreferredSize(size);
        mainPanel.setMinimumSize(size);
        JPanel newMain = new JPanel(new BorderLayout());
        newMain.add((Component)mainPanel, "Center");
        newMain.getAccessibleContext().setAccessibleName("File Prompt");
        this.addWorkPanel(newMain);
        this.addOKButton();
        this.addCancelButton();
    }

    public void dispose() {
        super.dispose();
        if (this.chooser != null) {
            this.chooser.dispose();
        }
    }

    private void updateButtonEnablement() {
        this.okButton.setEnabled(!this.filePathTextField.getText().isBlank());
    }

    protected void okCallback() {
        this.chosenValue = new File(this.filePathTextField.getText());
        this.close();
    }

    protected void cancelCallback() {
        this.chosenValue = null;
        this.close();
    }

    private void browse() {
        File selectedFile;
        this.initChooser();
        String filePathText = this.filePathTextField.getText();
        String string = filePathText = filePathText.isBlank() && this.file != null ? this.file.getPath() : "";
        if (!filePathText.isBlank()) {
            this.chooser.setSelectedFile(new File(filePathText));
        }
        if ((selectedFile = this.chooser.getSelectedFile()) != null) {
            this.filePathTextField.setText(selectedFile.getPath());
        }
        this.filePathTextField.requestFocusInWindow();
    }

    private void initChooser() {
        if (this.chooser == null) {
            this.chooser = new GhidraFileChooser((Component)this.rootPanel);
            for (GhidraFileFilter gff : this.fileFilters) {
                this.chooser.addFileFilter(gff);
            }
            this.chooser.setMultiSelectionEnabled(false);
            this.chooser.setApproveButtonText(this.approveButtonText);
            this.chooser.setFileSelectionMode(this.chooserMode);
            this.chooser.setTitle(this.getTitle());
            if (this.directory != null) {
                this.chooser.setCurrentDirectory(this.directory);
            }
        }
    }
}

