/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.external.gui;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.OptionDialog;
import docking.widgets.button.BrowseButton;
import docking.widgets.button.GButton;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.label.GLabel;
import docking.widgets.table.GTable;
import docking.widgets.textfield.HintTextField;
import generic.theme.GIcon;
import ghidra.app.util.bin.format.dwarf.external.BuildIdDebugFileProvider;
import ghidra.app.util.bin.format.dwarf.external.DebugFileStorage;
import ghidra.app.util.bin.format.dwarf.external.DebugInfoProvider;
import ghidra.app.util.bin.format.dwarf.external.DebugInfoProviderCreatorContext;
import ghidra.app.util.bin.format.dwarf.external.DebugInfoProviderRegistry;
import ghidra.app.util.bin.format.dwarf.external.ExternalDebugFilesService;
import ghidra.app.util.bin.format.dwarf.external.HttpDebugInfoDProvider;
import ghidra.app.util.bin.format.dwarf.external.LocalDirDebugInfoDProvider;
import ghidra.app.util.bin.format.dwarf.external.LocalDirDebugLinkProvider;
import ghidra.app.util.bin.format.dwarf.external.SameDirDebugInfoProvider;
import ghidra.app.util.bin.format.dwarf.external.gui.ExternalDebugInfoProviderTableModel;
import ghidra.app.util.bin.format.dwarf.external.gui.ExternalDebugInfoProviderTableRow;
import ghidra.app.util.bin.format.dwarf.external.gui.FilePromptDialog;
import ghidra.app.util.bin.format.dwarf.external.gui.TableColumnInitializer;
import ghidra.app.util.bin.format.dwarf.external.gui.WellKnownDebugProvider;
import ghidra.framework.preferences.Preferences;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.layout.ThreeColumnLayout;
import ghidra.util.task.MonitoredRunnable;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.table.TableModel;
import resources.Icons;

public class ExternalDebugFilesConfigDialog
extends DialogComponentProvider {
    private static final Dimension BUTTON_SIZE = new Dimension(32, 32);
    private List<WellKnownDebugProvider> knownProviders = WellKnownDebugProvider.loadAll(".debuginfod_urls");
    private DebugInfoProviderCreatorContext creatorContext = DebugInfoProviderRegistry.getInstance().newContext(null);
    private DebugFileStorage storage;
    private ExternalDebugInfoProviderTableModel tableModel;
    private ExternalDebugFileProvidersPanel configPanel;
    private boolean wasSuccess;
    private boolean configChanged;

    public static boolean show() {
        ExternalDebugFilesConfigDialog dlg = new ExternalDebugFilesConfigDialog();
        DockingWindowManager.showDialog((DialogComponentProvider)dlg);
        return dlg.wasSuccess;
    }

    public ExternalDebugFilesConfigDialog() {
        super("DWARF External Debug Files Configuration", true, false, true, true);
        this.build();
        this.tableModel.addTableModelListener(e -> this.updateButtonEnablement());
        this.setupInitialConfig();
    }

    private void setupInitialConfig() {
        ExternalDebugFilesService tmpService = ExternalDebugFilesService.fromPrefs(this.creatorContext);
        DebugFileStorage newStorage = tmpService.getStorage();
        this.setStorageLocation(newStorage);
        this.tableModel.addItems(tmpService.getProviders());
        this.setConfigChanged(false);
    }

    protected void cancelCallback() {
        this.close();
    }

    protected void okCallback() {
        if (this.isConfigChanged()) {
            this.saveConfig();
        }
        this.wasSuccess = true;
        this.close();
    }

    protected void dialogShown() {
        TableColumnInitializer.initializeTableColumns(this.configPanel.table, this.tableModel);
        this.configPanel.refreshStatus();
    }

    private void build() {
        this.tableModel = new ExternalDebugInfoProviderTableModel();
        this.configPanel = new ExternalDebugFileProvidersPanel();
        this.addButtons();
        this.addWorkPanel(this.configPanel);
        this.setHelpLocation(new HelpLocation("DWARFExternalDebugFilesPlugin", "Configuration"));
        this.setRememberSize(false);
        this.okButton.setEnabled(true);
    }

    private void updateButtonEnablement() {
        this.okButton.setEnabled(true);
        this.configPanel.updatePanelButtonEnablement();
    }

    private void addButtons() {
        this.addOKButton();
        this.addCancelButton();
        this.setDefaultButton(this.cancelButton);
    }

    public void pushAddLocationButton() {
        this.configPanel.addLocation();
    }

    public void setWellknownProviders(List<WellKnownDebugProvider> list) {
        this.knownProviders = list;
    }

    public void setService(ExternalDebugFilesService edfs) {
        this.setProviders(edfs.getProviders());
        this.setStorageLocation(edfs.getStorage());
    }

    private void setStorageLocationPath(String path) {
        this.configPanel.storageLocationTextField.setText(path);
    }

    ExternalDebugFilesService getService() {
        return new ExternalDebugFilesService(this.storage, this.tableModel.getItems());
    }

    void setProviders(List<DebugInfoProvider> providers) {
        this.tableModel.setItems(providers);
    }

    private void setStorageLocation(DebugFileStorage newStorage) {
        this.storage = newStorage;
        this.setStorageLocationPath(newStorage.getDescriptiveName());
        this.updateButtonEnablement();
    }

    void executeMonitoredRunnable(String taskTitle, boolean canCancel, boolean hasProgress, int delay, final MonitoredRunnable runnable) {
        Task task = new Task(this, taskTitle, canCancel, hasProgress, false){

            public void run(TaskMonitor monitor) throws CancelledException {
                runnable.monitoredRun(monitor);
            }
        };
        this.executeProgressTask(task, delay);
    }

    boolean isConfigChanged() {
        return this.configChanged || this.tableModel.isDataChanged();
    }

    void setConfigChanged(boolean configChanged) {
        this.configChanged = configChanged;
        this.tableModel.setDataChanged(configChanged);
    }

    void saveConfig() {
        ExternalDebugFilesService tmpService = this.getService();
        ExternalDebugFilesService.saveToPrefs(tmpService);
        Preferences.store();
        this.setConfigChanged(false);
        this.updateButtonEnablement();
    }

    private void registerHelp(Component comp, String anchorName) {
        DockingWindowManager.getHelpService().registerHelp((Object)comp, new HelpLocation("DWARFExternalDebugFilesPlugin", anchorName));
    }

    private JButton createImageButton(Icon buttonIcon, String alternateText, String helpLoc) {
        GButton button = new GButton(buttonIcon);
        button.setToolTipText(alternateText);
        button.setPreferredSize(BUTTON_SIZE);
        this.registerHelp((Component)button, helpLoc);
        return button;
    }

    private static List<String> getURLsFromEnvStr(String envString) {
        String[] envParts = envString.split("[ ;]");
        ArrayList<String> results = new ArrayList<String>();
        HashSet<String> dedup = new HashSet<String>();
        for (String envPart : envParts) {
            String s = envPart.trim();
            if (s.isBlank() || !dedup.add(s)) continue;
            results.add(s);
        }
        return results;
    }

    class ExternalDebugFileProvidersPanel
    extends JPanel {
        private GTable table;
        private JPanel additionalSearchLocationsPanel;
        private JButton refreshSearchLocationsStatusButton;
        private JButton moveLocationUpButton;
        private JButton moveLocationDownButton;
        private JButton deleteLocationButton;
        private JButton addLocationButton;
        private JPanel storageLocationPanel;
        private HintTextField storageLocationTextField;
        private JButton saveSearchLocationsButton;

        ExternalDebugFileProvidersPanel() {
            super(new BorderLayout());
            this.build();
            ExternalDebugFilesConfigDialog.this.registerHelp(this, "Summary");
        }

        private void build() {
            this.setBorder(BorderFactory.createTitledBorder("External Debug Files Config"));
            this.buildLocationPanel();
            JPanel tableButtonPanel = this.buildButtonPanel();
            JScrollPane tableScrollPane = this.buildTable();
            this.additionalSearchLocationsPanel = new JPanel();
            this.additionalSearchLocationsPanel.setLayout(new BoxLayout(this.additionalSearchLocationsPanel, 1));
            this.additionalSearchLocationsPanel.add(tableButtonPanel);
            this.additionalSearchLocationsPanel.add(tableScrollPane);
            this.add((Component)this.storageLocationPanel, "North");
            this.add((Component)this.additionalSearchLocationsPanel, "Center");
        }

        void refreshStatus() {
            ExternalDebugFilesConfigDialog.this.executeMonitoredRunnable("Refresh Provider Status", true, true, 0, monitor -> {
                ArrayList<ExternalDebugInfoProviderTableRow> rowsCopy = new ArrayList<ExternalDebugInfoProviderTableRow>(ExternalDebugFilesConfigDialog.this.tableModel.getModelData());
                monitor.initialize((long)rowsCopy.size(), "Refreshing provider status");
                try {
                    for (ExternalDebugInfoProviderTableRow row : rowsCopy) {
                        if (monitor.isCancelled()) {
                            break;
                        }
                        monitor.setMessage("Checking " + row.getItem().getName());
                        monitor.incrementProgress();
                        DebugInfoProvider provider = row.getItem();
                        row.setStatus(provider.getStatus(monitor));
                    }
                }
                finally {
                    Swing.runLater(() -> ExternalDebugFilesConfigDialog.this.tableModel.fireTableDataChanged());
                }
            });
        }

        private JScrollPane buildTable() {
            this.table = new GTable((TableModel)((Object)ExternalDebugFilesConfigDialog.this.tableModel));
            this.table.setVisibleRowCount(4);
            this.table.setUserSortingEnabled(false);
            this.table.getSelectionManager().addListSelectionListener(e -> this.updatePanelButtonEnablement());
            this.table.setPreferredScrollableViewportSize(new Dimension(500, 100));
            return new JScrollPane((Component)this.table);
        }

        private JPanel buildButtonPanel() {
            this.refreshSearchLocationsStatusButton = ExternalDebugFilesConfigDialog.this.createImageButton(Icons.REFRESH_ICON, "Refresh Status", "ButtonActions");
            this.refreshSearchLocationsStatusButton.addActionListener(e -> this.refreshStatus());
            this.moveLocationUpButton = ExternalDebugFilesConfigDialog.this.createImageButton(Icons.UP_ICON, "Up", "ButtonActions");
            this.moveLocationUpButton.addActionListener(e -> this.moveLocation(-1));
            this.moveLocationUpButton.setToolTipText("Move location up");
            this.moveLocationDownButton = ExternalDebugFilesConfigDialog.this.createImageButton(Icons.DOWN_ICON, "Down", "ButtonActions");
            this.moveLocationDownButton.addActionListener(e -> this.moveLocation(1));
            this.moveLocationDownButton.setToolTipText("Move location down");
            this.deleteLocationButton = ExternalDebugFilesConfigDialog.this.createImageButton(Icons.DELETE_ICON, "Delete", "ButtonActions");
            this.deleteLocationButton.addActionListener(e -> this.deleteLocation());
            this.addLocationButton = ExternalDebugFilesConfigDialog.this.createImageButton(Icons.ADD_ICON, "Add", "ButtonActions");
            this.addLocationButton.addActionListener(e -> this.addLocation());
            this.saveSearchLocationsButton = ExternalDebugFilesConfigDialog.this.createImageButton(Icons.SAVE_ICON, "Save Configuration", "ButtonActions");
            this.saveSearchLocationsButton.addActionListener(e -> ExternalDebugFilesConfigDialog.this.saveConfig());
            JPanel tableButtonPanel = new JPanel();
            tableButtonPanel.setLayout(new BoxLayout(tableButtonPanel, 0));
            tableButtonPanel.add((Component)new GLabel("Additional Locations:"));
            tableButtonPanel.add(Box.createHorizontalGlue());
            tableButtonPanel.add(this.addLocationButton);
            tableButtonPanel.add(this.deleteLocationButton);
            tableButtonPanel.add(this.moveLocationUpButton);
            tableButtonPanel.add(this.moveLocationDownButton);
            tableButtonPanel.add(this.refreshSearchLocationsStatusButton);
            tableButtonPanel.add(this.saveSearchLocationsButton);
            return tableButtonPanel;
        }

        private JPanel buildLocationPanel() {
            this.storageLocationTextField = new HintTextField(" Required ");
            this.storageLocationTextField.setEditable(false);
            this.storageLocationTextField.setFocusable(false);
            this.storageLocationTextField.setToolTipText("User-specified directory where debug files are stored.  Required.");
            BrowseButton chooseStorageLocationButton = new BrowseButton();
            chooseStorageLocationButton.addActionListener(e -> this.chooseStorageLocation());
            ExternalDebugFilesConfigDialog.this.registerHelp((Component)chooseStorageLocationButton, "LocalStorage");
            File ghidraCacheDir = LocalDirDebugInfoDProvider.getGhidraCacheInstance().getDirectory();
            JButton chooseGhidraCacheLocationButton = ExternalDebugFilesConfigDialog.this.createImageButton((Icon)new GIcon("icon.base.application.home"), "Use private Ghidra cache location\n" + String.valueOf(ghidraCacheDir), "LocalStorage");
            chooseGhidraCacheLocationButton.addActionListener(e -> this.chooseGhidraCacheLocation());
            JPanel storageButtonPanel = new JPanel();
            storageButtonPanel.setLayout(new BoxLayout(storageButtonPanel, 0));
            storageButtonPanel.add((Component)chooseStorageLocationButton, "Center");
            storageButtonPanel.add(chooseGhidraCacheLocationButton);
            GLabel storageLocLabel = new GLabel("Local Storage:", 4);
            storageLocLabel.setToolTipText(this.storageLocationTextField.getToolTipText());
            this.storageLocationPanel = new JPanel((LayoutManager)new ThreeColumnLayout(5, 5, 5));
            this.storageLocationPanel.add((Component)storageLocLabel);
            this.storageLocationPanel.add((Component)this.storageLocationTextField);
            this.storageLocationPanel.add(storageButtonPanel);
            return this.storageLocationPanel;
        }

        private void updatePanelButtonEnablement() {
            boolean singleRow = this.table.getSelectedRowCount() == 1;
            boolean moreThanOneRow = this.table.getRowCount() > 1;
            this.refreshSearchLocationsStatusButton.setEnabled(!ExternalDebugFilesConfigDialog.this.tableModel.isEmpty());
            this.moveLocationUpButton.setEnabled(singleRow && moreThanOneRow);
            this.moveLocationDownButton.setEnabled(singleRow && moreThanOneRow);
            this.addLocationButton.setEnabled(true);
            this.deleteLocationButton.setEnabled(this.table.getSelectedRowCount() > 0);
            this.saveSearchLocationsButton.setEnabled(ExternalDebugFilesConfigDialog.this.isConfigChanged());
        }

        private void chooseStorageLocation() {
            GhidraFileChooser chooser = this.getChooser("Choose Debug File Storage Directory");
            File f = chooser.getSelectedFile();
            chooser.dispose();
            if (f != null) {
                ExternalDebugFilesConfigDialog.this.configChanged = true;
                ExternalDebugFilesConfigDialog.this.setStorageLocation(new LocalDirDebugInfoDProvider(f));
                ExternalDebugFilesConfigDialog.this.updateButtonEnablement();
            }
        }

        private void chooseGhidraCacheLocation() {
            ExternalDebugFilesConfigDialog.this.configChanged = true;
            ExternalDebugFilesConfigDialog.this.setStorageLocation(LocalDirDebugInfoDProvider.getGhidraCacheInstance());
            ExternalDebugFilesConfigDialog.this.updateButtonEnablement();
        }

        private void importLocations() {
            String envVar = (String)JOptionPane.showInputDialog(this, "<html>Enter value:<br>\n<br>\nExample: https://debuginfod.domain1.org https://debuginfod.domain2.org<br>\n<br>", "Enter DEBUGINFOD_URLS Value", 3, null, null, Objects.requireNonNullElse(System.getenv("DEBUGINFOD_URLS"), ""));
            if (envVar == null) {
                return;
            }
            List<String> urls = ExternalDebugFilesConfigDialog.getURLsFromEnvStr(envVar);
            urls.forEach(s -> ExternalDebugFilesConfigDialog.this.tableModel.addItem(ExternalDebugFilesConfigDialog.this.creatorContext.registry().create((String)s, ExternalDebugFilesConfigDialog.this.creatorContext)));
            ExternalDebugFilesConfigDialog.this.updateButtonEnablement();
        }

        private void addLocation() {
            JPopupMenu menu = this.createAddLocationPopupMenu();
            menu.show(this.addLocationButton, 0, 0);
        }

        private JPopupMenu createAddLocationPopupMenu() {
            JPopupMenu menu = new JPopupMenu();
            ExternalDebugFilesConfigDialog.this.registerHelp(menu, "LocationTypes");
            JMenuItem addProgLocMenuItem = new JMenuItem("Program's Import Location");
            addProgLocMenuItem.addActionListener(e -> this.addSameDirLocation());
            addProgLocMenuItem.setToolTipText("Directory that the program was originally imported from.");
            menu.add(addProgLocMenuItem);
            JMenuItem addBuildIdDirMenuItem = new JMenuItem("Build-id Directory");
            addBuildIdDirMenuItem.addActionListener(e -> this.addBuildIdDirLocation());
            addBuildIdDirMenuItem.setToolTipText("Directory where debug files that are identified by a build-id hash are stored.\nDebug files are named AA/BBCCDD...ZZ.debug under the base directory\nThis storage scheme for build-id debug files is distinct from debuginfod's scheme.\n\ne.g. /usr/lib/debug/.build-id");
            menu.add(addBuildIdDirMenuItem);
            JMenuItem addDebugLinkDirMenuItem = new JMenuItem("Debug Link Directory");
            addDebugLinkDirMenuItem.addActionListener(e -> this.addDebugLinkDirLocation());
            addDebugLinkDirMenuItem.setToolTipText("Directory where debug files that are identified\nby a debug filename and crc hash\n(found in the binary's .gnu_debuglink section).\n\nNOTE: This directory is searched recursively for a matching file.");
            menu.add(addDebugLinkDirMenuItem);
            JMenuItem addDebugInfoDDirMenuItem = new JMenuItem("Debuginfod Directory");
            addDebugInfoDDirMenuItem.addActionListener(e -> this.addDebugInfoDDirLocation());
            addDebugInfoDDirMenuItem.setToolTipText("Directory where debuginfod has stored files.");
            menu.add(addDebugInfoDDirMenuItem);
            JMenuItem addURLMenuItem = new JMenuItem("Debuginfod URL");
            addURLMenuItem.addActionListener(e -> this.addUrlLocation());
            addURLMenuItem.setToolTipText("HTTP(s) URL that points to a debuginfod server.");
            menu.add(addURLMenuItem);
            JMenuItem importEnvMenuItem = new JMenuItem("Import DEBUGINFOD_URLS Env Var");
            importEnvMenuItem.addActionListener(e -> this.importLocations());
            importEnvMenuItem.setToolTipText("Adds debuginfod URLs found in the system environment variable.");
            menu.add(importEnvMenuItem);
            if (!ExternalDebugFilesConfigDialog.this.knownProviders.isEmpty()) {
                menu.add(new JSeparator());
                for (WellKnownDebugProvider provider : ExternalDebugFilesConfigDialog.this.knownProviders) {
                    JMenuItem mi = new JMenuItem(provider.location());
                    mi.addActionListener(e -> this.addKnownLocation(provider));
                    mi.setToolTipText("Debuginfod URL [from " + provider.fileOrigin() + "]");
                    menu.add(mi);
                }
            }
            return menu;
        }

        private void addSameDirLocation() {
            SameDirDebugInfoProvider provider = new SameDirDebugInfoProvider(null);
            ExternalDebugFilesConfigDialog.this.tableModel.addItem(provider);
        }

        private void addKnownLocation(WellKnownDebugProvider providerInfo) {
            DebugInfoProvider newProvider = ExternalDebugFilesConfigDialog.this.creatorContext.registry().create(providerInfo.location(), ExternalDebugFilesConfigDialog.this.creatorContext);
            if (newProvider != null) {
                ExternalDebugFilesConfigDialog.this.tableModel.addItem(newProvider);
            }
        }

        private void addUrlLocation() {
            String urlStr = OptionDialog.showInputSingleLineDialog((Component)this, (String)"Enter URL", (String)"Enter the URL of a Debuginfod Server: ", (String)"https://");
            if (urlStr == null || urlStr.isBlank() || urlStr.equals("https://")) {
                return;
            }
            try {
                urlStr = urlStr.toLowerCase();
                if (urlStr.startsWith("http://") || urlStr.startsWith("https://")) {
                    HttpDebugInfoDProvider newProvider = new HttpDebugInfoDProvider(URI.create(urlStr));
                    ExternalDebugFilesConfigDialog.this.tableModel.addItem(newProvider);
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            Msg.showWarn((Object)this, (Component)this, (String)"Bad URL", (Object)("Invalid URL: " + urlStr));
        }

        private void addBuildIdDirLocation() {
            File dir = FilePromptDialog.chooseDirectory("Enter Path", "Build-Id Root Directory: ", null);
            if (dir == null) {
                return;
            }
            if (!dir.exists() || !dir.isDirectory()) {
                Msg.showError((Object)this, (Component)this, (String)"Bad path", (Object)("Invalid path: " + String.valueOf(dir)));
                return;
            }
            BuildIdDebugFileProvider provider = new BuildIdDebugFileProvider(dir);
            ExternalDebugFilesConfigDialog.this.tableModel.addItem(provider);
        }

        private void addDebugLinkDirLocation() {
            File dir = FilePromptDialog.chooseDirectory("Enter Path", "Debug-Link Root Directory: ", null);
            if (dir == null) {
                return;
            }
            if (!dir.exists() || !dir.isDirectory()) {
                Msg.showError((Object)this, (Component)this, (String)"Bad path", (Object)("Invalid path: " + String.valueOf(dir)));
                return;
            }
            LocalDirDebugLinkProvider provider = new LocalDirDebugLinkProvider(dir);
            ExternalDebugFilesConfigDialog.this.tableModel.addItem(provider);
        }

        private void addDebugInfoDDirLocation() {
            File dir = FilePromptDialog.chooseDirectory("Enter Path", "Debuginfod Cache Directory: ", null);
            if (dir == null) {
                return;
            }
            if (!dir.exists() || !dir.isDirectory()) {
                Msg.showError((Object)this, (Component)this, (String)"Bad path", (Object)("Invalid path: " + String.valueOf(dir)));
                return;
            }
            LocalDirDebugInfoDProvider provider = new LocalDirDebugInfoDProvider(dir);
            ExternalDebugFilesConfigDialog.this.tableModel.addItem(provider);
        }

        private void deleteLocation() {
            int selectedRow = this.table.getSelectedRow();
            ExternalDebugFilesConfigDialog.this.tableModel.deleteRows(this.table.getSelectedRows());
            if (selectedRow >= 0 && selectedRow < this.table.getRowCount()) {
                this.table.selectRow(selectedRow);
            }
        }

        private void moveLocation(int delta) {
            if (this.table.getSelectedRowCount() == 1) {
                ExternalDebugFilesConfigDialog.this.tableModel.moveRow(this.table.getSelectedRow(), delta);
            }
        }

        private GhidraFileChooser getChooser(String title) {
            GhidraFileChooser chooser = new GhidraFileChooser((Component)this);
            chooser.setMultiSelectionEnabled(false);
            chooser.setApproveButtonText("Choose");
            chooser.setFileSelectionMode(GhidraFileChooserMode.DIRECTORIES_ONLY);
            chooser.setTitle(title);
            return chooser;
        }
    }
}

