/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.external;

import ghidra.app.util.bin.format.dwarf.external.DebugFileProvider;
import ghidra.app.util.bin.format.dwarf.external.DebugInfoProviderCreatorContext;
import ghidra.app.util.bin.format.dwarf.external.DebugInfoProviderStatus;
import ghidra.app.util.bin.format.dwarf.external.ExternalDebugInfo;
import ghidra.app.util.bin.format.dwarf.external.LocalDirDebugLinkProvider;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;

public class SameDirDebugInfoProvider
implements DebugFileProvider {
    public static final String DESC = "Program's Import Location";
    private final File progDir;

    public static boolean matches(String name) {
        return name.equals(".");
    }

    public static SameDirDebugInfoProvider create(String name, DebugInfoProviderCreatorContext context) {
        File exeLocation = context.program() != null ? new File(FilenameUtils.getFullPath((String)context.program().getExecutablePath())) : null;
        return new SameDirDebugInfoProvider(exeLocation);
    }

    public SameDirDebugInfoProvider(File progDir) {
        this.progDir = progDir;
    }

    @Override
    public String getName() {
        return ".";
    }

    @Override
    public String getDescriptiveName() {
        return DESC + (String)(this.progDir != null ? " (" + this.progDir.getPath() + ")" : "");
    }

    @Override
    public DebugInfoProviderStatus getStatus(TaskMonitor monitor) {
        return this.progDir != null ? (this.progDir.isDirectory() ? DebugInfoProviderStatus.VALID : DebugInfoProviderStatus.INVALID) : DebugInfoProviderStatus.UNKNOWN;
    }

    @Override
    public File getFile(ExternalDebugInfo debugInfo, TaskMonitor monitor) throws IOException, CancelledException {
        File debugFile;
        if (debugInfo.hasDebugLink() && (debugFile = new File(this.progDir, debugInfo.getFilename())).isFile()) {
            int fileCRC = LocalDirDebugLinkProvider.calcCRC(debugFile);
            if (fileCRC == debugInfo.getCrc()) {
                return debugFile;
            }
            Msg.info((Object)this, (Object)"DWARF external debug file found with mismatching crc, ignored: %s, (%08x)".formatted(debugFile, fileCRC));
        }
        if (debugInfo.hasBuildId() && (debugFile = new File(this.progDir, debugInfo.getBuildId() + ".debug")).isFile()) {
            return debugFile;
        }
        return null;
    }
}

