/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.external;

import ghidra.app.util.bin.format.dwarf.external.DebugFileProvider;
import ghidra.app.util.bin.format.dwarf.external.DebugFileStorage;
import ghidra.app.util.bin.format.dwarf.external.DebugInfoProvider;
import ghidra.app.util.bin.format.dwarf.external.DebugInfoProviderCreatorContext;
import ghidra.app.util.bin.format.dwarf.external.DebugInfoProviderRegistry;
import ghidra.app.util.bin.format.dwarf.external.DebugStreamProvider;
import ghidra.app.util.bin.format.dwarf.external.ExternalDebugInfo;
import ghidra.app.util.bin.format.dwarf.external.LocalDirDebugInfoDProvider;
import ghidra.app.util.bin.format.dwarf.external.SameDirDebugInfoProvider;
import ghidra.framework.preferences.Preferences;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ExternalDebugFilesService {
    private static final String EXT_DEBUG_FILES_OPTION = "ExternalDebugFiles";
    private static final String STORAGE_OPTION = "ExternalDebugFiles.storage";
    private static final String PROVIDERS_OPTION = "ExternalDebugFiles.providers";
    private final DebugFileStorage storage;
    private List<DebugInfoProvider> providers = new ArrayList<DebugInfoProvider>();

    public ExternalDebugFilesService(DebugFileStorage storage, List<DebugInfoProvider> providers) {
        Objects.requireNonNull(storage);
        this.storage = storage;
        this.providers.add(storage);
        this.providers.addAll(providers);
    }

    public DebugFileStorage getStorage() {
        return this.storage;
    }

    public List<DebugInfoProvider> getProviders() {
        return List.copyOf(this.providers.subList(1, this.providers.size()));
    }

    public void addProvider(DebugInfoProvider provider) {
        this.providers.add(provider);
    }

    public File find(ExternalDebugInfo debugInfo, TaskMonitor monitor) throws IOException {
        try {
            for (DebugInfoProvider provider : this.providers) {
                DebugStreamProvider streamProvider;
                DebugStreamProvider.StreamInfo stream;
                monitor.checkCancelled();
                File result = null;
                if (provider instanceof DebugFileProvider) {
                    DebugFileProvider fileProvider = (DebugFileProvider)provider;
                    result = fileProvider.getFile(debugInfo, monitor);
                } else if (provider instanceof DebugStreamProvider && (stream = (streamProvider = (DebugStreamProvider)provider).getStream(debugInfo, monitor)) != null) {
                    result = this.storage.putStream(debugInfo, stream, monitor);
                }
                if (result == null) continue;
                return result;
            }
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        return null;
    }

    public static ExternalDebugFilesService getMinimal() {
        return new ExternalDebugFilesService(LocalDirDebugInfoDProvider.getGhidraCacheInstance(), List.of());
    }

    public static ExternalDebugFilesService getDefault() {
        return new ExternalDebugFilesService(LocalDirDebugInfoDProvider.getGhidraCacheInstance(), List.of(new SameDirDebugInfoProvider(null), LocalDirDebugInfoDProvider.getUserHomeCacheInstance()));
    }

    public static ExternalDebugFilesService forProgram(Program program) {
        return ExternalDebugFilesService.fromPrefs(DebugInfoProviderRegistry.getInstance().newContext(program));
    }

    public static ExternalDebugFilesService fromPrefs(DebugInfoProviderCreatorContext context) {
        DebugInfoProviderRegistry registry = DebugInfoProviderRegistry.getInstance();
        String storageStr = Preferences.getProperty((String)STORAGE_OPTION, (String)"", (boolean)true);
        LocalDirDebugInfoDProvider storage = null;
        if (storageStr != null) {
            DebugFileStorage dfs;
            DebugInfoProvider storageProvider = registry.create(storageStr, context);
            DebugFileStorage debugFileStorage = storage = storageProvider instanceof DebugFileStorage ? (dfs = (DebugFileStorage)storageProvider) : null;
        }
        if (storage == null) {
            storage = LocalDirDebugInfoDProvider.getGhidraCacheInstance();
        }
        String providersStr = Preferences.getProperty((String)PROVIDERS_OPTION, (String)"", (boolean)true);
        String[] providerNames = providersStr.split(";");
        ArrayList<DebugInfoProvider> providers = new ArrayList<DebugInfoProvider>();
        for (String providerName : providerNames) {
            DebugInfoProvider provider;
            if (providerName.isBlank() || (provider = registry.create(providerName, context)) == null) continue;
            providers.add(provider);
        }
        if (providers.isEmpty()) {
            providers.add(SameDirDebugInfoProvider.create(null, context));
            providers.add(LocalDirDebugInfoDProvider.getUserHomeCacheInstance());
        }
        return new ExternalDebugFilesService(storage, providers);
    }

    public static void saveToPrefs(ExternalDebugFilesService service) {
        if (service != null) {
            String serializedProviders = service.getProviders().stream().map(DebugInfoProvider::getName).collect(Collectors.joining(";"));
            Preferences.setProperty((String)STORAGE_OPTION, (String)service.getStorage().getName());
            Preferences.setProperty((String)PROVIDERS_OPTION, (String)serializedProviders);
        } else {
            Preferences.setProperty((String)STORAGE_OPTION, null);
            Preferences.setProperty((String)PROVIDERS_OPTION, null);
        }
    }
}

