/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.dwarf.DIEAggregate;
import ghidra.app.util.bin.format.dwarf.DWARFAddressListHeader;
import ghidra.app.util.bin.format.dwarf.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf.DWARFDataTypeManager;
import ghidra.app.util.bin.format.dwarf.DWARFEncoding;
import ghidra.app.util.bin.format.dwarf.DWARFException;
import ghidra.app.util.bin.format.dwarf.DWARFImportOptions;
import ghidra.app.util.bin.format.dwarf.DWARFImportSummary;
import ghidra.app.util.bin.format.dwarf.DWARFIndirectTable;
import ghidra.app.util.bin.format.dwarf.DWARFLocationList;
import ghidra.app.util.bin.format.dwarf.DWARFLocationListHeader;
import ghidra.app.util.bin.format.dwarf.DWARFName;
import ghidra.app.util.bin.format.dwarf.DWARFRange;
import ghidra.app.util.bin.format.dwarf.DWARFRangeList;
import ghidra.app.util.bin.format.dwarf.DWARFRangeListHeader;
import ghidra.app.util.bin.format.dwarf.DWARFRegisterMappings;
import ghidra.app.util.bin.format.dwarf.DWARFRegisterMappingsManager;
import ghidra.app.util.bin.format.dwarf.DWARFStringOffsetTableHeader;
import ghidra.app.util.bin.format.dwarf.DWARFTag;
import ghidra.app.util.bin.format.dwarf.DWARFUnitHeader;
import ghidra.app.util.bin.format.dwarf.DWARFUtil;
import ghidra.app.util.bin.format.dwarf.DebugInfoEntry;
import ghidra.app.util.bin.format.dwarf.StringTable;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttribute;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttributeValue;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFBlobAttribute;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFForm;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFNumericAttribute;
import ghidra.app.util.bin.format.dwarf.expression.DWARFExpressionException;
import ghidra.app.util.bin.format.dwarf.external.ExternalDebugInfo;
import ghidra.app.util.bin.format.dwarf.funcfixup.DWARFFunctionFixup;
import ghidra.app.util.bin.format.dwarf.line.DWARFLine;
import ghidra.app.util.bin.format.dwarf.macro.DWARFMacroHeader;
import ghidra.app.util.bin.format.dwarf.macro.entry.DWARFMacroInfoEntry;
import ghidra.app.util.bin.format.dwarf.sectionprovider.BaseSectionProvider;
import ghidra.app.util.bin.format.dwarf.sectionprovider.CompressedSectionProvider;
import ghidra.app.util.bin.format.dwarf.sectionprovider.DSymSectionProvider;
import ghidra.app.util.bin.format.dwarf.sectionprovider.DWARFSectionNames;
import ghidra.app.util.bin.format.dwarf.sectionprovider.DWARFSectionProvider;
import ghidra.app.util.bin.format.dwarf.sectionprovider.DWARFSectionProviderFactory;
import ghidra.app.util.bin.format.golang.rtti.GoSymbolName;
import ghidra.app.util.opinion.ElfLoader;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.datastruct.FixedSizeHashMap;
import ghidra.util.datastruct.IntArrayList;
import ghidra.util.datastruct.LongArrayList;
import ghidra.util.datastruct.WeakValueHashMap;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Predicate;
import org.apache.commons.collections4.ListValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class DWARFProgram
implements Closeable {
    public static final String DWARF_ROOT_NAME = "DWARF";
    public static final CategoryPath DWARF_ROOT_CATPATH = CategoryPath.ROOT.extend(new String[]{"DWARF"});
    public static final CategoryPath UNCAT_CATPATH = DWARF_ROOT_CATPATH.extend(new String[]{"_UNCATEGORIZED_"});
    public static final String DWARF_BOOKMARK_CAT = "DWARF";
    private static final int NAME_HASH_REPLACEMENT_SIZE = 12;
    private static final String ELLIPSES_STR = "...";
    protected static final EnumSet<DWARFAttribute> REF_ATTRS = EnumSet.of(DWARFAttribute.DW_AT_abstract_origin, DWARFAttribute.DW_AT_specification);
    private final Program program;
    private final DWARFDataTypeManager dwarfDTM;
    private DWARFName rootDNI = DWARFName.createRoot(DWARF_ROOT_CATPATH);
    private DWARFName unCatDataTypeRoot = DWARFName.createRoot(UNCAT_CATPATH);
    private DWARFImportOptions importOptions;
    private DWARFImportSummary importSummary = new DWARFImportSummary();
    private DWARFSectionProvider sectionProvider;
    private StringTable debugStrings;
    private StringTable lineStrings;
    private Charset charset;
    private int totalAggregateCount;
    private long programBaseAddressFixup;
    private int maxDNICacheSize = 50;
    private FixedSizeHashMap<Long, DWARFName> dniCache = new FixedSizeHashMap(100, this.maxDNICacheSize);
    private Map<DWARFAttribute.AttrDef, DWARFAttribute.AttrDef> attributeSpecIntern = new HashMap<DWARFAttribute.AttrDef, DWARFAttribute.AttrDef>();
    private DWARFRegisterMappings dwarfRegisterMappings;
    private final boolean stackGrowsNegative;
    private List<DWARFFunctionFixup> functionFixups;
    private BinaryReader debugLocation;
    private BinaryReader debugLocLists;
    private BinaryReader debugRanges;
    private BinaryReader debugRngLists;
    private BinaryReader debugInfoBR;
    private BinaryReader debugLineBR;
    private BinaryReader debugAbbrBR;
    private BinaryReader debugAddr;
    private BinaryReader debugStrOffsets;
    private BinaryReader debugMacros;
    protected long[] dieOffsets = new long[0];
    protected int[] siblingIndexes = new int[0];
    protected int[] parentIndexes = new int[0];
    protected TreeMap<Integer, DWARFCompilationUnit> compUnitDieIndex = new TreeMap();
    protected List<DWARFCompilationUnit> compUnits = new ArrayList<DWARFCompilationUnit>();
    private DWARFIndirectTable addressListTable;
    private DWARFIndirectTable locationListTable;
    private DWARFIndirectTable rangeListTable;
    private DWARFIndirectTable stringsOffsetTable;
    protected BitSet indexHasRef = new BitSet();
    protected WeakValueHashMap<Long, DebugInfoEntry> diesByOffset = new WeakValueHashMap();
    private WeakValueHashMap<Long, DIEAggregate> aggsByOffset = new WeakValueHashMap();
    private ListValuedMap<Long, Long> typeReferers = new ArrayListValuedHashMap();
    private Map<Long, DWARFLine> cachedDWARFLines = new HashMap<Long, DWARFLine>();

    public static boolean isDWARF(Program program) {
        String format;
        return switch (format = Objects.requireNonNullElse(program.getExecutableFormat(), "")) {
            case "Executable and Linking Format (ELF)", "Portable Executable (PE)" -> {
                if (DWARFProgram.hasExpectedDWARFSections(program) || ExternalDebugInfo.fromProgram(program) != null) {
                    yield true;
                }
                yield false;
            }
            case "Mac OS X Mach-O" -> {
                if (DWARFProgram.hasExpectedDWARFSections(program) || DSymSectionProvider.getDSYMForProgram(program) != null) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private static boolean hasExpectedDWARFSections(Program program) {
        try (CompressedSectionProvider tmp = new CompressedSectionProvider(new BaseSectionProvider(program));){
            boolean bl = tmp.hasSection(DWARFSectionNames.MINIMAL_DWARF_SECTIONS);
            return bl;
        }
    }

    public static boolean hasDWARFData(Program program, TaskMonitor monitor) {
        if (!DWARFProgram.isDWARF(program)) {
            return false;
        }
        try (DWARFSectionProvider dsp = DWARFSectionProviderFactory.createSectionProviderFor(program, monitor);){
            boolean bl = dsp != null;
            return bl;
        }
    }

    public DWARFProgram(Program program, DWARFImportOptions importOptions, TaskMonitor monitor) throws CancelledException, IOException, DWARFException {
        this(program, importOptions, monitor, DWARFSectionProviderFactory.createSectionProviderFor(program, monitor));
    }

    public DWARFProgram(Program program, DWARFImportOptions importOptions, TaskMonitor monitor, DWARFSectionProvider sectionProvider) throws CancelledException, IOException {
        Long oib;
        boolean hasRelocations;
        if (sectionProvider == null) {
            throw new IllegalArgumentException("Null DWARFSectionProvider");
        }
        this.program = program;
        this.sectionProvider = sectionProvider;
        this.importOptions = importOptions;
        this.dwarfDTM = new DWARFDataTypeManager(this, (DataTypeManager)program.getDataTypeManager());
        this.stackGrowsNegative = program.getCompilerSpec().stackGrowsNegative();
        this.debugInfoBR = this.getBinaryReaderFor("debug_info", monitor);
        this.debugAbbrBR = this.getBinaryReaderFor("debug_abbrev", monitor);
        this.debugLocation = this.getBinaryReaderFor("debug_loc", monitor);
        this.debugLocLists = this.getBinaryReaderFor("debug_loclists", monitor);
        this.debugRanges = this.getBinaryReaderFor("debug_ranges", monitor);
        this.debugRngLists = this.getBinaryReaderFor("debug_rnglists", monitor);
        this.debugLineBR = this.getBinaryReaderFor("debug_line", monitor);
        this.debugAddr = this.getBinaryReaderFor("debug_addr", monitor);
        this.debugStrOffsets = this.getBinaryReaderFor("debug_str_offsets", monitor);
        this.debugMacros = this.getBinaryReaderFor("debug_macro", monitor);
        this.rangeListTable = new DWARFIndirectTable(this.debugRngLists, DWARFCompilationUnit::getRangeListsBase);
        this.addressListTable = new DWARFIndirectTable(this.debugAddr, DWARFCompilationUnit::getAddrTableBase);
        this.stringsOffsetTable = new DWARFIndirectTable(this.debugStrOffsets, DWARFCompilationUnit::getStrOffsetsBase);
        this.locationListTable = new DWARFIndirectTable(this.debugLocLists, DWARFCompilationUnit::getLocListsBase);
        this.charset = importOptions.getCharset(StandardCharsets.UTF_8);
        this.debugStrings = StringTable.of(this.getBinaryReaderFor("debug_str", monitor), this.charset);
        this.lineStrings = StringTable.of(this.getBinaryReaderFor("debug_line_str", monitor), this.charset);
        boolean bl = hasRelocations = this.hasRelocations(this.debugInfoBR) || this.hasRelocations(this.debugRanges);
        if (!hasRelocations && (oib = ElfLoader.getElfOriginalImageBase(program)) != null && oib.longValue() != program.getImageBase().getOffset()) {
            this.programBaseAddressFixup = program.getImageBase().getOffset() - oib;
        }
        this.dwarfRegisterMappings = DWARFRegisterMappingsManager.hasDWARFRegisterMapping(program.getLanguage()) ? DWARFRegisterMappingsManager.getMappingForLang(program.getLanguage()) : null;
    }

    public void init(TaskMonitor monitor) throws IOException, DWARFException, CancelledException {
        this.bootstrapCompilationUnits(monitor);
        int defaultIntSize = this.getDefaultIntSize();
        this.rangeListTable.bootstrap("DWARF: Bootstrapping Range Lists", reader -> DWARFRangeListHeader.read(reader, defaultIntSize), monitor);
        this.locationListTable.bootstrap("DWARF: Bootstrapping Location Lists", reader -> DWARFLocationListHeader.read(reader, defaultIntSize), monitor);
        this.addressListTable.bootstrap("DWARF: Bootstrapping Address Lists", reader -> DWARFAddressListHeader.read(reader, defaultIntSize), monitor);
        this.stringsOffsetTable.bootstrap("DWARF: Bootstrapping String Offset Lists", reader -> DWARFStringOffsetTableHeader.readV5(reader, defaultIntSize), monitor);
        this.indexDIEs(monitor);
        this.indexDIEATypeRefs(monitor);
        this.importSummary.addCompunitInfo(this.compUnits);
    }

    private void bootstrapCompilationUnits(TaskMonitor monitor) throws CancelledException, IOException, DWARFException {
        this.debugInfoBR.setPointerIndex(0);
        monitor.initialize(this.debugInfoBR.length(), "DWARF: Bootstrapping Compilation Units");
        while (this.debugInfoBR.hasNext()) {
            monitor.checkCancelled();
            monitor.setProgress(this.debugInfoBR.getPointerIndex());
            monitor.setMessage("DWARF: Bootstrapping Compilation Unit #" + this.compUnits.size());
            DWARFUnitHeader unitHeader = DWARFUnitHeader.read(this, this.debugInfoBR, this.debugAbbrBR, this.compUnits.size(), monitor);
            if (unitHeader == null) break;
            this.debugInfoBR.setPointerIndex(unitHeader.getEndOffset());
            if (unitHeader instanceof DWARFCompilationUnit) {
                DWARFCompilationUnit cu = (DWARFCompilationUnit)unitHeader;
                this.compUnits.add(cu);
                this.importSummary.dwarfVers.add(Integer.valueOf(cu.getDWARFVersion()));
                continue;
            }
            Msg.info((Object)this, (Object)("Unsupported unit header: " + String.valueOf(unitHeader) + " at " + unitHeader.getStartOffset()));
        }
        this.importSummary.compUnitCount = this.compUnits.size();
    }

    private void indexDIEs(TaskMonitor monitor) throws CancelledException, IOException {
        LongArrayList dieOffsetList = new LongArrayList();
        IntArrayList siblingIndexList = new IntArrayList();
        IntArrayList parentIndexList = new IntArrayList();
        LongArrayList aggrTargets = new LongArrayList();
        monitor.initialize(this.debugInfoBR.length(), "DWARF: Indexing records");
        for (DWARFCompilationUnit cu : this.compUnits) {
            this.debugInfoBR.setPointerIndex(cu.getFirstDIEOffset());
            monitor.setMessage("DWARF: Indexing records - Compilation Unit #%d/%d".formatted(cu.getUnitNumber() + 1, this.compUnits.size()));
            this.indexDIEsForCU(cu, dieOffsetList, parentIndexList, siblingIndexList, aggrTargets, monitor);
            this.compUnitDieIndex.put(dieOffsetList.size() - 1, cu);
        }
        this.dieOffsets = dieOffsetList.toLongArray();
        this.siblingIndexes = siblingIndexList.toArray();
        this.parentIndexes = parentIndexList.toArray();
        this.indexDIEAggregates(aggrTargets, monitor);
        int nonHeadCount = this.indexHasRef.cardinality();
        this.totalAggregateCount = dieOffsetList.size() - nonHeadCount;
        this.importSummary.dieCount = this.dieOffsets.length;
    }

    protected void indexDIEATypeRefs(TaskMonitor monitor) throws CancelledException {
        monitor.initialize((long)this.totalAggregateCount, "DWARF: Indexing Type References");
        for (DIEAggregate diea : this.allAggregates()) {
            monitor.increment();
            DIEAggregate typeRef = diea.getTypeRef();
            if (typeRef == null) continue;
            this.typeReferers.put((Object)typeRef.getOffset(), (Object)diea.getOffset());
        }
        monitor.initialize(0L, "");
    }

    protected void indexDIEAggregates(LongArrayList aggrTargets, TaskMonitor monitor) throws CancelledException, DWARFException {
        monitor.initialize((long)aggrTargets.size(), "DWARF: Indexing DIE Aggregates");
        Iterator iterator = aggrTargets.iterator();
        while (iterator.hasNext()) {
            long aggrTargetOffset = (Long)iterator.next();
            monitor.increment();
            int dieIndex = this.getDIEIndex(aggrTargetOffset);
            if (dieIndex < 0) {
                throw new DWARFException();
            }
            this.indexHasRef.set(dieIndex);
        }
    }

    private void indexDIEsForCU(DWARFCompilationUnit cu, LongArrayList dieOffsetList, IntArrayList parentIndexList, IntArrayList siblingIndexList, LongArrayList aggrTargets, TaskMonitor monitor) throws CancelledException {
        long endOffset = cu.getEndOffset();
        int perCuDieCount = 0;
        int parentIndex = -1;
        long unexpectedTerminator = -1L;
        while (this.debugInfoBR.getPointerIndex() < endOffset) {
            long startOfDIE = this.debugInfoBR.getPointerIndex();
            monitor.setProgress(startOfDIE);
            monitor.setMessage("DWARF: Indexing Compilation Unit #" + this.compUnits.size());
            monitor.checkCancelled();
            try {
                int dieIndex = dieOffsetList.size();
                DebugInfoEntry die = DebugInfoEntry.read(this.debugInfoBR, cu, dieIndex);
                if (die.isTerminator()) {
                    if (parentIndex == -1) {
                        unexpectedTerminator = startOfDIE;
                        continue;
                    }
                    parentIndex = parentIndexList.get(parentIndex);
                    continue;
                }
                if (unexpectedTerminator != -1L) {
                    throw new DWARFException("Unexpected terminator entry at 0x%x".formatted(unexpectedTerminator));
                }
                if (parentIndex == -1 && perCuDieCount != 0) {
                    throw new DWARFException("Unexpected root level DIE at 0x%x".formatted(startOfDIE));
                }
                dieOffsetList.add(startOfDIE);
                parentIndexList.add(parentIndex);
                siblingIndexList.add(dieIndex + 1);
                ++perCuDieCount;
                this.updateSiblingIndexes(siblingIndexList, parentIndexList, dieIndex);
                if (die.getAbbreviation().hasChildren()) {
                    parentIndex = dieIndex;
                }
                if (die.getOffset() == cu.getFirstDIEOffset()) {
                    cu.init(die);
                }
                DIEAggregate diea = DIEAggregate.createSingle(die);
                for (DWARFAttribute attr : REF_ATTRS) {
                    long refdOffset = diea.getUnsignedLong(attr, -1L);
                    if (refdOffset == -1L) continue;
                    aggrTargets.add(refdOffset);
                }
                this.diesByOffset.put((Object)startOfDIE, (Object)die);
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)"Failed to read DIE at offset 0x%x in compunit %d (at 0x%x), skipping remainder of compilation unit.".formatted(startOfDIE, cu.getUnitNumber(), cu.getStartOffset()), (Throwable)e);
                this.debugInfoBR.setPointerIndex(endOffset);
            }
        }
    }

    protected void updateSiblingIndexes(IntArrayList siblingIndexList, IntArrayList parentIndexList, int index) {
        int x = siblingIndexList.size();
        while (index != -1) {
            siblingIndexList.set(index, x);
            index = parentIndexList.get(index);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.sectionProvider != null) {
            this.sectionProvider.close();
        }
        if (this.debugStrings != null) {
            this.debugStrings.clear();
            this.debugStrings = null;
        }
        if (this.lineStrings != null) {
            this.lineStrings.clear();
            this.lineStrings = null;
        }
        this.compUnits.clear();
        this.dniCache.clear();
        this.debugAbbrBR = null;
        this.debugInfoBR = null;
        this.debugLineBR = null;
        this.debugLocation = null;
        this.debugLocLists = null;
        this.debugRanges = null;
        this.debugRngLists = null;
        this.debugAddr = null;
        this.dieOffsets = new long[0];
        this.parentIndexes = new int[0];
        this.siblingIndexes = new int[0];
        this.indexHasRef.clear();
        this.aggsByOffset.clear();
        this.diesByOffset.clear();
        this.typeReferers.clear();
        this.compUnitDieIndex.clear();
        this.locationListTable.clear();
        this.rangeListTable.clear();
        this.stringsOffsetTable.clear();
        this.addressListTable.clear();
        if (this.functionFixups != null) {
            for (DWARFFunctionFixup funcFixup : this.functionFixups) {
                if (!(funcFixup instanceof Closeable)) continue;
                Closeable c = (Closeable)((Object)funcFixup);
                FSUtilities.uncheckedClose(c, null);
            }
            this.functionFixups.clear();
            this.functionFixups = null;
        }
    }

    public DWARFImportOptions getImportOptions() {
        return this.importOptions;
    }

    public DWARFImportSummary getImportSummary() {
        return this.importSummary;
    }

    public Program getGhidraProgram() {
        return this.program;
    }

    public DWARFDataTypeManager getDwarfDTM() {
        return this.dwarfDTM;
    }

    public List<DWARFCompilationUnit> getCompilationUnits() {
        return this.compUnits;
    }

    public boolean isBigEndian() {
        return this.program.getLanguage().isBigEndian();
    }

    public boolean isLittleEndian() {
        return !this.program.getLanguage().isBigEndian();
    }

    public BinaryReader getDebugLineBR() {
        return this.debugLineBR;
    }

    private BinaryReader getBinaryReaderFor(String sectionName, TaskMonitor monitor) throws IOException {
        ByteProvider bp = this.sectionProvider.getSectionAsByteProvider(sectionName, monitor);
        return bp != null ? new BinaryReader(bp, this.isLittleEndian()) : null;
    }

    private boolean hasRelocations(BinaryReader br) {
        MemoryByteProvider mbp;
        if (br == null) {
            return false;
        }
        ByteProvider bp = br.getByteProvider();
        return bp instanceof MemoryByteProvider && !(mbp = (MemoryByteProvider)bp).isEmpty() && this.program.getRelocationTable().getRelocations(mbp.getAddressSet()).hasNext();
    }

    private static boolean isAnonDWARFName(String name) {
        return name == null || name.startsWith("._") || name.startsWith("<anonymous");
    }

    public String getEntryName(DIEAggregate diea) {
        String name = diea.getString(DWARFAttribute.DW_AT_name, null);
        if (name == null) {
            String linkageName = diea.getString(DWARFAttribute.DW_AT_linkage_name, null);
            if (linkageName == null) {
                linkageName = diea.getString(DWARFAttribute.DW_AT_MIPS_linkage_name, null);
            }
            name = linkageName;
        }
        return name;
    }

    private DWARFName getDWARFName(DIEAggregate diea, DWARFName localRootDNI) {
        List<DIEAggregate> referers;
        List<String> nestings;
        DWARFName parentDNI = localRootDNI;
        DIEAggregate declParent = diea.getDeclParent();
        if (declParent != null && declParent.getTag() != DWARFTag.DW_TAG_compile_unit && (parentDNI = this.lookupDNIByOffset(declParent.getOffset())) == null && (parentDNI = this.getDWARFName(declParent, localRootDNI)) != null) {
            this.cacheDNIByOffset(declParent.getOffset(), parentDNI);
        }
        DWARFTag tag = diea.getTag();
        Object name = this.getEntryName(diea);
        if (name != null && ((String)name).contains("_Z") && !((String)name).startsWith("_GLOBAL_") && !(nestings = this.ensureSafeNameLengths(DWARFUtil.parseMangledNestings((String)name))).isEmpty()) {
            name = nestings.remove(nestings.size() - 1);
            if (parentDNI == localRootDNI && !nestings.isEmpty()) {
                parentDNI = DWARFName.fromList(localRootDNI, nestings);
            }
        }
        if (localRootDNI.equals(parentDNI) && !(nestings = DWARFUtil.findLinkageNameInChildren(diea.getHeadFragment())).isEmpty()) {
            nestings.remove(nestings.size() - 1);
            parentDNI = DWARFName.fromList(localRootDNI, nestings);
        }
        if (name == null && (referers = this.getTypeReferers(diea, DWARFTag.DW_TAG_typedef)).size() == 1) {
            return this.getDWARFName(referers.get(0), localRootDNI);
        }
        if (name == null && tag.isStructureType()) {
            String fingerprint = DWARFUtil.getStructLayoutFingerprint(diea);
            List<DIEAggregate> referringMembers = diea.getProgram().getTypeReferers(diea, DWARFTag.DW_TAG_member);
            Object referringMemberNames = this.getReferringMemberFieldNames(referringMembers);
            if (!((String)referringMemberNames).isEmpty()) {
                parentDNI = this.getName(referringMembers.get(0).getParent());
                referringMemberNames = "_for_" + (String)referringMemberNames;
            }
            name = "anon_" + tag.getContainerTypeName() + "_" + fingerprint + (String)referringMemberNames;
            return parentDNI.createChild(null, (String)name, tag.getSymbolType());
        }
        boolean isAnon = false;
        if (name == null) {
            switch (diea.getTag()) {
                case DW_TAG_base_type: {
                    name = this.getAnonBaseTypeName(diea);
                    isAnon = true;
                    break;
                }
                case DW_TAG_enumeration_type: {
                    name = this.getAnonEnumName(diea);
                    isAnon = true;
                    break;
                }
                case DW_TAG_subroutine_type: {
                    name = "anon_subr";
                    isAnon = true;
                    break;
                }
                case DW_TAG_lexical_block: {
                    name = "lexical_block" + this.getLexicalBlockNameWorker(diea.getHeadFragment());
                    break;
                }
                case DW_TAG_formal_parameter: {
                    name = "param_%d".formatted(this.getPositionInParent(diea.getHeadFragment(), dietag -> dietag == DWARFTag.DW_TAG_formal_parameter));
                    isAnon = true;
                    break;
                }
                case DW_TAG_subprogram: 
                case DW_TAG_inlined_subroutine: {
                    if (declParent != null && declParent.getTag().isStructureType() && diea.getBool(DWARFAttribute.DW_AT_artificial, false)) {
                        name = parentDNI.getName();
                        break;
                    }
                    name = "anon_func";
                    isAnon = true;
                    break;
                }
                default: {
                    if (declParent == null || !declParent.getTag().isNameSpaceContainer()) break;
                    name = DWARFUtil.getAnonNameForMeFromParentContext2(diea);
                }
            }
        }
        if (DWARFProgram.isAnonDWARFName((String)name)) {
            name = DWARFProgram.createAnonName("anon_" + tag.getContainerTypeName(), diea);
            isAnon = true;
        }
        String origName = isAnon ? null : name;
        String workingName = this.ensureSafeNameLength((String)name);
        workingName = GoSymbolName.fixGolangSpecialSymbolnameChars(workingName);
        if (diea.getCompilationUnit().getLanguage() == 28 && workingName.startsWith("{impl#") && parentDNI != null) {
            return parentDNI;
        }
        DWARFName result = parentDNI.createChild(origName, workingName, tag.getSymbolType());
        return result;
    }

    public static DIEAggregate getReferringTypedef(DIEAggregate diea) {
        if (diea == null) {
            return null;
        }
        List<DIEAggregate> referers = diea.getProgram().getTypeReferers(diea, DWARFTag.DW_TAG_typedef);
        return referers.size() == 1 ? referers.get(0) : null;
    }

    private String getAnonBaseTypeName(DIEAggregate diea) {
        try {
            int dwarfSize = diea.parseInt(DWARFAttribute.DW_AT_byte_size, 0);
            int dwarfEncoding = (int)diea.getUnsignedLong(DWARFAttribute.DW_AT_encoding, -1L);
            return "anon_basetype_%s_%d".formatted(DWARFEncoding.getTypeName(dwarfEncoding), dwarfSize);
        }
        catch (DWARFExpressionException | IOException e) {
            return DWARFProgram.createAnonName("anon_basetype_unknown", diea);
        }
    }

    private String getAnonEnumName(DIEAggregate diea) {
        int enumSize = Math.max(1, (int)diea.getUnsignedLong(DWARFAttribute.DW_AT_byte_size, 1L));
        return "anon_enum_%d".formatted(enumSize * 8);
    }

    private static String createAnonName(String baseName, DIEAggregate diea) {
        return "%s.dwarf_%x".formatted(baseName, diea.getOffset());
    }

    private String getLexicalBlockNameWorker(DebugInfoEntry die) {
        if (this.isLexicalBlockTag(die.getTag())) {
            return "%s_%d".formatted(this.getLexicalBlockNameWorker(die.getParent()), this.getPositionInParent(die, this::isLexicalBlockTag));
        }
        return "";
    }

    private boolean isLexicalBlockTag(DWARFTag tag) {
        return tag == DWARFTag.DW_TAG_lexical_block || tag == DWARFTag.DW_TAG_inlined_subroutine;
    }

    private String getReferringMemberFieldNames(List<DIEAggregate> referringMembers) {
        if (referringMembers == null || referringMembers.isEmpty()) {
            return "";
        }
        DIEAggregate commonParent = referringMembers.get(0).getParent();
        StringBuilder result = new StringBuilder();
        for (DIEAggregate referringMember : referringMembers) {
            if (commonParent != referringMember.getParent()) {
                return "";
            }
            String memberName = referringMember.getName();
            if (memberName == null) {
                int positionInParent = this.getPositionInParent(referringMember.getHeadFragment(), x -> true);
                if (positionInParent == -1) continue;
                DWARFName parentDNI = this.getName(commonParent);
                memberName = "%s_%d".formatted(parentDNI.getName(), positionInParent);
            }
            if (result.length() > 0) {
                result.append("_");
            }
            result.append(memberName);
        }
        return result.toString();
    }

    private static String abbrevTemplateName(String s) {
        int endBracket;
        int startBracket = s.indexOf(60);
        if (startBracket + 12 < (endBracket = s.lastIndexOf(62))) {
            String templateParams = s.substring(startBracket, endBracket);
            return "%s$%x$%s".formatted(s.substring(0, startBracket + 1), templateParams.hashCode(), s.substring(endBracket));
        }
        return s;
    }

    private String ensureSafeNameLength(String s) {
        if (s.length() <= 2000) {
            return s;
        }
        if ((s = DWARFProgram.abbrevTemplateName(s)).length() <= 2000) {
            return s;
        }
        int prefixKeepLength = 2000 - ELLIPSES_STR.length() - 12;
        return "%s%s$%x$".formatted(s.substring(0, prefixKeepLength), ELLIPSES_STR, s.hashCode());
    }

    private List<String> ensureSafeNameLengths(List<String> strs) {
        for (int i = 0; i < strs.size(); ++i) {
            strs.set(i, this.ensureSafeNameLength(strs.get(i)));
        }
        return strs;
    }

    public DWARFName getName(DIEAggregate diea) {
        DWARFName dni = this.lookupDNIByOffset(diea.getOffset());
        if (dni == null) {
            dni = this.getDWARFName(diea, this.unCatDataTypeRoot);
            this.cacheDNIByOffset(diea.getOffset(), dni);
        }
        return dni;
    }

    private DWARFName lookupDNIByOffset(long offset) {
        DWARFName tmp = (DWARFName)this.dniCache.get((Object)offset);
        return tmp;
    }

    private void cacheDNIByOffset(long offset, DWARFName dni) {
        this.dniCache.put((Object)offset, (Object)dni);
    }

    public DebugInfoEntry getParentOf(int dieIndex) {
        int parentIndex = this.parentIndexes[dieIndex];
        return parentIndex >= 0 ? this.getDIEByIndex(parentIndex) : null;
    }

    private int getParentIndex(int dieIndex) {
        return this.parentIndexes[dieIndex];
    }

    public int getParentDepth(int dieIndex) {
        int depth = 0;
        while (dieIndex != -1) {
            dieIndex = this.parentIndexes[dieIndex];
            ++depth;
        }
        return depth - 1;
    }

    public List<DebugInfoEntry> getChildrenOf(int dieIndex) {
        IntArrayList childIndexes = this.getDIEChildIndexes(dieIndex);
        if (childIndexes.isEmpty()) {
            return List.of();
        }
        ArrayList<DebugInfoEntry> result = new ArrayList<DebugInfoEntry>(childIndexes.size());
        for (int i = 0; i < childIndexes.size(); ++i) {
            result.add(this.getDIEByIndex(childIndexes.get(i)));
        }
        return result;
    }

    private IntArrayList getDIEChildIndexes(int dieIndex) {
        IntArrayList result = new IntArrayList(true);
        if (dieIndex >= 0) {
            int parentSiblingIndex = this.siblingIndexes[dieIndex];
            int index = dieIndex + 1;
            while (index < parentSiblingIndex) {
                result.add(index);
                index = this.siblingIndexes[index];
            }
        }
        return result;
    }

    public int getChildCount(int dieIndex) {
        int result = 0;
        if (dieIndex >= 0) {
            int parentSiblingIndex = this.siblingIndexes[dieIndex];
            int index = dieIndex + 1;
            while (index < parentSiblingIndex) {
                ++result;
                index = this.siblingIndexes[index];
            }
        }
        return result;
    }

    private DWARFCompilationUnit getCompilationUnitForDIE(int dieIndex) {
        Map.Entry<Integer, DWARFCompilationUnit> entry = this.compUnitDieIndex.ceilingEntry(dieIndex);
        return entry != null ? entry.getValue() : null;
    }

    public DebugInfoEntry getDIEByOffset(long dieOffset) {
        DebugInfoEntry die = (DebugInfoEntry)this.diesByOffset.get((Object)dieOffset);
        if (die != null) {
            return die;
        }
        int dieIndex = this.getDIEIndex(dieOffset);
        return this.getDIEByOffset(dieOffset, dieIndex);
    }

    private DebugInfoEntry getDIEByOffset(long dieOffset, int dieIndex) {
        if (dieOffset == -1L || dieIndex == -1) {
            return null;
        }
        DebugInfoEntry die = (DebugInfoEntry)this.diesByOffset.get((Object)dieOffset);
        if (die == null) {
            try {
                this.debugInfoBR.setPointerIndex(dieOffset);
                DWARFCompilationUnit cu = this.getCompilationUnitForDIE(dieIndex);
                if (dieOffset < cu.getFirstDIEOffset() || cu.getEndOffset() < dieOffset) {
                    throw new RuntimeException();
                }
                die = DebugInfoEntry.read(this.debugInfoBR, cu, dieIndex);
                this.diesByOffset.put((Object)dieOffset, (Object)die);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return die;
    }

    private int getDIEIndex(long dieOffset) {
        DebugInfoEntry die = (DebugInfoEntry)this.diesByOffset.get((Object)dieOffset);
        if (die != null) {
            return die.getIndex();
        }
        int index = Arrays.binarySearch(this.dieOffsets, dieOffset);
        return index >= 0 ? index : -1;
    }

    private DebugInfoEntry getDIEByIndex(int dieIndex) {
        long dieOffset = 0 <= dieIndex && dieIndex < this.dieOffsets.length ? this.dieOffsets[dieIndex] : -1L;
        return this.getDIEByOffset(dieOffset, dieIndex);
    }

    public void dumpDIEs(PrintStream ps) {
        for (int dieIndex = 0; dieIndex < this.dieOffsets.length; ++dieIndex) {
            DebugInfoEntry die = this.getDIEByIndex(dieIndex);
            ps.append(die.toString());
        }
    }

    public DIEAggregate getAggregate(DebugInfoEntry die) {
        DIEAggregate diea;
        DIEAggregate dIEAggregate = diea = die != null ? (DIEAggregate)this.aggsByOffset.get((Object)die.getOffset()) : null;
        if (diea == null && die != null) {
            diea = DIEAggregate.createFromHead(die);
            this.aggsByOffset.put((Object)die.getOffset(), (Object)diea);
        }
        return diea;
    }

    private DIEAggregate getAggregateByIndex(int dieIndex) {
        DebugInfoEntry die = this.getDIEByIndex(dieIndex);
        return this.getAggregate(die);
    }

    public DIEAggregate getAggregate(long dieOffset) {
        DIEAggregate diea = (DIEAggregate)this.aggsByOffset.get((Object)dieOffset);
        if (diea != null) {
            return diea;
        }
        DebugInfoEntry die = this.getDIEByOffset(dieOffset);
        return this.getAggregate(die);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getString(DWARFForm form, long offset, DWARFCompilationUnit cu) throws IOException {
        switch (form) {
            case DW_FORM_line_strp: {
                return this.lineStrings.getStringAtOffset(offset);
            }
            case DW_FORM_strp: {
                return this.debugStrings.getStringAtOffset(offset);
            }
            case DW_FORM_strx: 
            case DW_FORM_strx1: 
            case DW_FORM_strx2: 
            case DW_FORM_strx3: 
            case DW_FORM_strx4: {
                long strOffset = this.stringsOffsetTable.getOffset((int)offset, cu);
                return this.debugStrings.getStringAtOffset(strOffset);
            }
        }
        throw new IOException("Unsupported string form: " + String.valueOf((Object)form));
    }

    public DWARFRangeList getRangeList(DIEAggregate diea, DWARFAttribute attribute) throws IOException {
        DWARFNumericAttribute rngListAttr = diea.getAttribute(attribute, DWARFNumericAttribute.class);
        if (rngListAttr == null) {
            return null;
        }
        DWARFCompilationUnit cu = diea.getCompilationUnit();
        switch (rngListAttr.getAttributeForm()) {
            case DW_FORM_rnglistx: {
                int index = rngListAttr.getUnsignedIntExact();
                long rnglistOffset = this.rangeListTable.getOffset(index, cu);
                this.debugRngLists.setPointerIndex(rnglistOffset);
                return DWARFRangeList.readV5(this.debugRngLists, cu);
            }
            case DW_FORM_sec_offset: 
            case DW_FORM_data2: 
            case DW_FORM_data4: 
            case DW_FORM_data8: {
                long rnglistOffset = rngListAttr.getValue();
                short dwarfVersion = cu.getDWARFVersion();
                if (dwarfVersion < 5) {
                    this.debugRanges.setPointerIndex(rnglistOffset);
                    return DWARFRangeList.readV4(this.debugRanges, cu);
                }
                if (dwarfVersion != 5) break;
                this.debugRngLists.setPointerIndex(rnglistOffset);
                return DWARFRangeList.readV5(this.debugRngLists, cu);
            }
        }
        throw new IOException("Unsupported attribute form " + String.valueOf(rngListAttr));
    }

    public long getOffsetOfIndexedElement(DWARFForm form, int index, DWARFCompilationUnit cu) throws IOException {
        DWARFIndirectTable table = switch (form) {
            case DWARFForm.DW_FORM_addrx, DWARFForm.DW_FORM_addrx1, DWARFForm.DW_FORM_addrx2, DWARFForm.DW_FORM_addrx3, DWARFForm.DW_FORM_addrx4 -> this.addressListTable;
            case DWARFForm.DW_FORM_rnglistx -> this.rangeListTable;
            case DWARFForm.DW_FORM_loclistx -> this.locationListTable;
            case DWARFForm.DW_FORM_strx, DWARFForm.DW_FORM_strx1, DWARFForm.DW_FORM_strx2, DWARFForm.DW_FORM_strx3, DWARFForm.DW_FORM_strx4 -> this.stringsOffsetTable;
            default -> null;
        };
        return table != null ? table.getOffset(index, cu) : -1L;
    }

    public long getAddress(DWARFForm form, long value, DWARFCompilationUnit cu) throws IOException {
        switch (form) {
            case DW_FORM_addr: 
            case DW_FORM_udata: {
                return value;
            }
            case DW_FORM_addrx: 
            case DW_FORM_addrx1: 
            case DW_FORM_addrx2: 
            case DW_FORM_addrx3: 
            case DW_FORM_addrx4: {
                long addr = this.addressListTable.getOffset((int)value, cu);
                return addr;
            }
        }
        throw new IOException("Unsupported form %s".formatted(new Object[]{form}));
    }

    public DWARFLocationList getLocationList(DIEAggregate diea, DWARFAttribute attribute) throws IOException {
        DWARFAttributeValue attrib = diea.getAttribute(attribute);
        if (attrib == null) {
            return DWARFLocationList.EMPTY;
        }
        if (attrib instanceof DWARFNumericAttribute) {
            DWARFNumericAttribute dnum = (DWARFNumericAttribute)attrib;
            return this.readLocationList(dnum, diea.getCompilationUnit());
        }
        if (attrib instanceof DWARFBlobAttribute) {
            DWARFBlobAttribute dblob = (DWARFBlobAttribute)attrib;
            return DWARFLocationList.withWildcardRange(dblob.getBytes());
        }
        throw new IOException("Unsupported form %s.".formatted(attrib));
    }

    private DWARFLocationList readLocationList(DWARFNumericAttribute loclistAttr, DWARFCompilationUnit cu) throws IOException {
        try {
            switch (loclistAttr.getAttributeForm()) {
                case DW_FORM_sec_offset: 
                case DW_FORM_data2: 
                case DW_FORM_data4: 
                case DW_FORM_data8: {
                    short dwarfVer = cu.getDWARFVersion();
                    if (dwarfVer < 5) {
                        this.debugLocation.setPointerIndex(loclistAttr.getUnsignedValue());
                        return DWARFLocationList.readV4(this.debugLocation, cu);
                    }
                    if (dwarfVer != 5) break;
                    this.debugLocLists.setPointerIndex(loclistAttr.getUnsignedValue());
                    return DWARFLocationList.readV5(this.debugLocLists, cu);
                }
                case DW_FORM_loclistx: {
                    int index = loclistAttr.getUnsignedIntExact();
                    long locOffset = this.locationListTable.getOffset(index, cu);
                    this.debugLocLists.setPointerIndex(locOffset);
                    return DWARFLocationList.readV5(this.debugLocLists, cu);
                }
            }
        }
        catch (IOException | IllegalArgumentException e) {
            throw new IOException("Failed to read location list specified by %s".formatted(loclistAttr.toString()), e);
        }
        throw new IOException("Unsupported loclist form %s".formatted(new Object[]{loclistAttr.getAttributeForm()}));
    }

    public DWARFLine getLine(DIEAggregate diea, DWARFAttribute attribute) throws IOException {
        DWARFNumericAttribute attrib = diea.getAttribute(attribute, DWARFNumericAttribute.class);
        if (attrib == null || this.debugLineBR == null) {
            return DWARFLine.empty();
        }
        long stmtListOffset = attrib.getUnsignedValue();
        return this.getLine(stmtListOffset, diea.getCompilationUnit(), true);
    }

    public DWARFLine getLine(long offset, DWARFCompilationUnit cu, boolean readIfMissing) throws IOException {
        DWARFLine result = this.cachedDWARFLines.get(offset);
        if (result == null && readIfMissing) {
            result = DWARFLine.read(this.debugLineBR.clone(offset), this.getDefaultIntSize(), cu);
            this.cachedDWARFLines.put(offset, result);
        }
        return result;
    }

    public DWARFMacroHeader getMacroHeader(long offset, DWARFCompilationUnit cu) {
        if (this.debugMacros != null) {
            try {
                return DWARFMacroHeader.readV5(this.debugMacros.clone(offset), cu);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return DWARFMacroHeader.EMTPY;
    }

    public List<DWARFMacroInfoEntry> getMacroEntries(DWARFMacroHeader macroHeader) throws IOException {
        if (this.debugMacros == null) {
            return List.of();
        }
        return DWARFMacroHeader.readMacroEntries(this.debugMacros.clone(macroHeader.getEntriesStartOffset()), macroHeader);
    }

    public Iterable<DIEAggregate> allAggregates() {
        return new DIEAggregateIterator();
    }

    public int getTotalAggregateCount() {
        return this.totalAggregateCount;
    }

    public BinaryReader getReaderForCompUnit(DWARFCompilationUnit cu) {
        return this.debugInfoBR;
    }

    public DWARFRegisterMappings getRegisterMappings() {
        return this.dwarfRegisterMappings;
    }

    public DWARFName getRootDNI() {
        return this.rootDNI;
    }

    public DWARFName getUncategorizedRootDNI() {
        return this.unCatDataTypeRoot;
    }

    public AddressSpace getStackSpace() {
        return this.program.getAddressFactory().getStackSpace();
    }

    public DWARFAttribute.AttrDef internAttributeSpec(DWARFAttribute.AttrDef das) {
        DWARFAttribute.AttrDef inDAS = this.attributeSpecIntern.get(das);
        if (inDAS == null) {
            inDAS = das;
            this.attributeSpecIntern.put(inDAS, inDAS);
        }
        return inDAS;
    }

    private List<DIEAggregate> getTypeReferers(DIEAggregate targetDIEA) {
        List dieaOffsets = this.typeReferers.get((Object)targetDIEA.getOffset());
        if (dieaOffsets == null) {
            return List.of();
        }
        return dieaOffsets.stream().map(dieaOffset -> this.getAggregate((long)dieaOffset)).toList();
    }

    public List<DIEAggregate> getTypeReferers(DIEAggregate targetDIEA, DWARFTag tag) {
        ArrayList<DIEAggregate> result = new ArrayList<DIEAggregate>();
        for (DIEAggregate referer : this.getTypeReferers(targetDIEA)) {
            if (referer.getTag() != tag) continue;
            result.add(referer);
        }
        return result;
    }

    public long getProgramBaseAddressFixup() {
        return this.programBaseAddressFixup;
    }

    public AddressRange getAddressRange(DWARFRange range, boolean isCode) {
        AddressSpace defAS = this.program.getAddressFactory().getDefaultAddressSpace();
        Address start = defAS.getAddress(range.getFrom() + this.programBaseAddressFixup, true);
        Address end = defAS.getAddress(range.getTo() - 1L + this.programBaseAddressFixup, true);
        return new AddressRangeImpl(start, end);
    }

    public Address getCodeAddress(long offset) {
        return this.program.getAddressFactory().getDefaultAddressSpace().getAddress(offset + this.programBaseAddressFixup, true);
    }

    public Address getDataAddress(long offset) {
        return this.program.getAddressFactory().getDefaultAddressSpace().getAddress(offset + this.programBaseAddressFixup, true);
    }

    public boolean stackGrowsNegative() {
        return this.stackGrowsNegative;
    }

    public List<DWARFFunctionFixup> getFunctionFixups() {
        if (this.functionFixups == null) {
            this.functionFixups = DWARFFunctionFixup.findFixups();
        }
        return this.functionFixups;
    }

    public int getDefaultIntSize() {
        return this.program.getDefaultPointerSize();
    }

    public void logWarningAt(Address addr, String addrName, String msg) {
        if (this.importOptions.isUseBookmarks()) {
            String existingTxt;
            BookmarkManager bmm = this.program.getBookmarkManager();
            Bookmark existingBM = bmm.getBookmark(addr, "Warning", "DWARF");
            String string = existingTxt = existingBM != null ? existingBM.getComment() : "";
            if (existingTxt.contains(msg)) {
                return;
            }
            msg = !existingTxt.isEmpty() ? existingTxt + "; " + msg : msg;
            bmm.setBookmark(addr, "Warning", "DWARF", msg);
        } else {
            Msg.warn((Object)this, (Object)"%s: %s at %s@%s".formatted("DWARF", msg, addrName, addr));
        }
    }

    public void setStringTable(StringTable st) {
        this.debugStrings = st;
    }

    private int getPositionInParent(DebugInfoEntry die, Predicate<DWARFTag> dwTagFilter) {
        int dieIndex = die.getIndex();
        int parentIndex = this.getParentIndex(dieIndex);
        if (parentIndex < 0) {
            return -1;
        }
        IntArrayList childIndexes = this.getDIEChildIndexes(parentIndex);
        int positionNum = 0;
        for (int i = 0; i < childIndexes.size(); ++i) {
            int childDIEIndex = childIndexes.get(i);
            if (childDIEIndex == dieIndex) {
                return positionNum;
            }
            DebugInfoEntry childDIE = this.getDIEByIndex(childDIEIndex);
            if (childDIE == null || !dwTagFilter.test(childDIE.getTag())) continue;
            ++positionNum;
        }
        throw new RuntimeException("DWARF DIE index failure.");
    }

    private class DIEAggregateIterator
    implements Iterator<DIEAggregate>,
    Iterable<DIEAggregate> {
        private int index = -1;

        private DIEAggregateIterator() {
        }

        private int findNext() {
            int i = this.index;
            if (i < DWARFProgram.this.dieOffsets.length) {
                ++i;
                while (i < DWARFProgram.this.dieOffsets.length) {
                    if (!DWARFProgram.this.indexHasRef.get(i)) {
                        return i;
                    }
                    ++i;
                }
            }
            return i;
        }

        @Override
        public Iterator<DIEAggregate> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            if (this.index == -1) {
                this.index = this.findNext();
            }
            return 0 <= this.index && this.index < DWARFProgram.this.dieOffsets.length;
        }

        @Override
        public DIEAggregate next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int resultIndex = this.index;
            this.index = this.findNext();
            return DWARFProgram.this.getAggregateByIndex(resultIndex);
        }
    }
}

