/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import docking.widgets.DropDownTextFieldDataModel;
import docking.widgets.list.GListCellRenderer;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.datastruct.CaseInsensitiveDuplicateStringComparator;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.help.UnsupportedOperationException;
import javax.swing.ListCellRenderer;
import org.apache.commons.lang3.StringUtils;

public class NamespaceDropDownModel
implements DropDownTextFieldDataModel<Namespace> {
    private static final char END_CHAR = '\uffff';
    private List<Namespace> namespaces;
    private ListCellRenderer<Namespace> renderer;
    private Comparator<Namespace> comparator = (n1, n2) -> n1.getName().compareToIgnoreCase(n2.getName());
    private Comparator<String> stringComparator = new CaseInsensitiveDuplicateStringComparator();

    NamespaceDropDownModel() {
        this.renderer = GListCellRenderer.createDefaultTextRenderer(this::getListDisplay);
        this.setNamespaces(Collections.emptyList());
    }

    public List<Namespace> getMatchingData(String searchText) {
        throw new UnsupportedOperationException("Method no longer supported.  Instead, call getMatchingData(String, SearchMode)");
    }

    public void setNamespaces(List<Namespace> namespaces) {
        this.namespaces = namespaces;
        Collections.sort(namespaces, this.comparator);
    }

    private String getListDisplay(Namespace namespace) {
        StringBuilder buf = new StringBuilder(namespace.getName());
        Namespace parentNamespace = namespace.getParentNamespace();
        if (parentNamespace != null) {
            buf.append("  (");
            buf.append(parentNamespace.getName(true));
            buf.append(")");
        }
        return buf.toString();
    }

    public List<Namespace> getMatchingData(String searchText, DropDownTextFieldDataModel.SearchMode searchMode) {
        if (StringUtils.isBlank((CharSequence)searchText)) {
            return new ArrayList<Namespace>(this.namespaces);
        }
        if (!this.getSupportedSearchModes().contains(searchMode)) {
            throw new IllegalArgumentException("Unsupported SearchMode: " + String.valueOf(searchMode));
        }
        if (searchMode == DropDownTextFieldDataModel.SearchMode.STARTS_WITH) {
            return this.getMatchingDataStartsWith(searchText);
        }
        Pattern p = searchMode.createPattern(searchText);
        return this.getMatchingDataRegex(p);
    }

    private List<Namespace> getMatchingDataRegex(Pattern p) {
        ArrayList<Namespace> results = new ArrayList<Namespace>();
        for (Namespace namespace : this.namespaces) {
            String namespacePath = namespace.getName(true);
            Matcher m = p.matcher(namespacePath);
            if (!m.matches()) continue;
            results.add(namespace);
        }
        return results;
    }

    private List<Namespace> getMatchingDataStartsWith(String searchText) {
        MappedList<Namespace, String> list = new MappedList<Namespace, String>(this.namespaces, n -> n.getName());
        int startIndex = Collections.binarySearch(list, searchText, this.stringComparator);
        int endIndex = Collections.binarySearch(list, searchText + "\uffff", this.stringComparator);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if (endIndex < 0) {
            endIndex = -endIndex - 1;
        }
        return this.namespaces.subList(startIndex, endIndex);
    }

    public List<DropDownTextFieldDataModel.SearchMode> getSupportedSearchModes() {
        return List.of(DropDownTextFieldDataModel.SearchMode.STARTS_WITH, DropDownTextFieldDataModel.SearchMode.CONTAINS, DropDownTextFieldDataModel.SearchMode.WILDCARD);
    }

    public int getIndexOfFirstMatchingEntry(List<Namespace> data, String text) {
        int lastPreferredMatchIndex = -1;
        int i = 0;
        while (i < data.size()) {
            Namespace namespace = data.get(i);
            String name = namespace.getName();
            if (name.equals(text)) {
                return i;
            }
            if (!name.equalsIgnoreCase(text)) {
                return lastPreferredMatchIndex;
            }
            lastPreferredMatchIndex = i++;
        }
        return -1;
    }

    public ListCellRenderer<Namespace> getListRenderer() {
        return this.renderer;
    }

    public String getDescription(Namespace value) {
        return value.getName(true);
    }

    public String getDisplayText(Namespace value) {
        return value.getName(false);
    }

    private static class MappedList<S, T>
    extends AbstractList<T> {
        private final List<S> sourceList;
        private final Function<S, T> transformer;

        public MappedList(List<S> sourceList, Function<S, T> transformer) {
            this.sourceList = sourceList;
            this.transformer = transformer;
        }

        @Override
        public T get(int index) {
            return this.transformer.apply(this.sourceList.get(index));
        }

        @Override
        public int size() {
            return this.sourceList.size();
        }
    }
}

