/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.references;

import docking.DialogComponentProvider;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.label.GLabel;
import ghidra.app.plugin.core.references.EditReferencePanel;
import ghidra.app.plugin.core.references.EditReferencesProvider;
import ghidra.app.plugin.core.references.ReferencesPlugin;
import ghidra.app.util.AddressInput;
import ghidra.framework.main.ProgramFileChooser;
import ghidra.framework.model.DomainFile;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.Reference;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class EditExternalReferencePanel
extends EditReferencePanel {
    private ReferencesPlugin plugin;
    private CodeUnit fromCodeUnit;
    private int opIndex;
    private ExternalReference editRef;
    private JButton clearButton;
    private JButton editButton;
    private GhidraComboBox<String> extLibName;
    private JTextField extLibPath;
    private JTextField extLabel;
    private AddressInput extAddr;
    private boolean isValidState;

    EditExternalReferencePanel(ReferencesPlugin plugin) {
        super("EXT");
        this.plugin = plugin;
        this.buildPanel();
    }

    private void buildPanel() {
        JPanel topPanel = new JPanel((LayoutManager)new PairLayout(5, 10, 160));
        topPanel.setBorder(new CompoundBorder(new TitledBorder("External Program"), new EmptyBorder(0, 5, 5, 5)));
        topPanel.add((Component)new GLabel("Name:", 4));
        this.extLibName = new GhidraComboBox();
        this.extLibName.getAccessibleContext().setAccessibleDescription("Choose external program name");
        this.extLibName.setEditable(true);
        this.extLibName.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                EditExternalReferencePanel.this.extProgNameChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EditExternalReferencePanel.this.extProgNameChanged();
            }
        });
        this.extLibName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                EditExternalReferencePanel.this.extProgNameChanged();
                EditExternalReferencePanel.this.updateExtLibPath();
            }
        });
        topPanel.add((Component)this.extLibName);
        this.extLibPath = new JTextField();
        this.extLibPath.setBackground(this.getBackground());
        this.extLibPath.setEditable(false);
        this.extLibPath.setFocusable(false);
        this.clearButton = new JButton("Clear");
        this.clearButton.setToolTipText("Remove Link to External Program");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditExternalReferencePanel.this.extLibPath.setText(null);
            }
        });
        this.editButton = new JButton("Select...");
        this.editButton.setToolTipText("Select External Program");
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditExternalReferencePanel.this.popupProgramChooser();
            }
        });
        JPanel pathPanel = new JPanel(new BorderLayout());
        pathPanel.add((Component)this.extLibPath, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(0, 0, 0));
        buttonPanel.add(this.clearButton);
        buttonPanel.add(this.editButton);
        pathPanel.add((Component)buttonPanel, "East");
        topPanel.add((Component)new GLabel("Path:", 4));
        topPanel.add(pathPanel);
        JPanel bottomPanel = new JPanel((LayoutManager)new PairLayout(10, 10, 160));
        bottomPanel.setBorder(new CompoundBorder(new TitledBorder("External Reference Data"), new EmptyBorder(0, 5, 5, 5)));
        bottomPanel.add((Component)new GLabel("Label:", 4));
        this.extLabel = new JTextField();
        this.extLabel.getAccessibleContext().setAccessibleName("External Label");
        bottomPanel.add(this.extLabel);
        bottomPanel.add((Component)new GLabel("Address:", 4));
        this.extAddr = new AddressInput();
        this.extAddr.getAccessibleContext().setAccessibleName("External Address");
        bottomPanel.add(this.extAddr);
        this.setLayout((LayoutManager)new VerticalLayout(5));
        this.add(topPanel);
        this.add(bottomPanel);
    }

    private void extProgNameChanged() {
        boolean hasText = this.extLibName.getText().trim().length() != 0;
        this.clearButton.setEnabled(hasText);
        this.editButton.setEnabled(hasText);
        this.extLibPath.setText(null);
    }

    private void populateExternalNames() {
        Object[] names = this.fromCodeUnit.getProgram().getExternalManager().getExternalLibraryNames();
        this.extLibName.clearModel();
        this.extLibName.addItem((Object)"<EXTERNAL>");
        Arrays.sort(names);
        for (Object name : names) {
            if ("<EXTERNAL>".equals(name)) continue;
            this.extLibName.addItem(name);
        }
    }

    private void updateExtLibPath() {
        String name = this.extLibName.getText().trim();
        String path = null;
        if (name.length() != 0) {
            name = name.trim();
            path = this.fromCodeUnit.getProgram().getExternalManager().getExternalLibraryPath(name);
        }
        this.extLibPath.setText(path);
    }

    private void popupProgramChooser() {
        final ProgramFileChooser dialog = new ProgramFileChooser(this.getParent(), "Choose External Program");
        dialog.addOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DomainFile df = dialog.getDomainFile();
                if (df == null) {
                    return;
                }
                String pathName = df.getPathname();
                if (pathName.equals(EditExternalReferencePanel.this.fromCodeUnit.getProgram().getDomainFile().getPathname())) {
                    dialog.setStatusText("Selected program is the same as current program");
                    return;
                }
                dialog.close();
                EditExternalReferencePanel.this.extLibPath.setText(df.getPathname());
            }
        });
        this.plugin.getTool().showDialog((DialogComponentProvider)dialog);
    }

    @Override
    public void initialize(CodeUnit fromCu, Reference ref) {
        this.isValidState = false;
        this.fromCodeUnit = fromCu;
        Program program = fromCu.getProgram();
        Address toAddr = ref.getToAddress();
        if (!toAddr.isExternalAddress()) {
            throw new IllegalArgumentException("Expected external reference");
        }
        this.editRef = (ExternalReference)ref;
        ExternalLocation extLoc = this.editRef.getExternalLocation();
        this.populateExternalNames();
        String name = extLoc.getLibraryName();
        this.extLibName.setSelectedItem((Object)name);
        this.extProgNameChanged();
        this.updateExtLibPath();
        this.extLabel.setText(extLoc.getLabel());
        this.extAddr.setProgram(program);
        Address addr = extLoc.getAddress();
        if (addr != null) {
            this.extAddr.setAddress(addr);
        } else {
            this.extAddr.clear();
        }
        this.extLibName.requestFocus();
        this.isValidState = true;
    }

    @Override
    public boolean initialize(CodeUnit fromCu, int fromOpIndex, int fromSubIndex) {
        this.isValidState = false;
        this.editRef = null;
        this.fromCodeUnit = fromCu;
        Program program = fromCu.getProgram();
        this.populateExternalNames();
        this.extLibName.setSelectedItem((Object)"<EXTERNAL>");
        this.extProgNameChanged();
        this.extLibPath.setText(null);
        this.extLabel.setText(null);
        this.extAddr.setProgram(program);
        this.extAddr.clear();
        this.extLibName.requestFocus();
        return this.setOpIndex(fromOpIndex);
    }

    @Override
    public boolean setOpIndex(int opIndex) {
        if (this.editRef != null) {
            throw new IllegalStateException("setOpIndex only permitted for ADD case");
        }
        this.isValidState = false;
        this.opIndex = opIndex;
        if (opIndex == EditReferencesProvider.MNEMONIC_OPINDEX) {
            return false;
        }
        this.isValidState = true;
        return true;
    }

    @Override
    public boolean applyReference() {
        if (!this.isValidState) {
            throw new IllegalStateException();
        }
        String name = this.extLibName.getText();
        if (name == null || name.trim().length() == 0) {
            this.showInputErr("An external program 'Name' must be specified.");
            return false;
        }
        name = name.trim();
        String libraryProgramPathname = this.extLibPath.getText();
        Address addr = this.extAddr.getAddress();
        String label = this.extLabel.getText();
        if (label != null) {
            label = label.trim();
        }
        if (addr == null && this.extAddr.hasInput()) {
            AddressSpace space = this.extAddr.getAddressSpace();
            this.showInputErr("Invalid address specified, " + space.getName() + " offset must be in range: " + space.getMinAddress().toString(false) + " to " + space.getMaxAddress().toString(false));
            return false;
        }
        if (addr == null && (label == null || label.length() == 0)) {
            this.showInputErr("Either (or both) an external 'Label' and/or 'Address' must be specified.");
            return false;
        }
        if (this.editRef != null) {
            return this.plugin.updateReference(this.editRef, this.fromCodeUnit, name, libraryProgramPathname, addr, label);
        }
        return this.plugin.addReference(this.fromCodeUnit, this.opIndex, name, libraryProgramPathname, addr, label);
    }

    @Override
    public void cleanup() {
        this.isValidState = false;
        this.fromCodeUnit = null;
        this.editRef = null;
    }

    @Override
    public boolean isValidContext() {
        return this.isValidState;
    }
}

