/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.editor;

import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.actions.DockingToolActions;
import docking.actions.SharedDockingActionPlaceholder;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeViewerDataTypeManager;
import ghidra.app.plugin.core.compositeeditor.EditorListener;
import ghidra.app.plugin.core.compositeeditor.EditorProvider;
import ghidra.app.plugin.core.compositeeditor.StructureEditorProvider;
import ghidra.app.plugin.core.compositeeditor.UnionEditorProvider;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.editor.EditorOptionManager;
import ghidra.app.plugin.core.datamgr.editor.EnumEditorProvider;
import ghidra.app.plugin.core.function.AbstractEditFunctionSignatureDialog;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.Union;
import ghidra.program.model.data.UnionDataType;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.InvalidNameException;
import ghidra.util.MessageType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DataTypeEditorManager
implements EditorListener {
    private List<EditorProvider> editorList;
    private EditorOptionManager editorOptionMgr;
    private DataTypeManagerPlugin plugin;

    public DataTypeEditorManager(DataTypeManagerPlugin plugin) {
        this.plugin = plugin;
        this.initialize();
    }

    public void dispose() {
        this.dismissEditors(null);
        this.editorOptionMgr.dispose();
    }

    public HelpLocation getEditorHelpLocation(DataType dataType) {
        if (dataType instanceof Enum) {
            return new HelpLocation("DataTypeEditors", "EnumEditor");
        }
        if (dataType instanceof Union || dataType instanceof Structure) {
            return new HelpLocation("DataTypeEditors", "Structure_Editor");
        }
        return new HelpLocation("DataTypeEditors", "Structure_Editor");
    }

    public boolean isEditable(DataType dt) {
        return dt instanceof Enum || dt instanceof Union || dt instanceof Structure;
    }

    public void edit(DataType dataType) {
        EditorProvider editor = this.reuseExistingEditor(dataType);
        if (editor != null) {
            return;
        }
        if (dataType instanceof Enum) {
            editor = new EnumEditorProvider(this.plugin, (Enum)dataType);
        } else if (dataType instanceof Union) {
            editor = new UnionEditorProvider(this.plugin, (Union)dataType, this.showUnionNumbersInHex());
        } else if (dataType instanceof Structure) {
            editor = new StructureEditorProvider(this.plugin, (Structure)dataType, this.showStructureNumbersInHex());
        } else if (dataType instanceof FunctionDefinition) {
            this.editFunctionSignature((FunctionDefinition)dataType);
        }
        if (editor != null) {
            editor.addEditorListener(this);
            this.editorList.add(editor);
        }
    }

    public void edit(Composite composite, String fieldName) {
        CompositeEditorProvider editor = (CompositeEditorProvider)this.getEditor((DataType)composite);
        if (editor != null) {
            this.reuseExistingEditor((DataType)composite);
            editor.selectField(fieldName);
            return;
        }
        if (composite instanceof Union) {
            editor = new UnionEditorProvider(this.plugin, (Union)composite, this.showUnionNumbersInHex());
        } else if (composite instanceof Structure) {
            editor = new StructureEditorProvider(this.plugin, (Structure)composite, this.showStructureNumbersInHex());
        }
        editor.addEditorListener(this);
        this.editorList.add(editor);
        editor.selectField(fieldName);
    }

    private EditorProvider reuseExistingEditor(DataType dataType) {
        DataTypeManager dataTypeManager = dataType.getDataTypeManager();
        if (dataTypeManager == null) {
            throw new IllegalArgumentException("Datatype " + dataType.getName() + " doesn't have a data type manager specified.");
        }
        CategoryPath categoryPath = dataType.getCategoryPath();
        if (categoryPath == null) {
            throw new IllegalArgumentException("DataType " + dataType.getName() + " has no category path!");
        }
        EditorProvider editor = this.getEditor(dataType);
        if (editor != null) {
            ComponentProvider componentProvider = editor.getComponentProvider();
            this.plugin.getTool().showComponentProvider(componentProvider, true);
            componentProvider.toFront();
        }
        return editor;
    }

    private void installEditorActions() {
        this.registerAction("Apply Editor Changes");
        this.registerAction("Insert Undefined Byte");
        this.registerAction("Move Components Up");
        this.registerAction("Move Components Down");
        this.registerAction("Clear Components");
        this.registerAction("Duplicate Component");
        this.registerAction("Duplicate Multiple of Component");
        this.registerAction("Delete Components");
        this.registerAction("Create Pointer");
        this.registerAction("Create Array");
        this.registerAction("Find Uses of");
        this.registerAction("Unpackage Component");
        this.registerAction("Edit Component");
        this.registerAction("Edit Component Field");
        this.registerAction("Show Numbers In Hex");
        this.registerAction("Create Structure From Selection");
        this.registerAction("Show Component Path");
        this.registerAction("Add Bitfield");
        this.registerAction("Edit Bitfield");
        this.registerAction("Show In Data Type Manager");
        this.registerAction("Add Enum Value");
        this.registerAction("Apply Enum Changes");
        this.registerAction("Delete Enum Value");
    }

    private void registerAction(String name) {
        DockingToolActions toolActions = this.plugin.getTool().getToolActions();
        toolActions.registerSharedActionPlaceholder((SharedDockingActionPlaceholder)new DtSharedActionPlaceholder(name));
    }

    boolean closeEditor(EditorProvider editor, boolean allowCancel) {
        if (this.checkEditor(editor, allowCancel)) {
            this.dismissEditor(editor);
            return true;
        }
        return false;
    }

    public List<DataTypePath> getEditsInProgress() {
        ArrayList<DataTypePath> paths = new ArrayList<DataTypePath>();
        for (EditorProvider editor : this.editorList) {
            paths.add(editor.getDtPath());
        }
        return paths;
    }

    public Category getEditedDataTypeCategory(DataTypePath dataTypePath) {
        CategoryPath categoryPath = dataTypePath.getCategoryPath();
        for (EditorProvider editor : this.editorList) {
            DataTypeManager dtMgr;
            if (!dataTypePath.equals((Object)editor.getDtPath()) || !(dtMgr = editor.getDataTypeManager()).containsCategory(categoryPath)) continue;
            return dtMgr.getCategory(categoryPath);
        }
        return null;
    }

    public boolean isEditInProgress() {
        return this.editorList.size() > 0;
    }

    public void dismissEditors(DataTypeManager dtMgr) {
        ArrayList<EditorProvider> list = new ArrayList<EditorProvider>();
        for (EditorProvider editor : this.editorList) {
            DataTypeManager editorDtm = editor.getDataTypeManager();
            if (dtMgr != null && dtMgr != editorDtm) continue;
            list.add(editor);
        }
        for (EditorProvider element : list) {
            this.dismissEditor(element);
        }
    }

    void dismissEditor(EditorProvider editor) {
        if (editor != null) {
            editor.dispose();
        }
        this.editorList.remove(editor);
    }

    public boolean checkEditors(DataTypeManager dtMgr, boolean allowCancel) {
        for (EditorProvider editor : this.editorList) {
            DataTypeManager editorDtm = editor.getDataTypeManager();
            if (dtMgr != null && dtMgr != editorDtm || this.checkEditor(editor, allowCancel)) continue;
            return false;
        }
        return true;
    }

    boolean checkEditor(EditorProvider editor, boolean allowCancel) {
        if (editor != null && editor.needsSave()) {
            editor.show();
            if (!editor.checkForSave(allowCancel)) {
                return false;
            }
        }
        return true;
    }

    EditorOptionManager getEditorOptionManager() {
        return this.editorOptionMgr;
    }

    String getUniqueName(Category category, String baseName) {
        DataTypeManager dtm = category.getDataTypeManager();
        Object uniqueName = dtm.getUniqueName(category.getCategoryPath(), baseName);
        int oneUpNumber = 0;
        int pos = ((String)uniqueName).lastIndexOf(95);
        if (pos > 0) {
            try {
                String numStr = ((String)uniqueName).substring(pos + 1);
                oneUpNumber = Integer.parseInt(numStr);
                baseName = ((String)uniqueName).substring(0, pos);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        while (this.nameExists(dtm, (String)uniqueName)) {
            uniqueName = baseName + "_" + ++oneUpNumber;
        }
        return uniqueName;
    }

    public boolean nameExists(DataTypeManager dtm, String dtName) {
        for (EditorProvider editor : this.editorList) {
            DataTypePath dtPath;
            if (editor.getDataTypeManager() != dtm || !(dtPath = editor.getDtPath()).getDataTypeName().equals(dtName)) continue;
            return true;
        }
        return false;
    }

    public EditorProvider getEditor(DataType dataType) {
        DataTypeManager catDtm = dataType.getDataTypeManager();
        DataTypePath dataTypePath = dataType.getDataTypePath();
        for (EditorProvider editor : this.editorList) {
            if (editor.getDataTypeManager() != catDtm || !editor.isEditing(dataTypePath)) continue;
            return editor;
        }
        return null;
    }

    private void initialize() {
        this.editorList = new ArrayList<EditorProvider>();
        this.editorOptionMgr = new EditorOptionManager(this.plugin);
        this.installEditorActions();
    }

    @Override
    public void closed(EditorProvider editor) {
        this.editorList.remove(editor);
    }

    boolean hasEditorChanges(DataTypeManager dtMgr) {
        for (EditorProvider editor : this.editorList) {
            DataTypeManager editorDtm = editor.getDataTypeManager();
            if (dtMgr != null && dtMgr != editorDtm || !editor.needsSave()) continue;
            return true;
        }
        return false;
    }

    void close() {
        this.dismissEditors(null);
    }

    protected boolean canCloseDomainObject(DomainObject dObj) {
        if (dObj instanceof Program) {
            Program p = (Program)dObj;
            return this.checkEditors(p.getListing().getDataTypeManager(), true);
        }
        return true;
    }

    public boolean showStructureNumbersInHex() {
        return this.editorOptionMgr.showStructureNumbersInHex();
    }

    public boolean showUnionNumbersInHex() {
        return this.editorOptionMgr.showUnionNumbersInHex();
    }

    public void createNewStructure(Category category, boolean isPacked) {
        String newName = this.getUniqueName(category, "struct");
        DataTypeManager dataTypeManager = category.getDataTypeManager();
        SourceArchive sourceArchive = dataTypeManager.getLocalSourceArchive();
        StructureDataType structureDataType = new StructureDataType(category.getCategoryPath(), newName, 0, dataTypeManager);
        structureDataType.setSourceArchive(sourceArchive);
        structureDataType.setPackingEnabled(isPacked);
        this.edit((DataType)structureDataType);
    }

    public void createNewUnion(Category category, boolean isPacked) {
        String newName = this.getUniqueName(category, "union");
        DataTypeManager dataTypeManager = category.getDataTypeManager();
        SourceArchive sourceArchive = dataTypeManager.getLocalSourceArchive();
        UnionDataType unionDataType = new UnionDataType(category.getCategoryPath(), newName, dataTypeManager);
        unionDataType.setSourceArchive(sourceArchive);
        unionDataType.setPackingEnabled(isPacked);
        this.edit((DataType)unionDataType);
    }

    public void createNewEnum(Category category) {
        String newName = this.getUniqueName(category, "enum");
        DataTypeManager dataTypeManager = category.getDataTypeManager();
        SourceArchive sourceArchive = dataTypeManager.getLocalSourceArchive();
        EnumDataType dataType = new EnumDataType(category.getCategoryPath(), newName, 1, dataTypeManager);
        dataType.setSourceArchive(sourceArchive);
        this.edit((DataType)dataType);
    }

    public void createNewFunctionDefinition(Category cat) {
        this.editFunctionSignature(cat, null);
    }

    public void editFunctionSignature(FunctionDefinition functionDefinition) {
        DataTypeManager dataTypeManager = functionDefinition.getDataTypeManager();
        if (dataTypeManager == null) {
            throw new IllegalArgumentException("DataType " + functionDefinition.getPathName() + " has no DataTypeManager!  Make sure the given DataType has been resolved by a DataTypeManager");
        }
        CategoryPath categoryPath = functionDefinition.getCategoryPath();
        Category category = dataTypeManager.getCategory(categoryPath);
        if (categoryPath == null) {
            throw new IllegalArgumentException("DataType " + functionDefinition.getName() + " has no category path!");
        }
        this.editFunctionSignature(category, functionDefinition);
    }

    private void editFunctionSignature(Category category, FunctionDefinition functionDefinition) {
        PluginTool tool = this.plugin.getTool();
        DTMEditFunctionSignatureDialog editSigDialog = new DTMEditFunctionSignatureDialog(this, this.plugin.getTool(), "Edit Function Signature", category, functionDefinition);
        editSigDialog.setHelpLocation(new HelpLocation("DataTypeManagerPlugin", "Function_Definition"));
        tool.showDialog((DialogComponentProvider)editSigDialog);
    }

    private class DtSharedActionPlaceholder
    implements SharedDockingActionPlaceholder {
        private String name;

        DtSharedActionPlaceholder(String name) {
            this.name = name;
        }

        public String getOwner() {
            return DataTypeEditorManager.this.plugin.getName();
        }

        public String getName() {
            return this.name;
        }
    }

    private class DTMEditFunctionSignatureDialog
    extends AbstractEditFunctionSignatureDialog {
        private final FunctionDefinition functionDefinition;
        private final FunctionSignature oldSignature;
        private final Category category;

        DTMEditFunctionSignatureDialog(DataTypeEditorManager dataTypeEditorManager, PluginTool pluginTool, String title, Category category, FunctionDefinition functionDefinition) {
            super(pluginTool, title, false, true, false);
            this.functionDefinition = functionDefinition;
            this.category = category;
            this.oldSignature = this.buildSignature();
            if (this.isAdhocCallingConventionPermitted()) {
                this.callingConventionComboBox.setEditable(true);
            }
        }

        private boolean isAdhocCallingConventionPermitted() {
            return false;
        }

        private FunctionSignature buildSignature() {
            if (this.functionDefinition != null) {
                if (this.category.getDataTypeManager() != this.functionDefinition.getDataTypeManager()) {
                    throw new IllegalArgumentException("FunctionDefinition and Category must have same DataTypeManager");
                }
                return this.functionDefinition;
            }
            return new FunctionDefinitionDataType("newFunction", this.category.getDataTypeManager());
        }

        @Override
        protected boolean hasNoReturn() {
            return this.functionDefinition != null ? this.functionDefinition.hasNoReturn() : false;
        }

        @Override
        protected String[] getSupportedCallFixupNames() {
            return null;
        }

        @Override
        protected String getCallFixupName() {
            return null;
        }

        @Override
        protected FunctionSignature getFunctionSignature() {
            return this.oldSignature;
        }

        @Override
        protected String getPrototypeString() {
            return this.getFunctionSignature().getPrototypeString();
        }

        @Override
        protected String getCallingConventionName() {
            return this.getFunctionSignature().getCallingConventionName();
        }

        @Override
        protected List<String> getCallingConventionNames() {
            DataTypeManager dtm = this.getDataTypeManager();
            if (dtm instanceof CompositeViewerDataTypeManager) {
                CompositeViewerDataTypeManager cvdtm = (CompositeViewerDataTypeManager)dtm;
                dtm = cvdtm.getOriginalDataTypeManager();
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add("unknown");
            list.add("default");
            list.addAll(dtm.getDefinedCallingConventionNames());
            return list;
        }

        @Override
        protected DataTypeManager getDataTypeManager() {
            return this.category.getDataTypeManager();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean applyChanges() {
            block16: {
                FunctionDefinitionDataType newDefinition = null;
                try {
                    newDefinition = this.parseSignature();
                }
                catch (CancelledException cancelledException) {
                    // empty catch block
                }
                if (newDefinition == null) {
                    return false;
                }
                String callingConvention = this.getCallingConvention();
                boolean hasNoReturn = this.hasNoReturnSelected();
                try {
                    newDefinition.setCallingConvention(callingConvention);
                    newDefinition.setNoReturn(hasNoReturn);
                    DataTypeManager manager = this.getDataTypeManager();
                    SourceArchive sourceArchive = manager.getLocalSourceArchive();
                    if (this.functionDefinition == null) {
                        newDefinition.setSourceArchive(sourceArchive);
                        newDefinition.setCategoryPath(this.category.getCategoryPath());
                        int id = manager.startTransaction("Create Function Definition");
                        try {
                            manager.addDataType((DataType)newDefinition, DataTypeConflictHandler.REPLACE_HANDLER);
                            break block16;
                        }
                        finally {
                            manager.endTransaction(id, true);
                        }
                    }
                    int id = manager.startTransaction("Edit Function Definition");
                    try {
                        if (!this.functionDefinition.getName().equals(newDefinition.getName())) {
                            this.functionDefinition.setName(newDefinition.getName());
                        }
                        this.functionDefinition.setArguments(newDefinition.getArguments());
                        if (!Objects.equals(callingConvention, this.functionDefinition.getCallingConventionName())) {
                            this.functionDefinition.setCallingConvention(callingConvention);
                        }
                        this.functionDefinition.setReturnType(newDefinition.getReturnType());
                        this.functionDefinition.setVarArgs(newDefinition.hasVarArgs());
                        this.functionDefinition.setNoReturn(hasNoReturn);
                    }
                    catch (InvalidNameException | DuplicateNameException e) {
                        Msg.error((Object)((Object)this), (Object)"Unexpected Exception", (Throwable)e);
                    }
                    finally {
                        manager.endTransaction(id, true);
                    }
                }
                catch (InvalidInputException e) {
                    this.setStatusText("Unknown calling convention specified: " + callingConvention, MessageType.ERROR);
                    return false;
                }
            }
            return true;
        }
    }
}

