/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.datatypes;

import generic.theme.GAttributes;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import generic.theme.Gui;
import ghidra.app.merge.MergeConstants;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.CompositeInternal;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypeDefSettingsDefinition;
import ghidra.util.StringUtilities;
import ghidra.util.UniversalID;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Arrays;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;

class DataTypePanel
extends JPanel {
    public GColor SOURCE_COLOR = GThemeDefaults.Colors.Palette.GREEN;
    private DataType dataType;
    private JTextPane textPane;
    private StyledDocument doc;
    private SimpleAttributeSet pathAttrs;
    private SimpleAttributeSet nameAttrs;
    private SimpleAttributeSet sourceAttrs;
    private SimpleAttributeSet offsetAttrs;
    private SimpleAttributeSet contentAttrs;
    private SimpleAttributeSet fieldNameAttrs;
    private SimpleAttributeSet commentAttrs;
    private SimpleAttributeSet deletedAttrs;

    DataTypePanel(DataType dataType) {
        super(new BorderLayout());
        this.dataType = dataType;
        this.create();
    }

    void setDataType(DataType dataType) {
        this.dataType = dataType;
        this.textPane.setText("");
        if (dataType instanceof Composite) {
            this.formatCompositeText((Composite)dataType);
        } else if (dataType instanceof Enum) {
            this.formatEnumText((Enum)dataType);
        } else if (dataType instanceof TypeDef) {
            this.formatTypeDefText((TypeDef)dataType);
        } else if (dataType instanceof FunctionDefinition) {
            this.formatFunctionDef((FunctionDefinition)dataType);
        } else {
            this.formatDataType(dataType);
        }
        if (dataType != null) {
            this.formatDataTypeSettings(dataType);
        }
        this.textPane.setCaretPosition(0);
    }

    private void create() {
        this.textPane = new JTextPane();
        this.doc = this.textPane.getStyledDocument();
        this.add((Component)this.textPane, "Center");
        this.textPane.setEditable(false);
        Font monospaced = Gui.getFont((String)"font.monospaced");
        Font bold = Gui.getFont((String)"font.standard.bold");
        this.pathAttrs = new GAttributes(bold, (Color)MergeConstants.CONFLICT_COLOR);
        this.nameAttrs = new GAttributes(bold);
        this.sourceAttrs = new GAttributes(bold, (Color)this.SOURCE_COLOR);
        this.offsetAttrs = new GAttributes(monospaced, (Color)GThemeDefaults.Colors.Palette.BLACK);
        this.contentAttrs = new GAttributes(monospaced, (Color)GThemeDefaults.Colors.Palette.BLUE);
        this.fieldNameAttrs = new GAttributes(monospaced, (Color)GThemeDefaults.Colors.Palette.MAGENTA);
        this.commentAttrs = new GAttributes(monospaced, (Color)GThemeDefaults.Colors.Palette.LIME);
        this.deletedAttrs = new GAttributes(bold, (Color)GThemeDefaults.Colors.Palette.RED);
        this.setDataType(this.dataType);
    }

    private void formatPath(DataType dt) {
        this.insertString("Path: " + String.valueOf(dt.getCategoryPath()) + "\n\n", this.pathAttrs);
    }

    private void formatSourceArchive(DataType dt) {
        this.insertString("Source Archive: " + this.getSourceArchiveName(dt) + "\n", this.sourceAttrs);
    }

    private String getSourceArchiveName(DataType dt) {
        UniversalID sourceID;
        SourceArchive sourceArchive = dt.getSourceArchive();
        UniversalID universalID = sourceID = sourceArchive != null ? sourceArchive.getSourceArchiveID() : null;
        if (sourceID == null) {
            return "Local";
        }
        return sourceArchive.getName();
    }

    private void formatAlignment(Composite composite) {
        String str = CompositeInternal.getAlignmentAndPackingString((Composite)composite);
        this.insertString(str + "\n\n", this.sourceAttrs);
    }

    private void insertAlignment(Composite composite) {
        StringBuffer alignmentBuffer = new StringBuffer();
        alignmentBuffer.append("Alignment: ");
        alignmentBuffer.append(Integer.toString(composite.getAlignment()));
        this.insertString(alignmentBuffer.toString() + "\n", this.sourceAttrs);
    }

    private void insertLength(Composite composite) {
        StringBuffer lengthBuffer = new StringBuffer();
        lengthBuffer.append("Length: ");
        lengthBuffer.append(Integer.toString(composite.getLength()));
        this.insertString(lengthBuffer.toString() + "\n", this.sourceAttrs);
    }

    private int max(String str, int length) {
        if (str == null) {
            return length;
        }
        return Math.max(str.length(), length);
    }

    private String getDataTypeName(DataTypeComponent dtc) {
        DataType dt = dtc.getDataType();
        StringBuilder buffer = new StringBuilder();
        buffer.append(dt.getName());
        if (dt instanceof BitFieldDataType && !((Composite)dtc.getParent()).isPackingEnabled()) {
            BitFieldDataType bfDt = (BitFieldDataType)dt;
            buffer.append("(");
            buffer.append(Integer.toString(bfDt.getBitOffset()));
            buffer.append(")");
        }
        return buffer.toString();
    }

    private void renderComponent(DataTypeComponent dtc, int dtNameWidth, int fieldNameWidth, int offsetWidth) {
        String comment;
        String fieldName = dtc.getFieldName();
        if (fieldName == null) {
            fieldName = "";
        }
        if ((comment = dtc.getComment()) == null) {
            comment = "";
        }
        Object offsetStr = "";
        if ((offsetWidth += 2) > 0) {
            offsetStr = "0x" + Integer.toHexString(dtc.getOffset());
            offsetStr = StringUtilities.pad((String)offsetStr, (char)' ', (int)(offsetWidth - ((String)offsetStr).length()));
            offsetStr = (String)offsetStr + ": ";
            this.insertString("  " + (String)offsetStr + "  ", this.offsetAttrs);
        }
        fieldName = this.pad(fieldName, fieldNameWidth);
        String typeName = this.pad(this.getDataTypeName(dtc), dtNameWidth);
        this.insertString("    " + typeName + "  ", this.contentAttrs);
        this.insertString(fieldName + "   ", this.fieldNameAttrs);
        this.insertString(comment, this.commentAttrs);
        this.insertString("\n", this.contentAttrs);
    }

    private void formatCompositeText(Composite comp) {
        this.formatSourceArchive((DataType)comp);
        this.formatPath((DataType)comp);
        this.formatAlignment(comp);
        this.insertString(comp.getDisplayName(), this.nameAttrs);
        this.insertString(" { \n", this.contentAttrs);
        boolean showComponentOffset = false;
        DataTypeComponent[] components = comp.getDefinedComponents();
        if (comp instanceof Structure) {
            showComponentOffset = !comp.isPackingEnabled();
        }
        int offsetLength = showComponentOffset ? Integer.toHexString(comp.getLength()).length() : 0;
        int maxDtNameLength = 10;
        int maxFieldNameLength = 1;
        for (DataTypeComponent component : components) {
            maxDtNameLength = this.max(this.getDataTypeName(component), maxDtNameLength);
            maxFieldNameLength = this.max(component.getFieldName(), maxFieldNameLength);
        }
        for (DataTypeComponent component : components) {
            this.renderComponent(component, maxDtNameLength, maxFieldNameLength, offsetLength);
        }
        this.insertString("}\n\n", this.contentAttrs);
        this.insertAlignment(comp);
        this.insertLength(comp);
    }

    private void formatEnumText(Enum enuum) {
        this.formatSourceArchive((DataType)enuum);
        this.formatPath((DataType)enuum);
        this.insertString(enuum.getDisplayName(), this.nameAttrs);
        this.insertString(" { \n", this.contentAttrs);
        StringBuffer sb = new StringBuffer();
        int maxNameLength = 0;
        int maxValueLength = 0;
        String[] names = enuum.getNames();
        Object[] entries = new EnumEntry[names.length];
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            EnumEntry entry = new EnumEntry(this, name, enuum.getValue(name), enuum.getComment(name));
            entries[i] = entry;
            maxNameLength = Math.max(maxNameLength, name.length());
            String valStr = Long.toHexString(entry.value);
            maxValueLength = Math.max(maxValueLength, valStr.length());
        }
        Arrays.sort(entries);
        for (Object entry : entries) {
            this.renderEnumEntry((EnumEntry)entry, maxNameLength, maxValueLength);
        }
        sb.append("}\n");
        this.insertString(sb.toString(), this.contentAttrs);
    }

    private void renderEnumEntry(EnumEntry entry, int maxNameLength, int maxValueLength) {
        String name = entry.name;
        name = this.pad(name, maxNameLength);
        String valStr = Long.toHexString(entry.value);
        valStr = this.pad(valStr, maxValueLength);
        this.insertString("    " + name, this.fieldNameAttrs);
        this.insertString(" = 0x" + valStr, this.contentAttrs);
        if (entry.comment != null) {
            this.insertString("   " + entry.comment, this.commentAttrs);
        }
        this.insertString("\n", this.contentAttrs);
    }

    private void formatTypeDefText(TypeDef td) {
        this.formatSourceArchive((DataType)td);
        this.formatPath((DataType)td);
        this.insertString(td.getDisplayName(), this.nameAttrs);
        this.insertString("\n", this.contentAttrs);
        this.insertString("  TypeDef on " + td.getDataType().getDisplayName(), this.contentAttrs);
    }

    private void formatDataTypeSettings(DataType dt) {
        Settings settings = dt.getDefaultSettings();
        SettingsDefinition[] defs = SettingsDefinition.filterSettingsDefinitions((SettingsDefinition[])dt.getSettingsDefinitions(), def -> def instanceof TypeDefSettingsDefinition && def.hasValue(settings));
        if (defs.length == 0) {
            return;
        }
        this.insertString("\n\nSettings\n", this.sourceAttrs);
        for (SettingsDefinition def2 : defs) {
            this.insertString("  " + def2.getName() + ": " + def2.getValueString(settings) + "\n", this.contentAttrs);
        }
    }

    private void formatFunctionDef(FunctionDefinition fd) {
        this.formatSourceArchive((DataType)fd);
        this.formatPath((DataType)fd);
        ParameterDefinition[] vars = fd.getArguments();
        DataType returnType = fd.getReturnType();
        if (fd.hasNoReturn()) {
            this.insertString("noreturn  ", this.contentAttrs);
        }
        this.insertString(returnType.getDisplayName(), this.contentAttrs);
        String callingConventionName = fd.getCallingConventionName();
        if (!"unknown".equals(callingConventionName)) {
            this.insertString(callingConventionName + "  ", this.contentAttrs);
        }
        this.insertString("  " + fd.getDisplayName(), this.nameAttrs);
        this.insertString(" (", this.contentAttrs);
        boolean hasVarArgs = fd.hasVarArgs();
        if (vars.length == 0 && !hasVarArgs) {
            this.insertString(")", this.contentAttrs);
            return;
        }
        int maxLength = 0;
        for (ParameterDefinition var : vars) {
            String typeName = var.getDataType().getDisplayName();
            if (typeName.length() <= maxLength) continue;
            maxLength = typeName.length();
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < vars.length; ++i) {
            sb.append("\n");
            String name = vars[i].getDataType().getDisplayName();
            name = this.pad(name, maxLength);
            sb.append("    " + name + " " + vars[i].getName());
            if (i >= vars.length - 1 && (vars.length <= 0 || !hasVarArgs)) continue;
            sb.append(",");
        }
        if (hasVarArgs) {
            if (vars.length > 0) {
                sb.append("\n").append("    ");
            }
            sb.append("...");
        }
        sb.append(")");
        this.insertString(sb.toString(), this.contentAttrs);
    }

    private void formatDataType(DataType dt) {
        if (dt == null) {
            this.insertString("\n\nDeleted", this.deletedAttrs);
            return;
        }
        this.formatSourceArchive(dt);
        this.formatPath(dt);
        this.insertString(dt.getDisplayName(), this.nameAttrs);
    }

    private String pad(String str, int length) {
        StringBuffer sb = new StringBuffer(str);
        int len = length - str.length();
        for (int i = 0; i < len; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private void insertString(String str, SimpleAttributeSet attrSet) {
        int offset = this.doc.getLength();
        try {
            this.doc.insertString(offset, str, attrSet);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private class EnumEntry
    implements Comparable<EnumEntry> {
        private final String name;
        private final long value;
        private final String comment;

        EnumEntry(DataTypePanel dataTypePanel, String name, long value, String comment) {
            this.name = name;
            this.value = value;
            this.comment = comment;
        }

        @Override
        public int compareTo(EnumEntry o) {
            int c = Long.compare(this.value, o.value);
            if (c == 0) {
                c = this.name.compareTo(o.name);
            }
            return c;
        }
    }
}

