/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class AddRegisterVarCmd
implements Command<Program> {
    private Address addr;
    private Register reg;
    private String name;
    private SourceType source;
    private String errMsg = "";
    private DataType dt = null;

    public AddRegisterVarCmd(Address addr, Register reg, String name, SourceType source) {
        this.addr = addr;
        this.reg = reg;
        this.name = name;
        this.source = source;
    }

    public AddRegisterVarCmd(Address addr, Register reg, String name, DataType dataType, SourceType source) {
        this.addr = addr;
        this.reg = reg;
        this.name = name;
        this.dt = dataType;
        this.source = source;
    }

    public boolean applyTo(Program program) {
        Function f = program.getListing().getFunctionContaining(this.addr);
        if (f == null) {
            this.errMsg = "Address not contained within function: " + String.valueOf(this.addr);
            return false;
        }
        int firstUseOffset = (int)this.addr.subtract(f.getEntryPoint());
        try {
            LocalVariableImpl var = new LocalVariableImpl(this.name, firstUseOffset, this.dt, this.reg, program);
            if (f.addLocalVariable((Variable)var, this.source) == null) {
                this.errMsg = "Create register variable failed";
                return false;
            }
        }
        catch (DuplicateNameException e) {
            this.errMsg = "Variable named " + this.name + " already exists";
            return false;
        }
        catch (InvalidInputException e) {
            this.errMsg = "Variable named " + this.name + ": " + e.getMessage();
            return false;
        }
        return true;
    }

    public String getName() {
        return "Create Register Variable";
    }

    public String getStatusMsg() {
        return this.errMsg;
    }
}

