/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data;

import ghidra.app.cmd.data.AbstractCreateStructureCmd;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureFactory;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.util.CodeUnitInsertionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CreateStructureCmd
extends AbstractCreateStructureCmd {
    private int structureDataLength;
    private Structure structure;

    public CreateStructureCmd(Address address, int length) {
        this("struct", address, length);
    }

    public CreateStructureCmd(String name, Address address, int length) {
        super(name, address);
        this.structureDataLength = length;
    }

    public CreateStructureCmd(Structure newStructure, Address address) {
        super(newStructure.getName(), address);
        this.structure = newStructure;
        this.structureDataLength = this.structure.getLength();
    }

    @Override
    Structure createStructure(Address address, Program program) {
        if (this.structure == null) {
            this.structure = StructureFactory.createStructureDataType((Program)program, (Address)address, (int)this.structureDataLength, (String)this.getStructureName(), (boolean)true);
        }
        return this.structure;
    }

    @Override
    DataType initializeStructureData(Program program, Structure localStructure) {
        Address endAddress;
        Listing listing = program.getListing();
        try {
            endAddress = this.getStructureAddress().addNoWrap((long)(this.structureDataLength - 1));
        }
        catch (AddressOverflowException e1) {
            throw new IllegalArgumentException("Can't create structure because length exceeds address space" + this.structureDataLength);
        }
        ReferenceManager refMgr = program.getReferenceManager();
        List<Reference> refs = this.findExistingRefs(refMgr, program.getAddressFactory(), this.getStructureAddress(), endAddress);
        listing.clearCodeUnits(this.getStructureAddress(), endAddress, false);
        Data data = null;
        try {
            listing.createData(this.getStructureAddress(), (DataType)localStructure, localStructure.getLength());
            refMgr.removeAllReferencesFrom(this.getStructureAddress(), endAddress);
            this.addRefs(program, refMgr, refs);
            data = listing.getDataAt(this.getStructureAddress());
        }
        catch (CodeUnitInsertionException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return data.getDataType();
    }

    private List<Reference> findExistingRefs(ReferenceManager refMgr, AddressFactory af, Address start, Address end) {
        ArrayList<Reference> list = new ArrayList<Reference>();
        AddressIterator it = refMgr.getReferenceSourceIterator((AddressSetView)new AddressSet(start, end), true);
        while (it.hasNext()) {
            Address addr = it.next();
            Reference[] refs = refMgr.getReferencesFrom(addr);
            Collections.addAll(list, refs);
        }
        return list;
    }

    private void addRefs(Program p, ReferenceManager refMgr, List<Reference> refs) {
        for (Reference ref : refs) {
            refMgr.addReference(ref);
        }
    }
}

