/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint;

import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompiler.taint.TaintState;
import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighLocal;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeException;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;

public class TaintLabel {
    private TaintState.MarkType mtype;
    private ClangToken token;
    private String fname;
    private HighFunction hfun;
    private HighVariable hvar;
    private Varnode vnode;
    private boolean active;
    private String label;
    private boolean isGlobal = false;
    private boolean bySymbol = false;
    private Address addr;
    private ClangLine clangLine;
    private int size = 0;

    public TaintLabel(TaintState.MarkType mtype, ClangToken token) throws PcodeException {
        Address target;
        String string;
        HighVariable high;
        HighVariable highVar = token.getHighVariable();
        if (highVar == null) {
            this.hfun = token.getClangFunction().getHighFunction();
        } else {
            this.hfun = highVar.getHighFunction();
            HighSymbol symbol = highVar.getSymbol();
            if (symbol != null) {
                this.isGlobal = symbol.isGlobal();
            }
        }
        this.vnode = token.getVarnode();
        if (this.vnode != null && (high = this.vnode.getHigh()) instanceof HighLocal) {
            highVar = this.hfun.splitOutMergeGroup(high, this.vnode);
        }
        if (token instanceof ClangFuncNameToken) {
            ClangFuncNameToken ftoken = (ClangFuncNameToken)token;
            string = ftoken.getText();
        } else {
            string = this.hfun.getFunction().getName();
        }
        String fn = string;
        PcodeOp pcodeOp = token.getPcodeOp();
        Address address = target = pcodeOp == null ? this.hfun.getFunction().getEntryPoint() : pcodeOp.getSeqnum().getTarget();
        if (this.vnode == null && pcodeOp != null) {
            this.vnode = pcodeOp.getOutput();
            highVar = this.vnode.getHigh();
        }
        this.mtype = mtype;
        this.token = token;
        this.fname = fn;
        this.hvar = highVar;
        this.active = true;
        this.addr = target;
        if (this.hvar != null) {
            this.size = this.hvar.getSize();
        }
        this.clangLine = token.getLineParent();
        this.label = mtype.toString();
    }

    public ClangLine getClangLine() {
        return this.clangLine;
    }

    public void setClangLine(ClangLine clangLine) {
        this.clangLine = clangLine;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public TaintState.MarkType getType() {
        return this.mtype;
    }

    public ClangToken getToken() {
        return this.token;
    }

    public HighFunction getHighFunction() {
        return this.hfun;
    }

    public String getFunctionName() {
        return this.fname;
    }

    public HighVariable getHighVariable() {
        return this.hvar;
    }

    public Address getAddress() {
        return this.addr;
    }

    public String toString() {
        String result = this.mtype.toString() + " ";
        result = this.isActive() ? result + "[ACTIVE]: " : result + "[INACTIVE]: ";
        result = result + this.fname;
        if (this.hvar != null) {
            result = result + ", " + this.hvar.toString();
        }
        if (this.clangLine != null) {
            result = result + ", " + this.clangLine.toString();
        }
        return result;
    }

    public void deactivate() {
        this.active = false;
    }

    public void activate() {
        this.active = true;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void toggle() {
        this.active = !this.active;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public boolean bySymbol() {
        return this.bySymbol;
    }

    public void setBySymbol(boolean bySymbol) {
        this.bySymbol = bySymbol;
    }

    public boolean hasHighVar() {
        return this.hvar != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.mtype.hashCode();
        result = prime * result + this.fname.hashCode();
        if (this.hvar != null) {
            result = prime * result + this.hvar.hashCode();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        TaintLabel other = (TaintLabel)o;
        if (this.mtype != other.mtype) {
            return false;
        }
        if (!this.fname.equals(other.fname)) {
            return false;
        }
        return this.hvar == other.hvar;
    }

    public Address getVarnodeAddress() {
        if (this.vnode != null) {
            return this.vnode.getAddress();
        }
        return null;
    }
}

