/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.taint.state;

import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.TraceEmulationIntegration;
import ghidra.pcode.exec.trace.data.PcodeTracePropertyAccess;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.taint.model.TaintSet;
import ghidra.taint.model.TaintVec;

public class TaintPieceHandler
extends TraceEmulationIntegration.AbstractPropertyBasedPieceHandler<byte[], TaintVec, String> {
    public static final String NAME = "Taint";

    public Class<byte[]> getAddressDomain() {
        return byte[].class;
    }

    public Class<TaintVec> getValueDomain() {
        return TaintVec.class;
    }

    protected String getPropertyName() {
        return NAME;
    }

    protected Class<String> getPropertyType() {
        return String.class;
    }

    protected void decodeFrom(PcodeExecutorStatePiece<byte[], TaintVec> piece, AddressSetView limit, AddressRange range, String propertyValue) {
        TaintVec vec = TaintVec.copies(TaintSet.parse(propertyValue), (int)range.getLength());
        if (limit.contains(range.getMaxAddress(), range.getMaxAddress())) {
            piece.setVarInternal(range.getAddressSpace(), range.getMinAddress().getOffset(), vec.length, (Object)vec);
        } else {
            for (AddressRange sub : limit.intersectRange(range.getMinAddress(), range.getMaxAddress())) {
                int offset = (int)sub.getMinAddress().subtract(range.getMinAddress());
                TaintVec sv = vec.sub(offset, (int)sub.getLength());
                piece.setVarInternal(sub.getAddressSpace(), sub.getMinAddress().getOffset(), sv.length, (Object)sv);
            }
        }
    }

    protected void encodeInto(PcodeTracePropertyAccess<String> property, AddressRange range, TaintVec value) {
        Address min = range.getMinAddress();
        for (int i = 0; i < value.length; ++i) {
            TaintSet s = value.get(i);
            Address address = min.add((long)i);
            if (s.isEmpty()) {
                property.clear((AddressRange)new AddressRangeImpl(address, address));
                continue;
            }
            property.put(address, (Object)s.toString());
        }
    }
}

