/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.pcode.PcodeOp;
import java.math.BigInteger;

public interface PcodeArithmetic<T> {
    public static final int SIZEOF_SIZEOF = 8;

    public Class<T> getDomain();

    public Endian getEndian();

    public T unaryOp(int var1, int var2, int var3, T var4);

    default public T unaryOp(PcodeOp op, T in1) {
        return this.unaryOp(op.getOpcode(), op.getOutput().getSize(), op.getInput(0).getSize(), in1);
    }

    public T binaryOp(int var1, int var2, int var3, T var4, int var5, T var6);

    default public T binaryOp(PcodeOp op, T in1, T in2) {
        return this.binaryOp(op.getOpcode(), op.getOutput().getSize(), op.getInput(0).getSize(), in1, op.getInput(1).getSize(), in2);
    }

    default public T ptrAdd(int sizeout, int sizeinBase, T inBase, int sizeinIndex, T inIndex, int inSize) {
        T indexSized = this.binaryOp(32, sizeout, sizeinIndex, inIndex, 4, this.fromConst(inSize, 4));
        return this.binaryOp(19, sizeout, sizeinBase, inBase, sizeout, indexSized);
    }

    default public T ptrSub(int sizeout, int sizeinBase, T inBase, int sizeinOffset, T inOffset) {
        return this.binaryOp(19, sizeout, sizeinBase, inBase, sizeinOffset, inOffset);
    }

    public T modBeforeStore(int var1, AddressSpace var2, T var3, int var4, T var5);

    default public T modBeforeStore(PcodeOp op, AddressSpace space, T inOffset, T inValue) {
        return this.modBeforeStore(op.getInput(1).getSize(), space, inOffset, op.getInput(2).getSize(), inValue);
    }

    public T modAfterLoad(int var1, AddressSpace var2, T var3, int var4, T var5);

    default public T modAfterLoad(PcodeOp op, AddressSpace space, T inOffset, T inValue) {
        return this.modAfterLoad(op.getInput(1).getSize(), space, inOffset, op.getOutput().getSize(), inValue);
    }

    public T fromConst(byte[] var1);

    default public T fromConst(byte value, int size) {
        return this.fromConst(Byte.toUnsignedLong(value), size);
    }

    default public T fromConst(short value, int size) {
        return this.fromConst(Short.toUnsignedLong(value), size);
    }

    default public T fromConst(int value, int size) {
        return this.fromConst(Integer.toUnsignedLong(value), size);
    }

    default public T fromConst(long value, int size) {
        return this.fromConst(Utils.longToBytes((long)value, (int)size, (boolean)this.getEndian().isBigEndian()));
    }

    default public T fromConst(float value, int size) {
        return this.fromConst(Float.floatToRawIntBits(value), size);
    }

    default public T fromConst(double value, int size) {
        return this.fromConst(Double.doubleToRawLongBits(value), size);
    }

    default public T fromConst(boolean value, int size) {
        return this.fromConst(value ? 1L : 0L, size);
    }

    default public T fromConst(BigInteger value, int size, boolean isContextreg) {
        return this.fromConst(Utils.bigIntegerToBytes((BigInteger)value, (int)size, (isContextreg || this.getEndian().isBigEndian() ? 1 : 0) != 0));
    }

    default public T fromConst(RegisterValue value) {
        return this.fromConst(value.getUnsignedValue(), value.getRegister().getNumBytes(), value.getRegister().isProcessorContext());
    }

    default public T fromConst(BigInteger value, int size) {
        return this.fromConst(value, size, false);
    }

    default public T fromConst(Address address) {
        return this.fromConst(address.getOffset(), address.getAddressSpace().getPointerSize());
    }

    public byte[] toConcrete(T var1, Purpose var2);

    default public boolean isTrue(T cond, Purpose purpose) {
        byte[] concrete;
        for (byte b : concrete = this.toConcrete(cond, purpose)) {
            if (b == 0) continue;
            return true;
        }
        return false;
    }

    default public RegisterValue toRegisterValue(Register register, T value, Purpose purpose) {
        if (register.isProcessorContext()) {
            purpose = Purpose.CONTEXT;
        }
        return new RegisterValue(register, this.toBigInteger(value, purpose));
    }

    default public BigInteger toBigInteger(T value, Purpose purpose) {
        byte[] concrete = this.toConcrete(value, purpose);
        return Utils.bytesToBigInteger((byte[])concrete, (int)concrete.length, (purpose == Purpose.CONTEXT || this.getEndian().isBigEndian() ? 1 : 0) != 0, (boolean)false);
    }

    default public long toLong(T value, Purpose purpose) {
        byte[] concrete = this.toConcrete(value, purpose);
        return Utils.bytesToLong((byte[])concrete, (int)concrete.length, (purpose == Purpose.CONTEXT || this.getEndian().isBigEndian() ? 1 : 0) != 0);
    }

    default public float toFloat(T value, Purpose purpose) {
        return Float.intBitsToFloat((int)this.toLong(value, purpose));
    }

    default public double toDouble(T value, Purpose purpose) {
        return Double.longBitsToDouble(this.toLong(value, purpose));
    }

    default public Address toAddress(T value, AddressSpace space, Purpose purpose) {
        return space.getAddress(this.toLong(value, purpose));
    }

    public long sizeOf(T var1);

    default public T sizeOfAbstract(T value) {
        return this.fromConst(this.sizeOf(value), 8);
    }

    public static enum Purpose {
        DECODE(PcodeExecutorStatePiece.Reason.EXECUTE_DECODE),
        CONTEXT(PcodeExecutorStatePiece.Reason.EXECUTE_READ),
        CONDITION(PcodeExecutorStatePiece.Reason.EXECUTE_READ),
        BRANCH(PcodeExecutorStatePiece.Reason.EXECUTE_READ),
        LOAD(PcodeExecutorStatePiece.Reason.EXECUTE_READ),
        STORE(PcodeExecutorStatePiece.Reason.EXECUTE_READ),
        BY_DEF(PcodeExecutorStatePiece.Reason.EXECUTE_READ),
        OTHER(PcodeExecutorStatePiece.Reason.EXECUTE_READ),
        INSPECT(PcodeExecutorStatePiece.Reason.INSPECT);

        private final PcodeExecutorStatePiece.Reason reason;

        private Purpose(PcodeExecutorStatePiece.Reason reason) {
            this.reason = reason;
        }

        public PcodeExecutorStatePiece.Reason reason() {
            return this.reason;
        }
    }
}

