/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.squashfs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.squashfs.SquashInode;
import ghidra.file.formats.squashfs.SquashSuperBlock;
import java.io.IOException;

public class SquashBasicFileInode
extends SquashInode {
    protected long startBlockOffset;
    protected int fragmentIndex;
    protected int blockOffset;
    protected long fileSize;
    protected int[] blockSizes;
    protected int tailEndSize = 0;
    protected int numberOfBlocks = 0;

    public SquashBasicFileInode(BinaryReader reader, SquashSuperBlock superBlock, boolean isExtended) throws IOException {
        super(reader, superBlock);
        if (isExtended) {
            return;
        }
        this.startBlockOffset = reader.readNextUnsignedInt();
        if (reader.peekNextInt() == -1) {
            this.fragmentIndex = -1;
            this.blockOffset = -1;
            reader.setPointerIndex(reader.getPointerIndex() + 8L);
        } else {
            this.fragmentIndex = reader.readNextUnsignedIntExact();
            this.blockOffset = reader.readNextUnsignedIntExact();
        }
        this.fileSize = reader.readNextUnsignedInt();
        this.setVars(reader, superBlock);
    }

    protected void setVars(BinaryReader reader, SquashSuperBlock superBlock) throws IOException {
        if (this.fragmentIndex == -1) {
            this.numberOfBlocks = (int)((this.fileSize + superBlock.getBlockSize() - 1L) / superBlock.getBlockSize());
        } else {
            this.numberOfBlocks = (int)(this.fileSize / superBlock.getBlockSize());
            this.tailEndSize = (int)(this.fileSize % superBlock.getBlockSize());
        }
        this.blockSizes = reader.readNextIntArray(this.numberOfBlocks);
    }

    public long getStartBlockOffset() {
        return this.startBlockOffset;
    }

    public int getFragmentIndex() {
        return this.fragmentIndex;
    }

    public int getBlockOffset() {
        return this.blockOffset;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public int getTailEndSize() {
        return this.tailEndSize;
    }

    public int getNumberOfBlocks() {
        return this.numberOfBlocks;
    }

    public int[] getBlockSizes() {
        return this.blockSizes;
    }

    public long getCompressedFileSize() {
        long compressedSize = 0L;
        for (int blockHeader : this.blockSizes) {
            int size = blockHeader & 0xFEFFFFFF;
            compressedSize += (long)size;
        }
        return compressedSize += (long)this.tailEndSize;
    }
}

