/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import db.util.ErrorHandler;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreEntrySet;
import ghidra.util.database.DBCachedObjectStoreKeySet;
import ghidra.util.database.DBCachedObjectStoreSubMap;
import ghidra.util.database.DBCachedObjectStoreValueCollection;
import ghidra.util.database.DirectedIterator;
import ghidra.util.database.KeySpan;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.commons.collections4.ComparatorUtils;

public class DBCachedObjectStoreMap<T extends DBAnnotatedObject>
implements NavigableMap<Long, T> {
    protected final DBCachedObjectStore<T> store;
    protected final ErrorHandler errHandler;
    protected final ReadWriteLock lock;
    protected final DirectedIterator.Direction direction;
    private final Comparator<? super Long> COMPARATOR;
    private final Comparator<? super Long> REVERSE_COMPARATOR;

    public DBCachedObjectStoreMap(DBCachedObjectStore<T> store, ErrorHandler errHandler, ReadWriteLock lock, DirectedIterator.Direction direction) {
        this.store = store;
        this.errHandler = errHandler;
        this.lock = lock;
        this.direction = direction;
        this.COMPARATOR = store.keyComparator();
        this.REVERSE_COMPARATOR = ComparatorUtils.reversedComparator(this.COMPARATOR);
    }

    @Override
    public int size() {
        return this.store.getRecordCount();
    }

    @Override
    public boolean isEmpty() {
        return this.store.getRecordCount() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.contains(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.store.safe(this.lock.readLock(), () -> this.store.objects.contains(value));
    }

    @Override
    public T get(Object key) {
        if (!(key instanceof Long)) {
            return null;
        }
        return this.store.getObjectAt((Long)key);
    }

    @Override
    public T put(Long key, T value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(Object key) {
        if (!(key instanceof Long)) {
            return null;
        }
        return this.store.deleteKey((Long)key);
    }

    @Override
    public void putAll(Map<? extends Long, ? extends T> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.store.deleteAll();
    }

    @Override
    public Comparator<? super Long> comparator() {
        if (this.direction == DirectedIterator.Direction.FORWARD) {
            return this.COMPARATOR;
        }
        return this.REVERSE_COMPARATOR;
    }

    @Override
    public Map.Entry<Long, T> firstEntry() {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.first(this.direction));
    }

    @Override
    public Long firstKey() {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.first(this.direction));
    }

    @Override
    public Map.Entry<Long, T> lastEntry() {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.last(this.direction));
    }

    @Override
    public Long lastKey() {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.last(this.direction));
    }

    @Override
    public Map.Entry<Long, T> lowerEntry(Long key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.lower(this.direction, key));
    }

    @Override
    public Long lowerKey(Long key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.lower(this.direction, key));
    }

    @Override
    public Map.Entry<Long, T> floorEntry(Long key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.floor(this.direction, key));
    }

    @Override
    public Long floorKey(Long key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.floor(this.direction, key));
    }

    @Override
    public Map.Entry<Long, T> ceilingEntry(Long key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.ceiling(this.direction, key));
    }

    @Override
    public Long ceilingKey(Long key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.ceiling(this.direction, key));
    }

    @Override
    public Map.Entry<Long, T> higherEntry(Long key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.entries.higher(this.direction, key));
    }

    @Override
    public Long higherKey(Long key) {
        return this.store.safe(this.lock.readLock(), () -> this.store.keys.higher(this.direction, key));
    }

    @Override
    public Map.Entry<Long, T> pollFirstEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map.Entry<Long, T> pollLastEntry() {
        throw new UnsupportedOperationException();
    }

    public DBCachedObjectStoreKeySet keySet() {
        return this.navigableKeySet();
    }

    @Override
    public DBCachedObjectStoreValueCollection<T> values() {
        if (this.direction == DirectedIterator.Direction.FORWARD) {
            return this.store.asForwardValueCollection;
        }
        return new DBCachedObjectStoreValueCollection<T>(this.store, this.errHandler, this.lock, this.direction);
    }

    public DBCachedObjectStoreEntrySet<T> entrySet() {
        if (this.direction == DirectedIterator.Direction.FORWARD) {
            return this.store.asForwardEntrySet;
        }
        return new DBCachedObjectStoreEntrySet<T>(this.store, this.errHandler, this.lock, this.direction);
    }

    public DBCachedObjectStoreMap<T> descendingMap() {
        return new DBCachedObjectStoreMap<T>(this.store, this.errHandler, this.lock, DirectedIterator.Direction.reverse(this.direction));
    }

    public DBCachedObjectStoreKeySet navigableKeySet() {
        if (this.direction == DirectedIterator.Direction.FORWARD) {
            return this.store.asForwardKeySet;
        }
        return new DBCachedObjectStoreKeySet(this.store, this.errHandler, this.lock, this.direction);
    }

    public DBCachedObjectStoreKeySet descendingKeySet() {
        return new DBCachedObjectStoreKeySet(this.store, this.errHandler, this.lock, DirectedIterator.Direction.reverse(this.direction));
    }

    public DBCachedObjectStoreSubMap<T> subMap(Long fromKey, boolean fromInclusive, Long toKey, boolean toInclusive) {
        KeySpan span = KeySpan.sub(fromKey, fromInclusive, toKey, toInclusive, this.direction);
        return new DBCachedObjectStoreSubMap<T>(this.store, this.errHandler, this.lock, this.direction, span);
    }

    public DBCachedObjectStoreSubMap<T> headMap(Long toKey, boolean inclusive) {
        KeySpan span = KeySpan.head(toKey, inclusive, this.direction);
        return new DBCachedObjectStoreSubMap<T>(this.store, this.errHandler, this.lock, this.direction, span);
    }

    public DBCachedObjectStoreSubMap<T> tailMap(Long fromKey, boolean inclusive) {
        KeySpan span = KeySpan.tail(fromKey, inclusive, this.direction);
        return new DBCachedObjectStoreSubMap<T>(this.store, this.errHandler, this.lock, this.direction, span);
    }

    public DBCachedObjectStoreSubMap<T> subMap(Long fromKey, Long toKey) {
        return this.subMap(fromKey, true, toKey, false);
    }

    public DBCachedObjectStoreSubMap<T> headMap(Long toKey) {
        return this.headMap(toKey, false);
    }

    public DBCachedObjectStoreSubMap<T> tailMap(Long fromKey) {
        return this.tailMap(fromKey, true);
    }
}

