/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.flatapi;

import ghidra.app.decompiler.DecompInterface;
import ghidra.app.decompiler.DecompileException;
import ghidra.app.decompiler.DecompileResults;
import ghidra.app.decompiler.DecompiledFunction;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.listing.Function;
import ghidra.util.Disposable;

public class FlatDecompilerAPI
implements Disposable {
    protected FlatProgramAPI flatProgramAPI;
    protected DecompInterface decompiler;

    public FlatDecompilerAPI() {
    }

    public FlatDecompilerAPI(FlatProgramAPI flatProgramAPI) {
        this.flatProgramAPI = flatProgramAPI;
    }

    public DecompInterface getDecompiler() {
        return this.decompiler;
    }

    public final String decompile(Function function) throws Exception {
        return this.decompile(function, 0);
    }

    public final String decompile(Function function, int timeoutSecs) throws Exception {
        this.initialize();
        DecompileResults decompRes = this.decompiler.decompileFunction(function, timeoutSecs, this.flatProgramAPI.getMonitor());
        DecompiledFunction res = decompRes.getDecompiledFunction();
        if (res == null) {
            throw new DecompileException("Decompiler", decompRes.getErrorMessage());
        }
        return res.getC();
    }

    public final void initialize() throws Exception {
        if (this.decompiler == null) {
            this.decompiler = new DecompInterface();
            this.decompiler.openProgram(this.flatProgramAPI.getCurrentProgram());
        }
    }

    public void dispose() {
        if (this.decompiler != null) {
            this.decompiler.dispose();
        }
    }
}

