/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.dialog;

import docking.ActionBindingPanel;
import docking.DockingActionInputBindingListener;
import docking.DockingUtils;
import docking.Tool;
import docking.action.DockingActionIf;
import docking.actions.KeyBindingUtils;
import docking.actions.KeyBindings;
import docking.actions.ToolActions;
import docking.widgets.EmptyBorderButton;
import docking.widgets.MultiLineLabel;
import docking.widgets.OptionDialog;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableFilterPanel;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.TableColumnDescriptor;
import generic.theme.Gui;
import ghidra.framework.options.ActionTrigger;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.ServiceProviderStub;
import ghidra.util.Msg;
import ghidra.util.Swing;
import gui.event.MouseBinding;
import help.Help;
import help.HelpService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import resources.Icons;

public class KeyBindingsPanel
extends JPanel {
    private static final String GETTING_STARTED_MESSAGE = "<html><i>Select an action to change a keybinding";
    private static final int ACTION_NAME = 0;
    private static final int KEY_BINDING = 1;
    private static final int PLUGIN_NAME = 2;
    private static final String FONT_ID = "font.keybindings.status";
    private JTextPane statusLabel;
    private GTable actionTable;
    private MultiLineLabel collisionLabel;
    private KeyBindingsTableModel tableModel;
    private ActionBindingListener actionBindingListener = new ActionBindingListener();
    private ActionBindingPanel actionBindingPanel;
    private GTableFilterPanel<DockingActionIf> tableFilterPanel;
    private EmptyBorderButton helpButton;
    private KeyBindings keyBindings;
    private boolean unappliedChanges;
    private PluginTool tool;
    private boolean firingTableDataChanged;
    private PropertyChangeListener propertyChangeListener;
    private JPanel gettingStartedPanel;
    private JPanel activeActionPanel;

    public KeyBindingsPanel(PluginTool tool) {
        this.tool = tool;
        this.keyBindings = new KeyBindings((Tool)tool);
        this.createPanelComponents();
        this.initializeTableWidth();
    }

    public void setOptionsPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListener = listener;
    }

    public void dispose() {
        this.tableFilterPanel.dispose();
        this.propertyChangeListener = null;
    }

    public void apply() {
        this.keyBindings.applyChanges();
        this.changesMade(false);
    }

    public void cancel() {
        this.keyBindings.cancelChanges();
        this.tableModel.fireTableDataChanged();
    }

    public void reload() {
        Swing.runLater(() -> {
            this.actionTable.clearSelection();
            this.restoreDefaultKeyBindings();
        });
    }

    public String getStatusText() {
        return this.statusLabel.getText();
    }

    private void initializeTableWidth() {
        String longestName = this.keyBindings.getLongestActionName();
        Font f = this.actionTable.getFont();
        FontMetrics fm = this.actionTable.getFontMetrics(f);
        int maxWidth = 0;
        for (int i = 0; i < longestName.length(); ++i) {
            char c = longestName.charAt(i);
            maxWidth += fm.charWidth(c);
        }
        TableColumn col = this.actionTable.getColumnModel().getColumn(0);
        col.setPreferredWidth(maxWidth);
        this.tableModel.fireTableDataChanged();
    }

    private void createPanelComponents() {
        this.setLayout(new BorderLayout(10, 10));
        this.gettingStartedPanel = new JPanel();
        this.activeActionPanel = this.createActiveActionPanel();
        this.tableModel = new KeyBindingsTableModel(new ArrayList<DockingActionIf>(this.keyBindings.getUniqueActions()));
        this.actionTable = new GTable((TableModel)((Object)this.tableModel));
        JScrollPane actionsScroller = new JScrollPane((Component)this.actionTable);
        this.actionTable.setPreferredScrollableViewportSize(new Dimension(400, 100));
        this.actionTable.setSelectionMode(0);
        this.actionTable.setHTMLRenderingEnabled(true);
        this.actionTable.getSelectionModel().addListSelectionListener(new TableSelectionListener());
        this.adjustTableColumns();
        JPanel importExportPanel = this.createImportExportPanel();
        this.tableFilterPanel = new GTableFilterPanel((JTable)this.actionTable, (RowObjectTableModel)this.tableModel);
        JPanel filterAndExportsPanel = new JPanel(new BorderLayout());
        filterAndExportsPanel.add((Component)this.tableFilterPanel, "North");
        filterAndExportsPanel.add((Component)importExportPanel, "South");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)actionsScroller, "Center");
        centerPanel.add((Component)filterAndExportsPanel, "South");
        this.add((Component)centerPanel, "Center");
        this.add((Component)this.gettingStartedPanel, "South");
        Dimension preferredSize = this.activeActionPanel.getPreferredSize();
        this.gettingStartedPanel.setPreferredSize(preferredSize);
    }

    private JPanel createActiveActionPanel() {
        JPanel keyPanel = this.createKeyEntryPanel();
        JPanel collisionAreaPanel = this.createCollisionArea();
        JPanel parentPanel = new JPanel(new BorderLayout());
        parentPanel.add((Component)keyPanel, "North");
        parentPanel.add((Component)collisionAreaPanel, "South");
        return parentPanel;
    }

    private JPanel createStatusPanel() {
        this.statusLabel = new JTextPane();
        this.statusLabel.setEnabled(false);
        DockingUtils.setTransparent((JComponent)this.statusLabel);
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 5));
        this.statusLabel.setContentType("text/html");
        this.statusLabel.setText(GETTING_STARTED_MESSAGE);
        this.statusLabel.setPreferredSize(new Dimension(300, 30));
        this.statusLabel.setFont(Gui.getFont((String)FONT_ID));
        this.helpButton = new EmptyBorderButton(Icons.HELP_ICON);
        this.helpButton.setEnabled(false);
        this.helpButton.addActionListener(e -> {
            DockingActionIf action = this.getSelectedAction();
            HelpService hs = Help.getHelpService();
            hs.showHelp((Object)action, false, (Component)this);
        });
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BoxLayout(statusPanel, 2));
        statusPanel.add((Component)this.helpButton);
        statusPanel.add(this.statusLabel);
        statusPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        return statusPanel;
    }

    private JPanel createKeyEntryPanel() {
        this.actionBindingPanel = new ActionBindingPanel((DockingActionInputBindingListener)this.actionBindingListener);
        this.actionBindingPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 20, 0));
        JPanel keyPanel = new JPanel(new BorderLayout());
        keyPanel.add((Component)this.actionBindingPanel, "North");
        return keyPanel;
    }

    private JPanel createCollisionArea() {
        this.collisionLabel = new MultiLineLabel(" ");
        this.collisionLabel.setVerticalAlignment(MultiLineLabel.VerticalAlignment.TOP);
        this.collisionLabel.setName("CollisionLabel");
        JScrollPane collisionScroller = new JScrollPane((Component)this.collisionLabel);
        int height = 100;
        collisionScroller.setPreferredSize(new Dimension(400, height));
        JPanel parentPanel = new JPanel(new BorderLayout());
        parentPanel.add((Component)collisionScroller, "Center");
        parentPanel.add(Box.createVerticalStrut(height), "West");
        JPanel alignmentPanel = new JPanel(new FlowLayout(0));
        alignmentPanel.add(parentPanel);
        return alignmentPanel;
    }

    private JPanel createImportExportPanel() {
        JButton importButton = new JButton("Import...");
        importButton.setToolTipText("Load key binding settings from a file");
        importButton.addActionListener(event -> {
            boolean continueImport = this.showImportPrompt();
            if (!continueImport) {
                return;
            }
            Swing.runLater(() -> {
                this.actionTable.clearSelection();
                this.loadKeyBindingsFromImportedOptions((Options)KeyBindingUtils.importKeyBindings());
            });
        });
        JButton exportButton = new JButton("Export...");
        exportButton.setToolTipText("Save key binding settings to a file");
        exportButton.addActionListener(event -> {
            boolean continueExport = this.showApplyPrompt();
            if (!continueExport) {
                return;
            }
            Swing.runLater(() -> {
                ToolOptions keyBindingOptions = this.tool.getOptions("Key Bindings");
                KeyBindingUtils.exportKeyBindings((ToolOptions)keyBindingOptions);
            });
        });
        JPanel statusPanel = this.createStatusPanel();
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(importButton);
        buttonPanel.add(exportButton);
        JPanel parentPanel = new JPanel(new BorderLayout());
        parentPanel.add((Component)statusPanel, "West");
        parentPanel.add((Component)buttonPanel, "East");
        return parentPanel;
    }

    private boolean showApplyPrompt() {
        boolean continueOperation = true;
        if (this.unappliedChanges) {
            int userChoice = OptionDialog.showYesNoCancelDialog((Component)this, (String)"Apply Changes?", (String)"Apply current key binding changes?");
            if (userChoice == 1) {
                this.apply();
            } else if (userChoice == 0) {
                continueOperation = false;
            }
        }
        return continueOperation;
    }

    private boolean showImportPrompt() {
        int userChoice = OptionDialog.showYesNoDialog((Component)this, (String)"Continue Import?", (String)"Importing key bindings will overwrite the current settings.\nDo you want to continue?");
        return userChoice == 1;
    }

    private Map<String, KeyStroke> createActionNameToKeyStrokeMap(Options keyBindingOptions) {
        HashMap<String, KeyStroke> localActionMap = new HashMap<String, KeyStroke>();
        List optionNames = keyBindingOptions.getOptionNames();
        for (String name : optionNames) {
            ActionTrigger actionTrigger = keyBindingOptions.getActionTrigger(name, null);
            KeyStroke optionsKs = null;
            if (actionTrigger != null) {
                optionsKs = actionTrigger.getKeyStroke();
            }
            localActionMap.put(name, optionsKs);
        }
        return localActionMap;
    }

    private void adjustTableColumns() {
        this.actionTable.doLayout();
        TableColumn column = this.actionTable.getColumn((Object)this.actionTable.getColumnName(0));
        column.setPreferredWidth(250);
        column = this.actionTable.getColumn((Object)this.actionTable.getColumnName(1));
        column.setPreferredWidth(100);
        column = this.actionTable.getColumn((Object)this.actionTable.getColumnName(2));
        column.setPreferredWidth(150);
    }

    private void restoreDefaultKeyBindings() {
        this.keyBindings.restoreOptions();
        this.tableModel.fireTableDataChanged();
    }

    private void changesMade(boolean changes) {
        this.propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "apply.enabled", this.unappliedChanges, changes));
        this.unappliedChanges = changes;
    }

    private DockingActionIf getSelectedAction() {
        if (this.actionTable.getSelectedRowCount() == 0) {
            return null;
        }
        int selectedRow = this.actionTable.getSelectedRow();
        return (DockingActionIf)this.tableFilterPanel.getRowObject(selectedRow);
    }

    private String getSelectedActionName() {
        DockingActionIf action = this.getSelectedAction();
        if (action == null) {
            return null;
        }
        return action.getFullName();
    }

    private void showActionsMappedToKeyStroke(KeyStroke ks) {
        String text = this.keyBindings.getActionsForKeyStrokeText(ks);
        if (StringUtils.isBlank((CharSequence)text)) {
            text = " ";
        }
        this.updateCollisionPanel(text);
    }

    private void clearInfoPanel() {
        this.updateCollisionPanel(" ");
    }

    private void updateCollisionPanel(String text) {
        Container parent = this.collisionLabel.getParent().getParent();
        if (text.isBlank()) {
            parent.setVisible(false);
        } else {
            parent.setVisible(true);
        }
        this.collisionLabel.setLabel(text);
        this.collisionLabel.invalidate();
        this.validate();
        this.repaint();
    }

    private void loadKeyBindingsFromImportedOptions(Options keyBindingOptions) {
        if (keyBindingOptions == null) {
            return;
        }
        Map<String, KeyStroke> keyStrokesByActionName = this.createActionNameToKeyStrokeMap(keyBindingOptions);
        boolean changes = false;
        for (String name : keyStrokesByActionName.keySet()) {
            KeyStroke keyStroke = keyStrokesByActionName.get(name);
            keyStroke = KeyBindingUtils.validateKeyStroke((KeyStroke)keyStroke);
            if (!this.keyBindings.containsAction(name)) continue;
            changes |= this.setActionKeyStroke(name, keyStroke);
        }
        if (changes) {
            this.changesMade(true);
            this.tableModel.fireTableDataChanged();
        }
    }

    private void updateKeyStroke(KeyStroke ks) {
        this.clearInfoPanel();
        DockingActionIf action = this.getSelectedAction();
        if (action == null) {
            this.statusLabel.setText(GETTING_STARTED_MESSAGE);
            return;
        }
        ToolActions toolActions = (ToolActions)this.tool.getToolActions();
        String errorMessage = toolActions.validateActionKeyBinding(action, ks);
        if (errorMessage != null) {
            this.actionBindingPanel.clearKeyStroke();
            this.statusLabel.setText(errorMessage);
            return;
        }
        String selectedActionName = action.getFullName();
        if (this.setActionKeyStroke(selectedActionName, ks)) {
            this.showActionsMappedToKeyStroke(ks);
            this.fireRowChanged();
            this.changesMade(true);
        }
    }

    private void updateMouseBinding(MouseBinding mb) {
        this.clearInfoPanel();
        DockingActionIf action = this.getSelectedAction();
        if (action == null) {
            this.statusLabel.setText(GETTING_STARTED_MESSAGE);
            return;
        }
        String selectedActionName = action.getFullName();
        if (this.setMouseBinding(selectedActionName, mb)) {
            this.fireRowChanged();
            this.changesMade(true);
        }
    }

    private void fireRowChanged() {
        int viewRow = this.actionTable.getSelectedRow();
        int modelRow = this.tableFilterPanel.getModelRow(viewRow);
        this.tableModel.fireTableRowsUpdated(modelRow, modelRow);
    }

    private boolean setMouseBinding(String actionName, MouseBinding mouseBinding) {
        if (this.keyBindings.isMouseBindingInUse(actionName, mouseBinding)) {
            String existingName = this.keyBindings.getActionForMouseBinding(mouseBinding);
            String message = "Mouse binding '%s' already in use by '%s'.\nThe existing binding must be cleared before it can be used again.\n".formatted(mouseBinding, existingName);
            Msg.showInfo((Object)this, (Component)this.actionBindingPanel, (String)"Mouse Binding In Use", (Object)message);
            this.actionBindingPanel.clearMouseBinding();
            return false;
        }
        return this.keyBindings.setActionMouseBinding(actionName, mouseBinding);
    }

    private boolean setActionKeyStroke(String actionName, KeyStroke keyStroke) {
        if (!this.isValidKeyStroke(keyStroke)) {
            this.actionBindingPanel.clearKeyStroke();
            return this.keyBindings.removeKeyStroke(actionName);
        }
        return this.keyBindings.setActionKeyStroke(actionName, keyStroke);
    }

    private boolean isValidKeyStroke(KeyStroke ks) {
        if (ks == null) {
            return false;
        }
        char keyChar = ks.getKeyChar();
        return !Character.isWhitespace(keyChar) && Character.getType(keyChar) != 15;
    }

    Map<String, KeyStroke> getKeyStrokeMap() {
        return this.keyBindings.getKeyStrokesByFullActionName();
    }

    private void swapView(JComponent newView) {
        Component component = this.getComponent(1);
        if (component == newView) {
            return;
        }
        this.remove(component);
        this.add((Component)newView, "South");
        Container parent = this.getParent();
        parent.validate();
        parent.repaint();
    }

    private class ActionBindingListener
    implements DockingActionInputBindingListener {
        private ActionBindingListener() {
        }

        public void keyStrokeChanged(KeyStroke ks) {
            KeyBindingsPanel.this.updateKeyStroke(ks);
        }

        public void mouseBindingChanged(MouseBinding mb) {
            KeyBindingsPanel.this.updateMouseBinding(mb);
        }
    }

    private class KeyBindingsTableModel
    extends GDynamicColumnTableModel<DockingActionIf, Object> {
        private List<DockingActionIf> actions;

        public KeyBindingsTableModel(List<DockingActionIf> actions) {
            super((ServiceProvider)new ServiceProviderStub());
            this.actions = actions;
        }

        protected TableColumnDescriptor<DockingActionIf> createTableColumnDescriptor() {
            TableColumnDescriptor descriptor = new TableColumnDescriptor();
            descriptor.addVisibleColumn("Action Name", String.class, a -> a.getName(), 1, true);
            descriptor.addVisibleColumn("Key Binding", String.class, a -> {
                MouseBinding mb;
                Object text = "";
                String fullName = a.getFullName();
                KeyStroke ks = KeyBindingsPanel.this.keyBindings.getKeyStroke(fullName);
                if (ks != null) {
                    text = (String)text + KeyBindingUtils.parseKeyStroke((KeyStroke)ks);
                }
                if ((mb = KeyBindingsPanel.this.keyBindings.getMouseBinding(fullName)) != null) {
                    text = (String)text + " (" + mb.getDisplayText() + ")";
                }
                return ((String)text).trim();
            });
            descriptor.addVisibleColumn("Owner", String.class, a -> a.getOwnerDescription());
            descriptor.addHiddenColumn("Description", String.class, a -> a.getDescription());
            return descriptor;
        }

        public String getName() {
            return "Key Bindings";
        }

        public List<DockingActionIf> getModelData() {
            return this.actions;
        }

        public Object getDataSource() {
            return null;
        }
    }

    private class TableSelectionListener
    implements ListSelectionListener {
        private TableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting() || KeyBindingsPanel.this.firingTableDataChanged) {
                return;
            }
            KeyBindingsPanel.this.helpButton.setEnabled(false);
            DockingActionIf action = KeyBindingsPanel.this.getSelectedAction();
            if (action == null) {
                KeyBindingsPanel.this.swapView(KeyBindingsPanel.this.gettingStartedPanel);
                KeyBindingsPanel.this.statusLabel.setText(KeyBindingsPanel.GETTING_STARTED_MESSAGE);
                KeyBindingsPanel.this.actionBindingPanel.setEnabled(false);
                KeyBindingsPanel.this.helpButton.setToolTipText("Select action in table for help");
                return;
            }
            String fullActionName = KeyBindingsPanel.this.getSelectedActionName();
            KeyBindingsPanel.this.swapView(KeyBindingsPanel.this.activeActionPanel);
            KeyBindingsPanel.this.actionBindingPanel.setEnabled(true);
            KeyBindingsPanel.this.helpButton.setEnabled(true);
            KeyBindingsPanel.this.clearInfoPanel();
            KeyStroke ks = KeyBindingsPanel.this.keyBindings.getKeyStroke(fullActionName);
            if (ks != null) {
                KeyBindingsPanel.this.showActionsMappedToKeyStroke(ks);
            }
            MouseBinding mb = KeyBindingsPanel.this.keyBindings.getMouseBinding(fullActionName);
            KeyBindingsPanel.this.actionBindingPanel.setKeyBindingData(ks, mb);
            String description = action.getDescription();
            if (StringUtils.isBlank((CharSequence)description)) {
                description = action.getName();
            }
            KeyBindingsPanel.this.statusLabel.setText("<html>" + description);
            KeyBindingsPanel.this.helpButton.setToolTipText("Help for " + action.getName());
        }
    }
}

