/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class CopyTask
extends Task {
    private DomainFolder destFolder;
    private DomainFolder srcFolder;
    private DomainFile srcFile;

    CopyTask(DomainFolder destFolder, DomainFolder srcFolder) {
        super("Copy " + srcFolder.getPathname(), true, false, true);
        if (destFolder == null) {
            throw new IllegalArgumentException("Both destFolder and srcFolder must be specified");
        }
        this.destFolder = destFolder;
        this.srcFolder = srcFolder;
    }

    CopyTask(DomainFolder destFolder, DomainFile srcFile) {
        super("Copy " + srcFile.getPathname(), true, true, true);
        this.destFolder = destFolder;
        this.srcFile = srcFile;
    }

    public void run(TaskMonitor monitor) {
        if (this.srcFolder != null) {
            this.copyFolder(monitor);
        } else {
            this.copyFile(monitor);
        }
    }

    private void copyFolder(TaskMonitor monitor) {
        try {
            if (this.srcFolder.getParent() == null) {
                DomainFile[] files;
                DomainFolder[] folders;
                for (DomainFolder element : folders = this.srcFolder.getFolders()) {
                    element.copyTo(this.destFolder, monitor);
                }
                for (DomainFile element : files = this.srcFolder.getFiles()) {
                    element.copyTo(this.destFolder, monitor);
                }
            } else {
                this.srcFolder.copyTo(this.destFolder, monitor);
            }
        }
        catch (CancelledException folders) {
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            Msg.showError((Object)((Object)this), null, (String)"Folder Copy Failed", (Object)("Could not copy folder " + this.srcFolder.getName() + ".\n" + msg));
        }
    }

    private void copyFile(TaskMonitor monitor) {
        try {
            this.srcFile.copyTo(this.destFolder, monitor);
        }
        catch (CancelledException cancelledException) {
        }
        catch (IOException e) {
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            Msg.showError((Object)((Object)this), null, (String)"File Copy Failed", (Object)("Could not copy file " + this.srcFile.getName() + ".\n" + msg));
        }
    }
}

