/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.classtype;

import ghidra.app.util.SymbolPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.gclass.ClassID;

public class ClassTypeManager {
    private static final String CLASS_TYPE_MANAGER_PROTOTYPE2 = "CLASS_TYPE_MANAGER_PROTOTYPE2";
    private DataTypeManager dtm;
    private PointerDataType defaultPtrType;
    private PointerDataType defaultVbtPtr;
    private PointerDataType defaultVftPtr;

    public ClassTypeManager(DataTypeManager dtm) {
        this.dtm = dtm;
        this.defaultPtrType = new PointerDataType(dtm);
        this.defaultVbtPtr = new PointerDataType((DataType)new IntegerDataType(dtm));
        this.defaultVftPtr = new PointerDataType((DataType)new PointerDataType(dtm));
    }

    public SymbolPath getSymbolPath(ClassID classId) {
        return classId.getSymbolPath();
    }

    public DataTypeManager getDataTypeManager() {
        return this.dtm;
    }

    public PointerDataType getDefaultPointerType() {
        return this.defaultPtrType;
    }

    public PointerDataType getDefaultVbtPtr() {
        return this.defaultVbtPtr;
    }

    public PointerDataType getDefaultVftPtr() {
        return this.defaultVftPtr;
    }

    public int getDefaultVbTableElementSize() {
        return this.dtm.getDataOrganization().getIntegerSize();
    }

    public int getDefaultVfTableElementSize() {
        return this.dtm.getDataOrganization().getPointerSize();
    }
}

