/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.info;

import ghidra.bitpatterns.info.ContextRegisterInfo;
import ghidra.bitpatterns.info.DataGatheringParams;
import ghidra.bitpatterns.info.InstructionSequence;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.util.Msg;
import ghidra.util.xml.XmlUtilities;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;

public class FunctionBitPatternInfo {
    static final String XML_ELEMENT_NAME = "FunctionBitPatternInfo";
    private InstructionSequence firstInst;
    private InstructionSequence preInst;
    private List<InstructionSequence> returnInst;
    private String preBytes = null;
    private String firstBytes = null;
    private List<String> returnBytes;
    private String address = null;
    private List<ContextRegisterInfo> contextRegisters;

    private static String getBytesAsString(byte[] bytes) {
        StringBuilder byteStringBuilder = new StringBuilder();
        for (byte b : bytes) {
            String byteString = Integer.toHexString(b & 0xFF);
            if (byteString.length() == 1) {
                byteStringBuilder.append("0");
            }
            byteStringBuilder.append(byteString);
        }
        return byteStringBuilder.toString();
    }

    public FunctionBitPatternInfo() {
        this.returnBytes = new ArrayList<String>();
        this.returnInst = new ArrayList<InstructionSequence>();
    }

    public FunctionBitPatternInfo(Program program, Function func, DataGatheringParams params) {
        Listing listing = program.getListing();
        if (params.getContextRegisters() != null) {
            this.contextRegisters = this.recordContextRegisterInfo(program, func, params.getContextRegisters());
        }
        this.firstInst = this.getInstructionsFollowFlow(params.getNumFirstInstructions(), program, func.getEntryPoint(), listing);
        Address pre = func.getEntryPoint().subtract(1L);
        this.preInst = this.getInstructionsAgainstFlow(params.getNumPreInstructions(), program, pre, listing, null);
        Address start = func.getEntryPoint();
        String addrString = start.toString();
        int colonIndex = addrString.indexOf(":");
        this.address = colonIndex == -1 ? start.toString() : start.toString().substring(colonIndex + 1);
        Memory mem = program.getMemory();
        int numFirstBytes = 0;
        for (Integer n : this.firstInst.getSizes()) {
            if (n == null) break;
            numFirstBytes += n.intValue();
        }
        numFirstBytes = Math.max(numFirstBytes, params.getNumFirstBytes());
        byte[] firstBytesArray = this.getBytesWithFlow(numFirstBytes = Math.min(numFirstBytes, (int)func.getBody().getNumAddresses()), mem, start);
        if (firstBytesArray != null) {
            this.firstBytes = FunctionBitPatternInfo.getBytesAsString(firstBytesArray);
        }
        Address adjustedAddress = start.add(-1L);
        int numPreBytes = 0;
        for (Integer size : this.preInst.getSizes()) {
            if (size == null) break;
            numPreBytes += size.intValue();
        }
        byte[] byArray = this.getBytesAgainstFlow(numPreBytes = Math.max(numPreBytes, params.getNumPreBytes()), mem, adjustedAddress);
        if (byArray != null) {
            this.preBytes = FunctionBitPatternInfo.getBytesAsString(byArray);
        }
        this.returnBytes = new ArrayList<String>();
        this.returnInst = new ArrayList<InstructionSequence>();
        HashMap<Address, Integer> returnsToSizes = new HashMap<Address, Integer>();
        InstructionIterator instIter = listing.getInstructions(func.getBody(), true);
        while (instIter.hasNext()) {
            Instruction currentInstruction = instIter.next();
            FlowType currentFlowType = currentInstruction.getFlowType();
            if (!currentFlowType.equals((Object)RefType.CALL_TERMINATOR) && !currentFlowType.equals((Object)RefType.TERMINATOR) && !currentFlowType.equals((Object)RefType.CONDITIONAL_CALL_TERMINATOR) && !currentFlowType.equals((Object)RefType.CONDITIONAL_TERMINATOR)) continue;
            returnsToSizes.put(currentInstruction.getAddress(), currentInstruction.getLength());
        }
        for (Address currentAddress : returnsToSizes.keySet()) {
            adjustedAddress = currentAddress.add((long)((Integer)returnsToSizes.get(currentAddress) - 1));
            InstructionSequence returnInstructions = this.getInstructionsAgainstFlow(params.getNumReturnInstructions(), program, currentAddress, listing, func.getBody());
            if (returnInstructions == null) {
                return;
            }
            this.returnInst.add(returnInstructions);
            int numReturnBytes = 0;
            for (Integer size : returnInstructions.getSizes()) {
                if (size == null) break;
                numReturnBytes += size.intValue();
            }
            byte[] returnBytesArray = this.getBytesAgainstFlow(numReturnBytes = Math.max(numReturnBytes, params.getNumReturnBytes()), mem, adjustedAddress);
            if (returnBytesArray == null) continue;
            String returnBytesString = FunctionBitPatternInfo.getBytesAsString(returnBytesArray);
            this.returnBytes.add(returnBytesString);
        }
    }

    private byte[] getBytesAgainstFlow(int numBytes, Memory memory, Address start) {
        MemoryBlock currentBlock = memory.getBlock(start);
        if (currentBlock == null) {
            return null;
        }
        byte[] bytes = new byte[numBytes];
        Address pre = start.subtract((long)(numBytes - 1));
        MemoryBlock preBlock = memory.getBlock(pre);
        if (preBlock == null || currentBlock.compareTo((Object)preBlock) != 0) {
            bytes = null;
        } else {
            try {
                memory.getBytes(pre, bytes);
            }
            catch (MemoryAccessException e) {
                Msg.info((Object)this, (Object)("MemoryAccessException for address" + pre.toString()));
                bytes = null;
            }
        }
        return bytes;
    }

    private byte[] getBytesWithFlow(int numBytes, Memory memory, Address start) {
        byte[] bytes = new byte[numBytes];
        try {
            memory.getBytes(start, bytes);
        }
        catch (MemoryAccessException e) {
            Msg.info((Object)this, (Object)("MemoryAccessException for address" + start.toString()));
        }
        return bytes;
    }

    private InstructionSequence getInstructionsAgainstFlow(int numInstructions, Program program, Address startAddress, Listing listing, AddressSetView validAddresses) {
        InstructionSequence instructions = new InstructionSequence(numInstructions);
        CodeUnit cu = listing.getCodeUnitContaining(startAddress);
        if (cu instanceof Instruction) {
            Instruction preInstruction = (Instruction)cu;
            for (int j = 0; j < numInstructions; ++j) {
                try {
                    Address preInstStart;
                    if (preInstruction == null || validAddresses != null && !validAddresses.contains(preInstStart = preInstruction.getAddress())) break;
                    instructions.getInstructions()[j] = preInstruction.getMnemonicString();
                    instructions.getSizes()[j] = preInstruction.getBytes().length;
                    StringBuilder sb = new StringBuilder();
                    for (int k = 0; k < preInstruction.getNumOperands(); ++k) {
                        sb.append(preInstruction.getDefaultOperandRepresentation(k));
                        if (k == preInstruction.getNumOperands() - 1) continue;
                        sb.append(",");
                    }
                    instructions.getCommaSeparatedOperands()[j] = sb.toString();
                    preInstruction = preInstruction.getPrevious();
                    continue;
                }
                catch (MemoryAccessException e) {
                    break;
                }
            }
        }
        return instructions;
    }

    private InstructionSequence getInstructionsFollowFlow(int numInstructions, Program program, Address startAddress, Listing listing) {
        Instruction currentInst;
        InstructionSequence instructions = new InstructionSequence(numInstructions);
        Function func = program.getFunctionManager().getFunctionAt(startAddress);
        InstructionIterator instIter = listing.getInstructions(func.getBody(), true);
        for (int i = 0; i < numInstructions && (currentInst = instIter.next()) != null; ++i) {
            while (currentInst.getAddress().compareTo((Object)func.getEntryPoint()) < 0) {
                currentInst = instIter.next();
            }
            try {
                instructions.getInstructions()[i] = currentInst.getMnemonicString();
                instructions.getSizes()[i] = currentInst.getBytes().length;
                StringBuilder sb = new StringBuilder();
                for (int j = 0; j < currentInst.getNumOperands(); ++j) {
                    sb.append(currentInst.getDefaultOperandRepresentation(j));
                    if (j == currentInst.getNumOperands() - 1) continue;
                    sb.append(",");
                }
                instructions.getCommaSeparatedOperands()[i] = sb.toString();
                continue;
            }
            catch (MemoryAccessException e) {
                break;
            }
        }
        return instructions;
    }

    private List<ContextRegisterInfo> recordContextRegisterInfo(Program program, Function func, List<String> contextRegs) {
        ArrayList<ContextRegisterInfo> contextRegisterInfo = new ArrayList<ContextRegisterInfo>(contextRegs.size());
        int numContextRegs = contextRegs.size();
        for (int i = 0; i < numContextRegs; ++i) {
            contextRegisterInfo.add(new ContextRegisterInfo(contextRegs.get(i)));
        }
        ProgramContext pContext = program.getProgramContext();
        for (ContextRegisterInfo cRegInfo : contextRegisterInfo) {
            Register reg = program.getRegister(cRegInfo.getContextRegister());
            if (reg == null) {
                Msg.info((Object)this, (Object)("null returned for register :" + cRegInfo.getContextRegister() + " - spelling error?"));
                continue;
            }
            BigInteger value = pContext.getValue(reg, func.getEntryPoint(), false);
            cRegInfo.setValue(value);
        }
        return contextRegisterInfo;
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        if (this.contextRegisters != null) {
            sb.append("Registers: ");
            int size = this.contextRegisters.size();
            for (i = 0; i < size; ++i) {
                sb.append(this.contextRegisters.get(i).getContextRegister());
                sb.append(": ");
                sb.append(this.contextRegisters.get(i).getValue());
                sb.append(" ");
            }
            sb.append("\n");
        }
        sb.append("Prebytes: ");
        sb.append(this.preBytes);
        sb.append("\n");
        if (this.preInst != null) {
            sb.append("preInstructions: ");
            sb.append(this.preInst.toString());
        }
        sb.append("\nAddress: ");
        sb.append(this.address.toString());
        sb.append("\nfirstInstructions: ");
        sb.append(this.firstInst.toString());
        sb.append("\nfirstBytes: ");
        sb.append(this.firstBytes);
        sb.append("\nreturns:");
        int numReturns = this.returnBytes.size();
        for (i = 0; i < numReturns; ++i) {
            sb.append("\n  bytes:\n   ");
            sb.append(this.returnBytes.get(i));
            sb.append("\n  inst:\n   ");
            sb.append(this.returnInst.get(i));
        }
        return sb.toString();
    }

    public InstructionSequence getFirstInst() {
        return this.firstInst;
    }

    public void setFirstInst(InstructionSequence firstInst) {
        this.firstInst = firstInst;
    }

    public InstructionSequence getPreInst() {
        return this.preInst;
    }

    public void setPreInst(InstructionSequence preInst) {
        this.preInst = preInst;
    }

    public List<InstructionSequence> getReturnInst() {
        return this.returnInst;
    }

    public void setReturnInst(List<InstructionSequence> returnInst) {
        this.returnInst = returnInst;
    }

    public String getPreBytes() {
        return this.preBytes;
    }

    public void setPreBytes(String preBytes) {
        this.preBytes = preBytes;
    }

    public String getFirstBytes() {
        return this.firstBytes;
    }

    public void setFirstBytes(String firstBytes) {
        this.firstBytes = firstBytes;
    }

    public List<String> getReturnBytes() {
        return this.returnBytes;
    }

    public void setReturnBytes(List<String> returnBytes) {
        this.returnBytes = returnBytes;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public List<ContextRegisterInfo> getContextRegisters() {
        return this.contextRegisters;
    }

    public void setContextRegisters(List<ContextRegisterInfo> contextRegisters) {
        this.contextRegisters = contextRegisters;
    }

    public static FunctionBitPatternInfo fromXml(Element e) {
        String preBytes = e.getAttributeValue("preBytes");
        String firstBytes = e.getAttributeValue("firstBytes");
        String address = e.getAttributeValue("address");
        ArrayList<String> returnBytes = new ArrayList<String>();
        Element returnBytesListEle = e.getChild("returnBytesList");
        if (returnBytesListEle != null) {
            for (Element rbEle : XmlUtilities.getChildren((Element)returnBytesListEle, (String)"returnBytes")) {
                returnBytes.add(rbEle.getAttributeValue("value"));
            }
        }
        InstructionSequence firstInst = InstructionSequence.fromXml(e.getChild("firstInst"));
        InstructionSequence preInst = InstructionSequence.fromXml(e.getChild("preInst"));
        ArrayList<InstructionSequence> returnInst = new ArrayList<InstructionSequence>();
        Element returnInstListEle = e.getChild("returnInstList");
        if (returnInstListEle != null) {
            for (Element isEle : XmlUtilities.getChildren((Element)returnInstListEle, (String)"InstructionSequence")) {
                returnInst.add(InstructionSequence.fromXml(isEle));
            }
        }
        ArrayList<ContextRegisterInfo> contextRegisters = new ArrayList<ContextRegisterInfo>();
        Element contextRegistersListEle = e.getChild("contextRegistersList");
        if (contextRegistersListEle != null) {
            for (Element criElement : XmlUtilities.getChildren((Element)contextRegistersListEle, (String)"ContextRegisterInfo")) {
                contextRegisters.add(ContextRegisterInfo.fromXml(criElement));
            }
        }
        FunctionBitPatternInfo result = new FunctionBitPatternInfo();
        result.setPreBytes(preBytes);
        result.setFirstBytes(firstBytes);
        result.setAddress(address);
        result.setReturnBytes(returnBytes);
        result.setFirstInst(firstInst);
        result.setPreInst(preInst);
        result.setReturnInst(returnInst);
        result.setContextRegisters(contextRegisters);
        return result;
    }

    public Element toXml() {
        Element result = new Element(XML_ELEMENT_NAME);
        XmlUtilities.setStringAttr((Element)result, (String)"preBytes", (String)this.preBytes);
        XmlUtilities.setStringAttr((Element)result, (String)"firstBytes", (String)this.firstBytes);
        XmlUtilities.setStringAttr((Element)result, (String)"address", (String)this.address);
        Element returnBytesListEle = new Element("returnBytesList");
        result.addContent((Content)returnBytesListEle);
        for (String s : this.returnBytes) {
            Element rbNode = new Element("returnBytes");
            XmlUtilities.setStringAttr((Element)rbNode, (String)"value", (String)s);
            returnBytesListEle.addContent((Content)rbNode);
        }
        if (this.firstInst != null) {
            result.addContent((Content)this.firstInst.toXml("firstInst"));
        }
        if (this.preInst != null) {
            result.addContent((Content)this.preInst.toXml("preInst"));
        }
        if (this.returnInst != null) {
            Element returnInstListEle = new Element("returnInstList");
            result.addContent((Content)returnInstListEle);
            for (InstructionSequence is : this.returnInst) {
                returnInstListEle.addContent((Content)is.toXml());
            }
        }
        if (this.contextRegisters != null) {
            Element contextRegistersListEle = new Element("contextRegistersList");
            result.addContent((Content)contextRegistersListEle);
            for (ContextRegisterInfo cri : this.contextRegisters) {
                contextRegistersListEle.addContent((Content)cri.toXml());
            }
        }
        return result;
    }
}

