/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import ghidra.framework.options.XmlProperties;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jdom.Content;
import org.jdom.Element;

public class SaveState
extends XmlProperties {
    private static final String SAVE_STATE = "SAVE_STATE";

    public SaveState(String name) {
        super(name);
    }

    public SaveState() {
        this(SAVE_STATE);
    }

    public SaveState(File file) throws IOException {
        super(file);
    }

    public SaveState(Element element) {
        super(element);
    }

    public void saveToFile(File file) throws IOException {
        this.saveToXmlFile(file);
    }

    public void putSaveState(String name, SaveState value) {
        this.map.put(name, value);
    }

    public SaveState getSaveState(String name) {
        return this.getAsType(name, null, SaveState.class);
    }

    @Override
    protected void processElement(Element element) {
        String tag = element.getName();
        if (!tag.equals(SAVE_STATE)) {
            super.processElement(element);
            return;
        }
        SaveState saveState = this.createSaveState();
        List children = element.getChildren();
        if (children.isEmpty()) {
            return;
        }
        Element child = (Element)element.getChildren().get(0);
        String childTag = child.getName();
        if (childTag.equals(SAVE_STATE)) {
            children = child.getChildren();
        }
        for (Element e : children) {
            saveState.processElement(e);
        }
        String parentName = element.getAttributeValue("NAME");
        this.map.put(parentName, saveState);
    }

    @Override
    protected Element createElement(String key, Object value) {
        if (!(value instanceof SaveState)) {
            return super.createElement(key, value);
        }
        SaveState saveState = (SaveState)value;
        Element savedElement = saveState.saveToXml();
        Element element = new Element(SAVE_STATE);
        element.setAttribute("NAME", key);
        element.setAttribute("TYPE", "SaveState");
        List children = savedElement.getChildren();
        for (Element e : children) {
            Element newElement = (Element)e.clone();
            element.addContent((Content)newElement);
        }
        return element;
    }

    protected SaveState createSaveState() {
        return new SaveState();
    }
}

