/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import ghidra.framework.options.SaveState;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Element;

public class AttributedSaveState
extends SaveState {
    private Map<String, Map<String, String>> propertyAttributes;

    public AttributedSaveState() {
    }

    public AttributedSaveState(String name) {
        super(name);
    }

    public AttributedSaveState(Element root) {
        super(root);
    }

    public void addAttributes(String propertyName, Map<String, String> attributes) {
        this.getPropertyAttributes().put(propertyName, attributes);
    }

    public void removeAttributes(String propertyName) {
        this.getPropertyAttributes().remove(propertyName);
    }

    public Map<String, String> getAttributes(String propertyName) {
        return this.getPropertyAttributes().get(propertyName);
    }

    private Map<String, Map<String, String>> getPropertyAttributes() {
        if (this.propertyAttributes == null) {
            this.propertyAttributes = new HashMap<String, Map<String, String>>();
        }
        return this.propertyAttributes;
    }

    @Override
    protected SaveState createSaveState() {
        return new AttributedSaveState();
    }

    @Override
    protected void initializeElement(Element e) {
        String name = e.getAttributeValue("NAME");
        if (name == null) {
            return;
        }
        Map<String, String> attrs = this.getPropertyAttributes().get(name);
        if (attrs != null) {
            Set<Map.Entry<String, String>> entries = attrs.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                String key = entry.getKey();
                String value = entry.getValue();
                e.setAttribute(key, value);
            }
        }
    }

    @Override
    protected void processElement(Element element) {
        super.processElement(element);
        String name = element.getAttributeValue("NAME");
        if (name == null) {
            return;
        }
        HashMap<String, String> newAttrs = new HashMap<String, String>();
        List attrs = element.getAttributes();
        for (Attribute attr : attrs) {
            String attrValue;
            String attrName;
            if ((attrValue = (switch (attrName = attr.getName()) {
                case "NAME", "TYPE", "VALUE" -> null;
                default -> attr.getValue();
            })) == null) continue;
            newAttrs.put(attrName, attrValue);
        }
        if (!newAttrs.isEmpty()) {
            this.getPropertyAttributes().put(name, newAttrs);
        }
    }
}

