/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.squashfs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderInputStream;
import ghidra.app.util.bin.ByteProviderWrapper;
import ghidra.file.formats.squashfs.SquashConstants;
import ghidra.file.formats.squashfs.SquashMetablock;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import org.apache.commons.compress.compressors.lz4.BlockLZ4CompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.tukaani.xz.LZMAInputStream;

public class SquashUtils {
    public static boolean isSquashFS(byte[] bytes) {
        return bytes.length >= SquashConstants.MAGIC.length && Arrays.equals(SquashConstants.MAGIC, 0, SquashConstants.MAGIC.length, bytes, 0, SquashConstants.MAGIC.length);
    }

    public static byte[] decompressBlock(BinaryReader reader, int compressionType, TaskMonitor monitor) throws IOException, CancelledException {
        SquashMetablock header = new SquashMetablock(reader);
        if (header.isCompressed()) {
            return SquashUtils.decompressBytes(reader, header.getBlockSize(), compressionType, monitor);
        }
        return reader.readNextByteArray((int)header.getBlockSize());
    }

    public static BinaryReader byteArrayToReader(byte[] bytes) {
        ByteArrayProvider newProvider = new ByteArrayProvider(bytes);
        return new BinaryReader((ByteProvider)newProvider, true);
    }

    public static byte[] decompressBytes(BinaryReader reader, int length, int compressionType, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.checkCancelled();
        try (InputStream is = SquashUtils.getSubInputStream(reader, length);){
            byte[] byArray;
            block9: {
                InputStream decompressedInputStream = SquashUtils.getDecompressionStream(is, compressionType);
                try {
                    byArray = decompressedInputStream.readAllBytes();
                    if (decompressedInputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    if (decompressedInputStream != null) {
                        try {
                            decompressedInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                decompressedInputStream.close();
            }
            return byArray;
        }
    }

    public static InputStream getSubInputStream(BinaryReader reader, long length) {
        long start = reader.getPointerIndex();
        reader.setPointerIndex(start + length);
        ByteProvider bp = reader.getByteProvider();
        ByteProviderWrapper subBP = new ByteProviderWrapper(bp, start, length);
        return new ByteProviderInputStream.ClosingInputStream((ByteProvider)subBP);
    }

    public static InputStream getDecompressionStream(InputStream is, int compressionType) throws IOException {
        switch (compressionType) {
            case 1: {
                return new DeflateCompressorInputStream(is);
            }
            case 2: {
                LZMAInputStream lzmaIn = new LZMAInputStream(is);
                lzmaIn.enableRelaxedEndCondition();
                return lzmaIn;
            }
            case 3: {
                throw new IOException("LZO compression is not supported");
            }
            case 4: {
                return new XZCompressorInputStream(is);
            }
            case 5: {
                return new BlockLZ4CompressorInputStream(is);
            }
            case 6: {
                throw new IOException("ZSTD compression is not supported");
            }
        }
        throw new IOException("Supplied compression type (code: " + compressionType + ") was not recognized. ");
    }
}

