/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.tgt;

import ghidra.pcode.emu.jit.JitPassage;
import ghidra.pcode.emu.jit.JitPcodeThread;
import ghidra.pcode.emu.jit.gen.tgt.JitCompiledPassageClass;
import ghidra.pcode.exec.DecodePcodeExecutionException;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.util.DefaultLanguageService;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public interface JitCompiledPassage {
    public static final long MASK_I2UL = 0xFFFFFFFFL;

    public EntryPoint run(int var1);

    public static int readInt1(byte[] arr, int offset) {
        return Byte.toUnsignedInt(arr[offset]);
    }

    public static int readIntBE2(byte[] arr, int offset) {
        return Byte.toUnsignedInt(arr[offset]) << 8 | Byte.toUnsignedInt(arr[offset + 1]);
    }

    public static int readIntBE3(byte[] arr, int offset) {
        return Byte.toUnsignedInt(arr[offset]) << 16 | Byte.toUnsignedInt(arr[offset + 1]) << 8 | Byte.toUnsignedInt(arr[offset + 2]);
    }

    public static int readIntBE4(byte[] arr, int offset) {
        return Byte.toUnsignedInt(arr[offset]) << 24 | Byte.toUnsignedInt(arr[offset + 1]) << 16 | Byte.toUnsignedInt(arr[offset + 2]) << 8 | Byte.toUnsignedInt(arr[offset + 3]);
    }

    public static int readIntLE2(byte[] arr, int offset) {
        return Byte.toUnsignedInt(arr[offset]) | Byte.toUnsignedInt(arr[offset + 1]) << 8;
    }

    public static int readIntLE3(byte[] arr, int offset) {
        return Byte.toUnsignedInt(arr[offset]) | Byte.toUnsignedInt(arr[offset + 1]) << 8 | Byte.toUnsignedInt(arr[offset + 2]) << 16;
    }

    public static int readIntLE4(byte[] arr, int offset) {
        return Byte.toUnsignedInt(arr[offset]) | Byte.toUnsignedInt(arr[offset + 1]) << 8 | Byte.toUnsignedInt(arr[offset + 2]) << 16 | Byte.toUnsignedInt(arr[offset + 3]) << 24;
    }

    public static void writeInt1(int value, byte[] arr, int offset) {
        arr[offset] = (byte)value;
    }

    public static void writeIntBE2(int value, byte[] arr, int offset) {
        arr[offset] = (byte)(value >> 8);
        arr[offset + 1] = (byte)value;
    }

    public static void writeIntBE3(int value, byte[] arr, int offset) {
        arr[offset] = (byte)(value >> 16);
        arr[offset + 1] = (byte)(value >> 8);
        arr[offset + 2] = (byte)value;
    }

    public static void writeIntBE4(int value, byte[] arr, int offset) {
        arr[offset] = (byte)(value >> 24);
        arr[offset + 1] = (byte)(value >> 16);
        arr[offset + 2] = (byte)(value >> 8);
        arr[offset + 3] = (byte)value;
    }

    public static void writeIntLE2(int value, byte[] arr, int offset) {
        arr[offset] = (byte)value;
        arr[offset + 1] = (byte)(value >> 8);
    }

    public static void writeIntLE3(int value, byte[] arr, int offset) {
        arr[offset] = (byte)value;
        arr[offset + 1] = (byte)(value >> 8);
        arr[offset + 2] = (byte)(value >> 16);
    }

    public static void writeIntLE4(int value, byte[] arr, int offset) {
        arr[offset] = (byte)value;
        arr[offset + 1] = (byte)(value >> 8);
        arr[offset + 2] = (byte)(value >> 16);
        arr[offset + 3] = (byte)(value >> 24);
    }

    public static long readLong1(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]);
    }

    public static long readLongBE2(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) << 8 | Byte.toUnsignedLong(arr[offset + 1]);
    }

    public static long readLongBE3(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) << 16 | Byte.toUnsignedLong(arr[offset + 1]) << 8 | Byte.toUnsignedLong(arr[offset + 2]);
    }

    public static long readLongBE4(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) << 24 | Byte.toUnsignedLong(arr[offset + 1]) << 16 | Byte.toUnsignedLong(arr[offset + 2]) << 8 | Byte.toUnsignedLong(arr[offset + 3]);
    }

    public static long readLongBE5(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) << 32 | Byte.toUnsignedLong(arr[offset + 1]) << 24 | Byte.toUnsignedLong(arr[offset + 2]) << 16 | Byte.toUnsignedLong(arr[offset + 3]) << 8 | Byte.toUnsignedLong(arr[offset + 4]);
    }

    public static long readLongBE6(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) << 40 | Byte.toUnsignedLong(arr[offset + 1]) << 32 | Byte.toUnsignedLong(arr[offset + 2]) << 24 | Byte.toUnsignedLong(arr[offset + 3]) << 16 | Byte.toUnsignedLong(arr[offset + 4]) << 8 | Byte.toUnsignedLong(arr[offset + 5]);
    }

    public static long readLongBE7(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) << 48 | Byte.toUnsignedLong(arr[offset + 1]) << 40 | Byte.toUnsignedLong(arr[offset + 2]) << 32 | Byte.toUnsignedLong(arr[offset + 3]) << 24 | Byte.toUnsignedLong(arr[offset + 4]) << 16 | Byte.toUnsignedLong(arr[offset + 5]) << 8 | Byte.toUnsignedLong(arr[offset + 6]);
    }

    public static long readLongBE8(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) << 56 | Byte.toUnsignedLong(arr[offset + 1]) << 48 | Byte.toUnsignedLong(arr[offset + 2]) << 40 | Byte.toUnsignedLong(arr[offset + 3]) << 32 | Byte.toUnsignedLong(arr[offset + 4]) << 24 | Byte.toUnsignedLong(arr[offset + 5]) << 16 | Byte.toUnsignedLong(arr[offset + 6]) << 8 | Byte.toUnsignedLong(arr[offset + 7]);
    }

    public static long readLongLE2(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) | Byte.toUnsignedLong(arr[offset + 1]) << 8;
    }

    public static long readLongLE3(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) | Byte.toUnsignedLong(arr[offset + 1]) << 8 | Byte.toUnsignedLong(arr[offset + 2]) << 16;
    }

    public static long readLongLE4(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) | Byte.toUnsignedLong(arr[offset + 1]) << 8 | Byte.toUnsignedLong(arr[offset + 2]) << 16 | Byte.toUnsignedLong(arr[offset + 3]) << 24;
    }

    public static long readLongLE5(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) | Byte.toUnsignedLong(arr[offset + 1]) << 8 | Byte.toUnsignedLong(arr[offset + 2]) << 16 | Byte.toUnsignedLong(arr[offset + 3]) << 24 | Byte.toUnsignedLong(arr[offset + 4]) << 32;
    }

    public static long readLongLE6(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) | Byte.toUnsignedLong(arr[offset + 1]) << 8 | Byte.toUnsignedLong(arr[offset + 2]) << 16 | Byte.toUnsignedLong(arr[offset + 3]) << 24 | Byte.toUnsignedLong(arr[offset + 4]) << 32 | Byte.toUnsignedLong(arr[offset + 5]) << 40;
    }

    public static long readLongLE7(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) | Byte.toUnsignedLong(arr[offset + 1]) << 8 | Byte.toUnsignedLong(arr[offset + 2]) << 16 | Byte.toUnsignedLong(arr[offset + 3]) << 24 | Byte.toUnsignedLong(arr[offset + 4]) << 32 | Byte.toUnsignedLong(arr[offset + 5]) << 40 | Byte.toUnsignedLong(arr[offset + 6]) << 48;
    }

    public static long readLongLE8(byte[] arr, int offset) {
        return Byte.toUnsignedLong(arr[offset]) | Byte.toUnsignedLong(arr[offset + 1]) << 8 | Byte.toUnsignedLong(arr[offset + 2]) << 16 | Byte.toUnsignedLong(arr[offset + 3]) << 24 | Byte.toUnsignedLong(arr[offset + 4]) << 32 | Byte.toUnsignedLong(arr[offset + 5]) << 40 | Byte.toUnsignedLong(arr[offset + 6]) << 48 | Byte.toUnsignedLong(arr[offset + 7]) << 56;
    }

    public static void writeLong1(long value, byte[] arr, int offset) {
        arr[offset] = (byte)value;
    }

    public static void writeLongBE2(long value, byte[] arr, int offset) {
        arr[offset] = (byte)(value >> 8);
        arr[offset + 1] = (byte)value;
    }

    public static void writeLongBE3(long value, byte[] arr, int offset) {
        arr[offset] = (byte)(value >> 16);
        arr[offset + 1] = (byte)(value >> 8);
        arr[offset + 2] = (byte)value;
    }

    public static void writeLongBE4(long value, byte[] arr, int offset) {
        arr[offset] = (byte)(value >> 24);
        arr[offset + 1] = (byte)(value >> 16);
        arr[offset + 2] = (byte)(value >> 8);
        arr[offset + 3] = (byte)value;
    }

    public static void writeLongBE5(long value, byte[] arr, int offset) {
        arr[offset] = (byte)(value >> 32);
        arr[offset + 1] = (byte)(value >> 24);
        arr[offset + 2] = (byte)(value >> 16);
        arr[offset + 3] = (byte)(value >> 8);
        arr[offset + 4] = (byte)value;
    }

    public static void writeLongBE6(long value, byte[] arr, int offset) {
        arr[offset] = (byte)(value >> 40);
        arr[offset + 1] = (byte)(value >> 32);
        arr[offset + 2] = (byte)(value >> 24);
        arr[offset + 3] = (byte)(value >> 16);
        arr[offset + 4] = (byte)(value >> 8);
        arr[offset + 5] = (byte)value;
    }

    public static void writeLongBE7(long value, byte[] arr, int offset) {
        arr[offset] = (byte)(value >> 48);
        arr[offset + 1] = (byte)(value >> 40);
        arr[offset + 2] = (byte)(value >> 32);
        arr[offset + 3] = (byte)(value >> 24);
        arr[offset + 4] = (byte)(value >> 16);
        arr[offset + 5] = (byte)(value >> 8);
        arr[offset + 6] = (byte)value;
    }

    public static void writeLongBE8(long value, byte[] arr, int offset) {
        arr[offset] = (byte)(value >> 56);
        arr[offset + 1] = (byte)(value >> 48);
        arr[offset + 2] = (byte)(value >> 40);
        arr[offset + 3] = (byte)(value >> 32);
        arr[offset + 4] = (byte)(value >> 24);
        arr[offset + 5] = (byte)(value >> 16);
        arr[offset + 6] = (byte)(value >> 8);
        arr[offset + 7] = (byte)value;
    }

    public static void writeLongLE2(long value, byte[] arr, int offset) {
        arr[offset] = (byte)value;
        arr[offset + 1] = (byte)(value >> 8);
    }

    public static void writeLongLE3(long value, byte[] arr, int offset) {
        arr[offset] = (byte)value;
        arr[offset + 1] = (byte)(value >> 8);
        arr[offset + 2] = (byte)(value >> 16);
    }

    public static void writeLongLE4(long value, byte[] arr, int offset) {
        arr[offset] = (byte)value;
        arr[offset + 1] = (byte)(value >> 8);
        arr[offset + 2] = (byte)(value >> 16);
        arr[offset + 3] = (byte)(value >> 24);
    }

    public static void writeLongLE5(long value, byte[] arr, int offset) {
        arr[offset] = (byte)value;
        arr[offset + 1] = (byte)(value >> 8);
        arr[offset + 2] = (byte)(value >> 16);
        arr[offset + 3] = (byte)(value >> 24);
        arr[offset + 4] = (byte)(value >> 32);
    }

    public static void writeLongLE6(long value, byte[] arr, int offset) {
        arr[offset] = (byte)value;
        arr[offset + 1] = (byte)(value >> 8);
        arr[offset + 2] = (byte)(value >> 16);
        arr[offset + 3] = (byte)(value >> 24);
        arr[offset + 4] = (byte)(value >> 32);
        arr[offset + 5] = (byte)(value >> 40);
    }

    public static void writeLongLE7(long value, byte[] arr, int offset) {
        arr[offset] = (byte)value;
        arr[offset + 1] = (byte)(value >> 8);
        arr[offset + 2] = (byte)(value >> 16);
        arr[offset + 3] = (byte)(value >> 24);
        arr[offset + 4] = (byte)(value >> 32);
        arr[offset + 5] = (byte)(value >> 40);
        arr[offset + 6] = (byte)(value >> 48);
    }

    public static void writeLongLE8(long value, byte[] arr, int offset) {
        arr[offset] = (byte)value;
        arr[offset + 1] = (byte)(value >> 8);
        arr[offset + 2] = (byte)(value >> 16);
        arr[offset + 3] = (byte)(value >> 24);
        arr[offset + 4] = (byte)(value >> 32);
        arr[offset + 5] = (byte)(value >> 40);
        arr[offset + 6] = (byte)(value >> 48);
        arr[offset + 7] = (byte)(value >> 56);
    }

    public static long conv2IntToLong(int msl, int lsl) {
        return Integer.toUnsignedLong(msl) << 32 | Integer.toUnsignedLong(lsl);
    }

    public static int sBorrowIntRaw(int a, int b) {
        int r = a - b;
        a ^= r;
        r ^= b;
        return a &= (r ^= 0xFFFFFFFF);
    }

    public static long sBorrowLongRaw(long a, long b) {
        long r = a - b;
        a ^= r;
        r ^= b;
        return a &= (r ^= 0xFFFFFFFFFFFFFFFFL);
    }

    public static int sBorrowMpInt(int[] a, int[] b, int shift) {
        if (!1.$assertionsDisabled && a.length != b.length) {
            throw new AssertionError();
        }
        long carry = 0L;
        for (int i = 0; i < a.length; ++i) {
            carry >>= 32;
            carry += ((long)a[i] & 0xFFFFFFFFL) - ((long)b[i] & 0xFFFFFFFFL);
        }
        int msr = (int)carry;
        int msa = a[a.length - 1];
        int msb = b[b.length - 1];
        msa ^= msr;
        msr ^= msb;
        return (msa &= (msr ^= 0xFFFFFFFF)) >> shift & 1;
    }

    public static int sCarryIntRaw(int a, int b) {
        int r = a + b;
        r ^= a;
        a ^= b;
        return r &= (a ^= 0xFFFFFFFF);
    }

    public static long sCarryLongRaw(long a, long b) {
        long r = a + b;
        r ^= a;
        a ^= b;
        return r &= (a ^= 0xFFFFFFFFFFFFFFFFL);
    }

    public static int sCarryMpInt(int[] a, int[] b, int shift) {
        if (!1.$assertionsDisabled && a.length != b.length) {
            throw new AssertionError();
        }
        long carry = 0L;
        for (int i = 0; i < a.length; ++i) {
            carry >>>= 32;
            carry += ((long)a[i] & 0xFFFFFFFFL) + ((long)b[i] & 0xFFFFFFFFL);
        }
        int msr = (int)carry;
        int msa = a[a.length - 1];
        int msb = b[b.length - 1];
        msr ^= msa;
        msa ^= msb;
        return (msr &= (msa ^= 0xFFFFFFFF)) >> shift & 1;
    }

    public static void intLeft(int[] out, int outBytes, int[] val, int[] amt) {
        if (Integer.compareUnsigned(amt[0], outBytes * 8) >= 0) {
            Arrays.fill(out, 0);
            return;
        }
        for (int i = 1; i < amt.length; ++i) {
            if (amt[i] == 0) continue;
            Arrays.fill(out, 0);
            return;
        }
        MpShiftPrivate.shl(out, val, amt[0]);
    }

    public static void intLeft(int[] out, int outBytes, int[] val, long amt) {
        if (Long.compareUnsigned(amt, ((long)outBytes & 0xFFFFFFFFL) * 8L) >= 0) {
            Arrays.fill(out, 0);
            return;
        }
        MpShiftPrivate.shl(out, val, (int)amt);
    }

    public static void intLeft(int[] out, int outBytes, int[] val, int amt) {
        if (Integer.compareUnsigned(amt, outBytes * 8) >= 0) {
            Arrays.fill(out, 0);
            return;
        }
        MpShiftPrivate.shl(out, val, amt);
    }

    public static long intLeft(long val, int[] amt) {
        if (Long.compareUnsigned(Integer.toUnsignedLong(amt[0]), 64L) >= 0) {
            return 0L;
        }
        for (int i = 1; i < amt.length; ++i) {
            if (amt[i] == 0) continue;
            return 0L;
        }
        return val << amt[0];
    }

    public static long intLeft(long val, long amt) {
        if (Long.compareUnsigned(amt, 64L) >= 0) {
            return 0L;
        }
        return val << (int)amt;
    }

    public static long intLeft(long val, int amt) {
        if (Integer.compareUnsigned(amt, 64) >= 0) {
            return 0L;
        }
        return val << amt;
    }

    public static long intLeft(int val, int[] amt) {
        if (Integer.compareUnsigned(amt[0], 32) >= 0) {
            return 0L;
        }
        for (int i = 1; i < amt.length; ++i) {
            if (amt[i] == 0) continue;
            return 0L;
        }
        return val << amt[0];
    }

    public static int intLeft(int val, long amt) {
        if (Long.compareUnsigned(amt, 32L) >= 0) {
            return 0;
        }
        return val << (int)amt;
    }

    public static int intLeft(int val, int amt) {
        if (Long.compareUnsigned(amt, 32L) >= 0) {
            return 0;
        }
        return val << amt;
    }

    public static void intRight(int[] out, int outBytes, int[] val, int[] amt) {
        if (Integer.compareUnsigned(amt[0], outBytes * 8) >= 0) {
            Arrays.fill(out, 0);
            return;
        }
        for (int i = 1; i < amt.length; ++i) {
            if (amt[i] == 0) continue;
            Arrays.fill(out, 0);
            return;
        }
        MpShiftPrivate.ushr(out, val, amt[0]);
    }

    public static void intRight(int[] out, int outBytes, int[] val, long amt) {
        if (Long.compareUnsigned(amt, ((long)outBytes & 0xFFFFFFFFL) * 8L) >= 0) {
            Arrays.fill(out, 0);
            return;
        }
        MpShiftPrivate.ushr(out, val, (int)amt);
    }

    public static void intRight(int[] out, int outBytes, int[] val, int amt) {
        if (Integer.compareUnsigned(amt, outBytes * 8) >= 0) {
            Arrays.fill(out, 0);
            return;
        }
        MpShiftPrivate.ushr(out, val, amt);
    }

    public static long intRight(long val, int[] amt) {
        if (Long.compareUnsigned(Integer.toUnsignedLong(amt[0]), 64L) >= 0) {
            return 0L;
        }
        for (int i = 1; i < amt.length; ++i) {
            if (amt[i] == 0) continue;
            return 0L;
        }
        return val >>> amt[0];
    }

    public static long intRight(long val, long amt) {
        if (Long.compareUnsigned(amt, 64L) >= 0) {
            return 0L;
        }
        return val >>> (int)amt;
    }

    public static long intRight(long val, int amt) {
        if (Integer.compareUnsigned(amt, 64) >= 0) {
            return 0L;
        }
        return val >>> amt;
    }

    public static long intRight(int val, int[] amt) {
        if (Integer.compareUnsigned(amt[0], 32) >= 0) {
            return 0L;
        }
        for (int i = 1; i < amt.length; ++i) {
            if (amt[i] == 0) continue;
            return 0L;
        }
        return val >>> amt[0];
    }

    public static int intRight(int val, long amt) {
        if (Long.compareUnsigned(amt, 32L) >= 0) {
            return 0;
        }
        return val >>> (int)amt;
    }

    public static int intRight(int val, int amt) {
        if (Long.compareUnsigned(amt, 32L) >= 0) {
            return 0;
        }
        return val >>> amt;
    }

    public static void intSRight(int[] out, int outBytes, int[] val, int[] amt) {
        int sign;
        int n = sign = val[val.length - 1] < 0 ? -1 : 0;
        if (Integer.compareUnsigned(amt[0], outBytes * 8) >= 0) {
            Arrays.fill(out, sign);
            return;
        }
        for (int i = 1; i < amt.length; ++i) {
            if (amt[i] == 0) continue;
            Arrays.fill(out, sign);
            return;
        }
        MpShiftPrivate.sshr(out, val, amt[0], sign);
    }

    public static long intSRight(long val, long amt) {
        if (Long.compareUnsigned(amt, 64L) >= 0) {
            return val >> 63;
        }
        return val >> (int)amt;
    }

    public static long intSRight(long val, int amt) {
        if (Integer.compareUnsigned(amt, 64) >= 0) {
            return val >> 63;
        }
        return val >> amt;
    }

    public static int intSRight(int val, long amt) {
        if (Long.compareUnsigned(amt, 32L) >= 0) {
            return val >> 31;
        }
        return val >> (int)amt;
    }

    public static int intSRight(int val, int amt) {
        if (Long.compareUnsigned(amt, 32L) >= 0) {
            return val >> 31;
        }
        return val >> amt;
    }

    public static void mpIntMultiply(int[] out, int[] inL, int[] inR) {
        long carry = 0L;
        long rp = (long)inR[0] & 0xFFFFFFFFL;
        for (int li = 0; li < inL.length && li < out.length; ++li) {
            long lp = (long)inL[li] & 0xFFFFFFFFL;
            out[li] = (int)(carry += lp * rp);
            carry >>>= 32;
        }
        for (int ri = 1; ri < inR.length && ri < out.length; ++ri) {
            carry = 0L;
            rp = (long)inR[ri] & 0xFFFFFFFFL;
            for (int li = 0; li < inL.length && ri + li < out.length; ++li) {
                long lp = (long)inL[li] & 0xFFFFFFFFL;
                long op = (long)out[li + ri] & 0xFFFFFFFFL;
                out[li + ri] = (int)(carry += op + lp * rp);
                carry >>>= 32;
            }
        }
    }

    public static String mpToString(int[] legs) {
        if (legs == null) {
            return "null";
        }
        List<String> list = IntStream.of(legs).mapToObj(i -> "%08x".formatted(i)).toList();
        return list.reversed().stream().collect(Collectors.joining(":"));
    }

    public static void mpIntDivide(int[] out, int[] inL, int[] inR) {
        MpDivPrivate.divide(out, inL, inR);
    }

    public static void mpIntSignedDivide(int[] out, int[] inL, int[] inR) {
        MpDivPrivate.sdivide(out, inL, inR);
    }

    public static Language getLanguage(String languageID) throws LanguageNotFoundException {
        return DefaultLanguageService.getLanguageService().getLanguage(new LanguageID(languageID));
    }

    public static RegisterValue createContext(Language language, String value) {
        return new RegisterValue(language.getContextBaseRegister(), new BigInteger(value, 16));
    }

    public static Varnode createVarnode(AddressFactory factory, String space, long offset, int size) {
        return new Varnode(factory.getAddressSpace(space).getAddress(offset), size);
    }

    public JitPcodeThread thread();

    default public void writeCounterAndContext(long counter, RegisterValue context) {
        JitPcodeThread thread = this.thread();
        Address pc = thread.getLanguage().getDefaultSpace().getAddress(counter);
        thread.writeCounterAndContext(pc, context);
    }

    default public void setCounterAndContext(long counter, RegisterValue context) {
        JitPcodeThread thread = this.thread();
        Address pc = thread.getLanguage().getDefaultSpace().getAddress(counter);
        thread.setCounterAndContext(pc, context);
    }

    default public PcodeUseropLibrary.PcodeUseropDefinition<byte[]> getUseropDefinition(String name) {
        return this.thread().getUseropLibrary().getUserops().get(name);
    }

    default public void invokeUserop(PcodeUseropLibrary.PcodeUseropDefinition<byte[]> userop, Varnode output, Varnode[] inputs) {
        userop.execute(this.thread().getExecutor(), this.thread().getUseropLibrary(), output, Arrays.asList(inputs));
    }

    default public DecodePcodeExecutionException createDecodeError(String message, long counter) {
        return new DecodePcodeExecutionException(message, this.thread().getLanguage().getDefaultSpace().getAddress(counter));
    }

    default public ExitSlot createExitSlot(long target, RegisterValue ctx) {
        return new ExitSlot(this.thread(), target, ctx);
    }

    public static EntryPoint getChained(ExitSlot slot) {
        return slot.getChained();
    }

    default public void count(int instructions, int trailingOps) {
        this.thread().count(instructions, trailingOps);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static final class MpShiftPrivate
    extends Enum<MpShiftPrivate> {
        private static final /* synthetic */ MpShiftPrivate[] $VALUES;

        public static MpShiftPrivate[] values() {
            return (MpShiftPrivate[])$VALUES.clone();
        }

        public static MpShiftPrivate valueOf(String name) {
            return Enum.valueOf(MpShiftPrivate.class, name);
        }

        static void shl(int[] out, int[] val, int amt) {
            int legs = amt >>> 5;
            int bits = amt & 0x1F;
            if (bits == 0) {
                int i = 0;
                while (i < val.length - legs & i < out.length - legs) {
                    out[i + legs] = val[i];
                    ++i;
                }
                return;
            }
            int prev = 0;
            int i = 0;
            while (i < val.length - legs & i < out.length - legs) {
                out[i + legs] = val[i] << bits | prev >>> 32 - bits;
                prev = val[i];
                ++i;
            }
        }

        static void ushr(int[] out, int[] val, int amt) {
            int legs = amt >>> 5;
            int bits = amt & 0x1F;
            if (bits == 0) {
                int i = 0;
                while (i < val.length - legs & i < out.length) {
                    out[i] = val[i + legs];
                    ++i;
                }
                return;
            }
            int prev = 0;
            for (int i = Math.min(val.length - legs, out.length) - 1; i >= 0; --i) {
                out[i] = val[i + legs] >>> bits | prev << 32 - bits;
                prev = val[i + legs];
            }
        }

        static void sshr(int[] out, int[] val, int amt, int sign) {
            int i;
            int legs = amt >>> 5;
            int bits = amt & 0x1F;
            if (bits == 0) {
                int i2 = 0;
                while (i2 < val.length - legs & i2 < out.length) {
                    out[i2] = val[i2 + legs];
                    ++i2;
                }
                if (sign != 0) {
                    for (i2 = val.length - legs; i2 < out.length; ++i2) {
                        out[i2] = sign;
                    }
                }
                return;
            }
            int prev = 0;
            if (val.length - legs - 1 >= 0) {
                out[val.length - legs - 1] = val[val.length - 1] >> bits;
                prev = val[val.length - 1];
            }
            for (i = Math.min(val.length - legs, out.length) - 2; i >= 0; --i) {
                out[i] = val[i + legs] >>> bits | prev << 32 - bits;
                prev = val[i + legs];
            }
            if (sign != 0) {
                for (i = val.length - legs; i < out.length; ++i) {
                    out[i] = sign;
                }
            }
        }

        private static /* synthetic */ MpShiftPrivate[] $values() {
            return new MpShiftPrivate[0];
        }

        static {
            $VALUES = MpShiftPrivate.$values();
        }
    }

    public static final class MpDivPrivate
    extends Enum<MpDivPrivate> {
        private static final /* synthetic */ MpDivPrivate[] $VALUES;

        public static MpDivPrivate[] values() {
            return (MpDivPrivate[])$VALUES.clone();
        }

        public static MpDivPrivate valueOf(String name) {
            return Enum.valueOf(MpDivPrivate.class, name);
        }

        static int lz(int[] legs) {
            int count = 0;
            for (int i = legs.length - 1; i >= 0; --i) {
                int llz = Integer.numberOfLeadingZeros(legs[i]);
                count += llz;
                if (llz != 32) break;
            }
            return count;
        }

        static int size(int[] legs) {
            for (int i = legs.length - 1; i >= 0; --i) {
                if (legs[i] == 0) continue;
                return i + 1;
            }
            return 0;
        }

        static void shl(int[] legs, int shift) {
            if (shift == 0) {
                return;
            }
            assert (shift >= 0 && shift < 32);
            long carry = 0L;
            for (int i = 0; i < legs.length; ++i) {
                legs[i] = (int)(carry |= ((long)legs[i] & 0xFFFFFFFFL) << shift);
                carry >>>= 32;
            }
        }

        static void shr(int[] legs, int shift) {
            if (shift == 0) {
                return;
            }
            assert (shift >= 0 && shift < 32);
            long carry = 0L;
            for (int i = legs.length - 1; i >= 0; --i) {
                legs[i] = (int)((carry |= ((long)legs[i] & 0xFFFFFFFFL) << 32 - shift) >> 32);
                carry <<= 32;
            }
        }

        static void divideMpSp(int[] out, int[] inL, int sizeL, int inR) {
            long r = 0L;
            for (int j = sizeL - 1; j >= 0; --j) {
                r <<= 32;
                out[j] = (int)((r += (long)inL[j] & 0xFFFFFFFFL) / (long)inR);
                r %= (long)inR;
                inL[j] = 0;
            }
            inL[0] = (int)r;
        }

        static void divide(int[] out, int[] inL, int[] inR) {
            int sizeL = MpDivPrivate.size(inL);
            int shiftBits = MpDivPrivate.lz(inR);
            int truncR = shiftBits / 32;
            int sizeR = inR.length - truncR;
            if (sizeR == 1) {
                MpDivPrivate.divideMpSp(out, inL, sizeL, inR[0]);
                return;
            }
            int shift = shiftBits % 32;
            MpDivPrivate.shl(inL, shift);
            MpDivPrivate.shl(inR, shift);
            for (int j = sizeL - sizeR; j >= 0; --j) {
                long qHat = ((long)inL[sizeR + j] & 0xFFFFFFFFL) << 32;
                long rHat = qHat |= (long)inL[sizeR + j - 1] & 0xFFFFFFFFL;
                long vNm1 = (long)inR[sizeR - 1] & 0xFFFFFFFFL;
                qHat /= vNm1;
                rHat %= vNm1;
                while (qHat == 0x100000000L || Long.compareUnsigned(qHat * ((long)inR[sizeR - 2] & 0xFFFFFFFFL), (rHat << 32) + ((long)inL[sizeR + j - 2] & 0xFFFFFFFFL)) > 0) {
                    --qHat;
                    if (Long.compareUnsigned(rHat += vNm1, 0x100000000L) < 0) continue;
                }
                long borrow = 0L;
                for (int i = 0; i < sizeR - 1; ++i) {
                    borrow = ((long)inL[j + i] & 0xFFFFFFFFL) - qHat * ((long)inR[i] & 0xFFFFFFFFL) + borrow;
                    inL[j + i] = (int)borrow;
                    borrow >>= 32;
                }
                borrow = ((long)inL[j + sizeR] & 0xFFFFFFFFL) + borrow;
                inL[j + sizeR] = (int)borrow;
                if ((borrow >>= 32) != 0L) {
                    assert (borrow == -1L);
                    --qHat;
                    long carry = 0L;
                    for (int i = 0; i < sizeR; ++i) {
                        inL[j + i] = (int)(carry += ((long)inL[j + i] & 0xFFFFFFFFL) + (long)inR[i]);
                        carry >>>= 32;
                    }
                }
                out[j] = (int)qHat;
            }
            MpDivPrivate.shr(inL, shift);
        }

        static void neg(int[] legs, int count) {
            long carry = 1L;
            for (int i = 0; i < count; ++i) {
                legs[i] = (int)(carry += (long)(~legs[i]) & 0xFFFFFFFFL);
                carry >>>= 32;
            }
        }

        static void sdivide(int[] out, int[] inL, int[] inR) {
            boolean signR;
            boolean signL = inL[inL.length - 2] < 0;
            boolean bl = signR = inR[inR.length - 1] < 0;
            if (signL) {
                MpDivPrivate.neg(inL, inL.length - 1);
            }
            if (signR) {
                MpDivPrivate.neg(inR, inR.length);
            }
            MpDivPrivate.divide(out, inL, inR);
            if (signL != signR) {
                MpDivPrivate.neg(out, out.length);
            }
            if (signL) {
                MpDivPrivate.neg(inL, inL.length - 1);
            }
        }

        private static /* synthetic */ MpDivPrivate[] $values() {
            return new MpDivPrivate[0];
        }

        static {
            $VALUES = MpDivPrivate.$values();
        }
    }

    public static class ExitSlot {
        private final JitPcodeThread thread;
        private final JitPassage.AddrCtx pcCtx;
        private EntryPoint chained;

        public ExitSlot(JitPcodeThread thread, long target, RegisterValue ctx) {
            this.thread = thread;
            this.pcCtx = new JitPassage.AddrCtx(ctx, thread.getLanguage().getDefaultSpace().getAddress(target));
        }

        public EntryPoint getChained() {
            if (this.chained == null) {
                this.chained = this.computeChained();
            }
            return this.chained;
        }

        private EntryPoint computeChained() {
            return this.thread.getEntry(this.pcCtx);
        }
    }

    public record EntryPoint(EntryPointPrototype prototype, JitCompiledPassage passage, int blockId) {
        public EntryPoint run() {
            return this.passage.run(this.blockId);
        }
    }

    public static class EntryPointPrototype {
        private final JitCompiledPassageClass cls;
        private final int blockId;
        private final Map<JitPcodeThread, EntryPoint> perThread = new HashMap<JitPcodeThread, EntryPoint>();

        public EntryPointPrototype(JitCompiledPassageClass cls, int blockId) {
            this.cls = cls;
            this.blockId = blockId;
        }

        public String toString() {
            return "EntryPointPrototype[%s,%d]".formatted(this.cls, this.blockId);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EntryPointPrototype)) {
                return false;
            }
            EntryPointPrototype that = (EntryPointPrototype)obj;
            if (!this.cls.equals(that.cls)) {
                return false;
            }
            return this.blockId == that.blockId;
        }

        public int hashCode() {
            return Objects.hash(this.cls, this.blockId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EntryPoint createInstance(JitPcodeThread thread) {
            Map<JitPcodeThread, EntryPoint> map = this.perThread;
            synchronized (map) {
                return this.perThread.computeIfAbsent(thread, t -> new EntryPoint(this, this.cls.createInstance((JitPcodeThread)t), this.blockId));
            }
        }
    }
}

