/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu;

import ghidra.pcode.emu.PcodeEmulationCallbacks;
import ghidra.pcode.emu.PcodeMachine;
import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeFrame;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.pcode.exec.PcodeUseropLibrary;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.pcode.PcodeOp;
import java.util.List;

public class ComposedPcodeEmulationCallbacks<T>
implements PcodeEmulationCallbacks<T> {
    private final List<PcodeEmulationCallbacks<T>> delegates;

    @SafeVarargs
    public ComposedPcodeEmulationCallbacks(PcodeEmulationCallbacks<T> ... delegates) {
        this.delegates = List.of(delegates);
    }

    @Override
    public void emulatorCreated(PcodeMachine<T> machine) {
        for (PcodeEmulationCallbacks<T> d : this.delegates) {
            d.emulatorCreated(machine);
        }
    }

    @Override
    public void sharedStateCreated(PcodeMachine<T> machine) {
        for (PcodeEmulationCallbacks<T> d : this.delegates) {
            d.sharedStateCreated(machine);
        }
    }

    @Override
    public void threadCreated(PcodeThread<T> thread) {
        for (PcodeEmulationCallbacks<T> d : this.delegates) {
            d.threadCreated(thread);
        }
    }

    @Override
    public PcodeProgram getInject(PcodeThread<T> thread, Address address) {
        for (PcodeEmulationCallbacks<T> d : this.delegates) {
            PcodeProgram inject = d.getInject(thread, address);
            if (inject == null) continue;
            return inject;
        }
        return null;
    }

    @Override
    public void beforeExecuteInject(PcodeThread<T> thread, Address address, PcodeProgram program) {
        for (PcodeEmulationCallbacks<T> d : this.delegates) {
            d.beforeExecuteInject(thread, address, program);
        }
    }

    @Override
    public void afterExecuteInject(PcodeThread<T> thread, Address address) {
        for (PcodeEmulationCallbacks<T> d : this.delegates) {
            d.afterExecuteInject(thread, address);
        }
    }

    @Override
    public void beforeDecodeInstruction(PcodeThread<T> thread, Address counter, RegisterValue context) {
        for (PcodeEmulationCallbacks<T> d : this.delegates) {
            d.beforeDecodeInstruction(thread, counter, context);
        }
    }

    @Override
    public void beforeExecuteInstruction(PcodeThread<T> thread, Instruction instruction, PcodeProgram program) {
        for (PcodeEmulationCallbacks<T> d : this.delegates) {
            d.beforeExecuteInstruction(thread, instruction, program);
        }
    }

    @Override
    public void afterExecuteInstruction(PcodeThread<T> thread, Instruction instruction) {
        for (PcodeEmulationCallbacks<T> d : this.delegates) {
            d.afterExecuteInstruction(thread, instruction);
        }
    }

    @Override
    public void beforeStepOp(PcodeThread<T> thread, PcodeOp op, PcodeFrame frame) {
        for (PcodeEmulationCallbacks<T> d : this.delegates) {
            d.beforeStepOp(thread, op, frame);
        }
    }

    @Override
    public void afterStepOp(PcodeThread<T> thread, PcodeOp op, PcodeFrame frame) {
        for (PcodeEmulationCallbacks<T> d : this.delegates) {
            d.afterStepOp(thread, op, frame);
        }
    }

    @Override
    public void beforeLoad(PcodeThread<T> thread, PcodeOp op, AddressSpace space, T offset, int size) {
        for (PcodeEmulationCallbacks<T> d : this.delegates) {
            d.beforeLoad(thread, op, space, offset, size);
        }
    }

    @Override
    public void afterLoad(PcodeThread<T> thread, PcodeOp op, AddressSpace space, T offset, int size, T value) {
        for (PcodeEmulationCallbacks<T> d : this.delegates) {
            d.afterLoad(thread, op, space, offset, size, value);
        }
    }

    @Override
    public void beforeStore(PcodeThread<T> thread, PcodeOp op, AddressSpace space, T offset, int size, T value) {
        for (PcodeEmulationCallbacks<T> d : this.delegates) {
            d.beforeStore(thread, op, space, offset, size, value);
        }
    }

    @Override
    public void afterStore(PcodeThread<T> thread, PcodeOp op, AddressSpace space, T offset, int size, T value) {
        for (PcodeEmulationCallbacks<T> d : this.delegates) {
            d.afterStore(thread, op, space, offset, size, value);
        }
    }

    @Override
    public void afterBranch(PcodeThread<T> thread, PcodeOp op, Address target) {
        for (PcodeEmulationCallbacks<T> d : this.delegates) {
            d.afterBranch(thread, op, target);
        }
    }

    @Override
    public boolean handleMissingUserop(PcodeThread<T> thread, PcodeOp op, PcodeFrame frame, String opName, PcodeUseropLibrary<T> library) {
        for (PcodeEmulationCallbacks<T> d : this.delegates) {
            if (!d.handleMissingUserop(thread, op, frame, opName, library)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <A, U> void dataWritten(PcodeThread<T> thread, PcodeExecutorStatePiece<A, U> piece, AddressSpace space, A offset, int length, U value) {
        for (PcodeEmulationCallbacks<T> d : this.delegates) {
            d.dataWritten(thread, piece, space, offset, length, value);
        }
    }

    @Override
    public <A, U> void dataWritten(PcodeThread<T> thread, PcodeExecutorStatePiece<A, U> piece, Address address, int length, U value) {
        for (PcodeEmulationCallbacks<T> d : this.delegates) {
            d.dataWritten(thread, piece, address, length, value);
        }
    }

    @Override
    public <A, U> int readUninitialized(PcodeThread<T> thread, PcodeExecutorStatePiece<A, U> piece, AddressSpace space, A offset, int length) {
        int maxL = 0;
        for (PcodeEmulationCallbacks<T> d : this.delegates) {
            if ((maxL = Math.max(maxL, d.readUninitialized(thread, piece, space, offset, length))) != length) continue;
            return maxL;
        }
        return maxL;
    }

    @Override
    public <A, U> AddressSetView readUninitialized(PcodeThread<T> thread, PcodeExecutorStatePiece<A, U> piece, AddressSetView set) {
        AddressSetView remains = set;
        for (PcodeEmulationCallbacks<T> d : this.delegates) {
            remains = d.readUninitialized(thread, piece, remains);
            if (!remains.isEmpty()) continue;
            return remains;
        }
        return remains;
    }
}

