/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.algo;

import ghidra.graph.GDirectedGraph;
import ghidra.graph.GEdge;
import ghidra.graph.algo.FindPathsAlgorithm;
import ghidra.graph.algo.GraphAlgorithmStatusListener;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class RecursiveFindPathsAlgorithm<V, E extends GEdge<V>>
implements FindPathsAlgorithm<V, E> {
    public static final int JAVA_STACK_DEPTH_LIMIT = 2700;
    private GDirectedGraph<V, E> g;
    private V startVertex;
    private V endVertex;
    private Stack<V> stack = new Stack();
    private Set<V> blockedSet = new HashSet<V>();
    private Map<V, Set<V>> blockedBackEdgesMap = new HashMap<V, Set<V>>();
    private Accumulator<List<V>> accumulator;
    private TaskMonitor monitor;
    private GraphAlgorithmStatusListener<V> listener = new GraphAlgorithmStatusListener();

    @Override
    public void setStatusListener(GraphAlgorithmStatusListener<V> listener) {
        this.listener = listener;
    }

    @Override
    public void findPaths(GDirectedGraph<V, E> g, V start, V end, Accumulator<List<V>> accumulator, TaskMonitor monitor) throws CancelledException {
        this.g = g;
        this.startVertex = start;
        this.endVertex = end;
        this.accumulator = accumulator;
        this.monitor = monitor;
        this.explore(this.startVertex, 0);
        this.listener.finished();
    }

    private boolean explore(V v, int depth) throws CancelledException {
        Object u;
        if (depth > 2700) {
            return false;
        }
        boolean foundPath = false;
        this.blockedSet.add(v);
        this.stack.push(v);
        this.setStatus(v, GraphAlgorithmStatusListener.STATUS.EXPLORING);
        Collection<E> outEdges = this.getOutEdges(v);
        for (GEdge e : outEdges) {
            this.monitor.checkCancelled();
            u = e.getEnd();
            if (u.equals(this.endVertex)) {
                this.outputCircuit();
                foundPath = true;
                this.monitor.incrementProgress(1L);
                continue;
            }
            if (this.blockedSet.contains(u)) continue;
            foundPath |= this.explore(u, depth + 1);
            this.monitor.incrementProgress(1L);
        }
        if (foundPath) {
            this.unblock(v);
        } else {
            for (GEdge e : outEdges) {
                this.monitor.checkCancelled();
                u = e.getEnd();
                this.blockBackEdge(u, v);
            }
        }
        this.stack.pop();
        this.setStatus(v, GraphAlgorithmStatusListener.STATUS.WAITING);
        return foundPath;
    }

    private Collection<E> getOutEdges(V v) {
        Collection<E> outEdges = this.g.getOutEdges(v);
        if (outEdges == null) {
            return Collections.emptyList();
        }
        return outEdges;
    }

    private void unblock(V v) {
        this.blockedSet.remove(v);
        this.setStatus(v, GraphAlgorithmStatusListener.STATUS.WAITING);
        Set<V> set = this.blockedBackEdgesMap.get(v);
        if (set == null) {
            return;
        }
        for (V u : set) {
            if (!this.blockedSet.contains(u)) continue;
            this.unblock(u);
        }
        set.clear();
    }

    private void blockBackEdge(V u, V v) {
        Set<V> set = this.blockedBackEdgesMap.get(u);
        if (set == null) {
            set = new HashSet<V>();
            this.blockedBackEdgesMap.put((Set<V>)u, (Set<Set<V>>)set);
        }
        set.add(v);
        this.setStatus(v, GraphAlgorithmStatusListener.STATUS.BLOCKED);
    }

    private void outputCircuit() throws CancelledException {
        LinkedList<V> path = new LinkedList<V>(this.stack);
        path.add(this.endVertex);
        this.setStatus((V)path, GraphAlgorithmStatusListener.STATUS.IN_PATH);
        this.accumulator.add(path);
        this.monitor.checkCancelled();
        this.setStatus(this.endVertex, GraphAlgorithmStatusListener.STATUS.WAITING);
    }

    private void setStatus(List<V> path, GraphAlgorithmStatusListener.STATUS s) {
        for (V v : path) {
            this.listener.statusChanged(v, s);
        }
    }

    private void setStatus(V v, GraphAlgorithmStatusListener.STATUS s) {
        if (this.blockedSet.contains(v) && s == GraphAlgorithmStatusListener.STATUS.WAITING) {
            this.listener.statusChanged(v, GraphAlgorithmStatusListener.STATUS.BLOCKED);
        } else {
            this.listener.statusChanged(v, s);
        }
    }
}

