/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.format;

import ghidra.app.plugin.core.byteviewer.ByteViewerComponentProvider;
import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockAccessException;
import ghidra.app.plugin.core.format.UniversalDataFormatModel;
import ghidra.util.HelpLocation;
import java.math.BigInteger;

public class PETSCIIShiftedFormatModel
implements UniversalDataFormatModel {
    private int symbolSize = 1;

    @Override
    public String getName() {
        return "PETSCII Shifted";
    }

    @Override
    public int getUnitByteSize() {
        return 1;
    }

    @Override
    public int getByteOffset(ByteBlock block, int position) {
        return 0;
    }

    @Override
    public int getColumnPosition(ByteBlock block, int byteOffset) {
        return 0;
    }

    @Override
    public int getDataUnitSymbolSize() {
        return this.symbolSize;
    }

    @Override
    public String getDataRepresentation(ByteBlock block, BigInteger index) throws ByteBlockAccessException {
        String[] Petscii = new String[]{"@", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "[", "\u00a3", "]", "\u2191", "\u2190", " ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "<", "=", ">", "?", "@", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "[", "\u00a3", "]", "\u2191", "\u2190", "\ud83e\udf79", "\u2660", "\ud83e\udf72", "\ud83e\udf78", "\ud83e\udf77", "\ud83e\udf76", "\ud83e\udf7a", "\ud83e\udf71", "\ud83e\udf74", "\u256e", "\u2570", "\u256f", "\ud83e\udf7c", "\u2572", "\u2571", "\ud83e\udf7d", "\ud83e\udf7e", "\u25cf", "\ud83e\udf7b", "\u2665", "\ud83e\udf70", "\u256d", "\u2573", "\u25cb", "\u2663", "\ud83e\udf75", "\u2666", "\u253c", "\ud83e\udf8c", "\u2502", "\u03c0", "\u25e5", "\ud83e\udf79", "\u2660", "\ud83e\udf72", "\ud83e\udf78", "\ud83e\udf77", "\ud83e\udf76", "\ud83e\udf7a", "\ud83e\udf71", "\ud83e\udf74", "\u256e", "\u2570", "\u256f", "\ud83e\udf7c", "\u2572", "\u2571", "\ud83e\udf7d", "\ud83e\udf7e", "\u25cf", "\ud83e\udf7b", "\u2665", "\ud83e\udf70", "\u256d", "\u2573", "\u25cb", "\u2663", "\ud83e\udf75", "\u2666", "\u253c", "\ud83e\udf8c", "\u2502", "\u03c0", "\u25e5", "\u00a0", "\u258c", "\u2584", "\u2594", "\u2581", "\u258f", "\u2592", "\u2495", "\ud83e\udf8f", "\u25e4", "\ud83e\udf87", "\u251c", "\u2597", "\u2514", "\u2510", "\u2582", "\u250c", "\u2534", "\u252c", "\u2524", "\u258e", "\u258d", "\ud83e\udf88", "\ud83e\udf82", "\ud83e\udf83", "\u2583", "\ud83e\udf7f", "\u2596", "\u259d", "\u2518", "\u2598", "\u259a", "\ud83e\udf79", "\u2660", "\ud83e\udf72", "\ud83e\udf78", "\ud83e\udf77", "\ud83e\udf76", "\ud83e\udf7a", "\ud83e\udf71", "\ud83e\udf74", "\u256e", "\u2570", "\u256f", "\ud83e\udf7c", "\u2572", "\u2571", "\ud83e\udf7d", "\ud83e\udf7e", "\u25cf", "\ud83e\udf7b", "\u2665", "\ud83e\udf70", "\u256d", "\u2573", "\u25cb", "\u2663", "\ud83e\udf75", "\u2666", "\u253c", "\ud83e\udf8c", "\u2502", "\u03c0", "\u25e5", "\u00a0", "\u258c", "\u2584", "\u2594", "\u2581", "\u258f", "\u2592", "\u2595", "\ud83e\udf8f", "\u25e4", "\ud83e\udf87", "\u251c", "\u2597", "\u2514", "\u2510", "\u2582", "\u250c", "\u2534", "\u252c", "\u2524", "\u258e", "\u258d", "\ud83e\udf88", "\ud83e\udf82", "\ud83e\udf83", "\u2583", "\ud83e\udf7f", "\u2596", "\u259d", "\u2518", "\u2598", "\u03c0"};
        byte b = block.getByte(index);
        String str = null;
        str = Petscii[b & 0xFF];
        return str;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public boolean replaceValue(ByteBlock block, BigInteger index, int charPosition, char c) throws ByteBlockAccessException {
        if (charPosition != 0) {
            return false;
        }
        block.getByte(index);
        byte cb = (byte)c;
        if (cb < 32 || cb == 127) {
            return false;
        }
        block.setByte(index, cb);
        return true;
    }

    @Override
    public int getGroupSize() {
        return 0;
    }

    @Override
    public void setGroupSize(int groupSize) {
        throw new UnsupportedOperationException("groups are not supported");
    }

    @Override
    public int getUnitDelimiterSize() {
        return 0;
    }

    @Override
    public boolean validateBytesPerLine(int bytesPerLine) {
        return true;
    }

    @Override
    public HelpLocation getHelpLocation() {
        return new HelpLocation("ByteViewerPlugin", "Petscii");
    }

    @Override
    public void dispose() {
    }

    public boolean supportsProvider(ByteViewerComponentProvider provider) {
        return true;
    }
}

