/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.format;

import ghidra.app.plugin.core.byteviewer.ByteViewerComponentProvider;
import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteBlockAccessException;
import ghidra.app.plugin.core.format.UniversalDataFormatModel;
import ghidra.util.HelpLocation;
import java.math.BigInteger;

public class C64CharsetUnshiftedFormatModel
implements UniversalDataFormatModel {
    private int symbolSize = 1;

    @Override
    public String getName() {
        return "C64 Charset Unshifted";
    }

    @Override
    public int getUnitByteSize() {
        return 1;
    }

    @Override
    public int getByteOffset(ByteBlock block, int position) {
        return 0;
    }

    @Override
    public int getColumnPosition(ByteBlock block, int byteOffset) {
        return 0;
    }

    @Override
    public int getDataUnitSymbolSize() {
        return this.symbolSize;
    }

    @Override
    public String getDataRepresentation(ByteBlock block, BigInteger index) throws ByteBlockAccessException {
        String[] Petscii = new String[]{"@", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "[", "\u00a3", "]", "\u2191", "\u2190", " ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ":", ";", "<", "=", ">", "?", "\ud83e\udf79", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "\u253c", "\ud83e\udf8c", "\u2502", "\ud83e\udf96", "\ud83e\udf98", "\u00a0", "\u258c", "\u2584", "\u2594", "\u2581", "\u258f", "\u2592", "\u2595", "\ud83e\udf8f", "\ud83e\udf99", "\ud83e\udf87", "\u251c", "\u2597", "\u2514", "\u2510", "\u2582", "\u250c", "\u2534", "\u252c", "\u2524", "\u258e", "\u258d", "\ud83e\udf88", "\ud83e\udf82", "\ud83e\udf83", "\u2583", "\u2713", "\u2596", "\u259d", "\u2518", "\u2598", "\u259a", "\ue080", "\ue081", "\ue082", "\ue083", "\ue084", "\ue085", "\ue086", "\ue087", "\ue088", "\ue089", "\ue08a", "\ue08b", "\ue08c", "\ue08d", "\ue08e", "\ue08f", "\ue090", "\ue091", "\ue092", "\ue093", "\ue094", "\ue095", "\ue096", "\ue097", "\ue098", "\ue099", "\ue09a", "\ue09b", "\ue09c", "\ue09d", "\ue09e", "\ue09f", "\ue0a0", "\ue0a1", "\ue0a2", "\ue0a3", "\ue0a4", "\ue0a5", "\ue0a6", "\ue0a7", "\ue0a8", "\ue0a9", "\ue0aa", "\ue0ab", "\ue0ac", "\ue0ad", "\ue0ae", "\ue0af", "\ue0b0", "\ue0b1", "\ue0b2", "\ue0b3", "\ue0b4", "\ue0b5", "\ue0b6", "\ue0b7", "\ue0b8", "\ue0b9", "\ue0ba", "\ue0bb", "\ue0bc", "\ue0bd", "\ue0be", "\ue0bf", "\ue0c0", "\ue0c1", "\ue0c2", "\ue0c3", "\ue0c4", "\ue0c5", "\ue0c6", "\ue0c7", "\ue0c8", "\ue0c9", "\ue0ca", "\ue0cb", "\ue0cc", "\ue0cd", "\ue0ce", "\ue0cf", "\ue0d0", "\ue0d1", "\ue0d2", "\ue0d3", "\ue0d4", "\ue0d5", "\ue0d6", "\ue0d7", "\ue0d8", "\ue0d9", "\ue0da", "\ue0db", "\ue0dc", "\ue0dd", "\ue0de", "\ue0df", "\ue0e0", "\ue0e1", "\ue0e2", "\ue0e3", "\ue0e4", "\ue0e5", "\ue0e6", "\ue0e7", "\ue0e8", "\ue0e9", "\ue0ea", "\ue0eb", "\ue0ec", "\ue0ed", "\ue0ee", "\ue0ef", "\ue0f0", "\ue0f1", "\ue0f2", "\ue0f3", "\ue0f4", "\ue0f5", "\ue0f6", "\ue0f7", "\ue0f8", "\ue0f9", "\ue0fa", "\ue0fb", "\ue0fc", "\ue0fd", "\ue0fe", "\ue0ff"};
        byte b = block.getByte(index);
        String str = null;
        str = Petscii[b & 0xFF];
        return str;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public boolean replaceValue(ByteBlock block, BigInteger index, int charPosition, char c) throws ByteBlockAccessException {
        if (charPosition != 0) {
            return false;
        }
        block.getByte(index);
        byte cb = (byte)c;
        if (cb < 32 || cb == 127) {
            return false;
        }
        block.setByte(index, cb);
        return true;
    }

    @Override
    public int getGroupSize() {
        return 0;
    }

    @Override
    public void setGroupSize(int groupSize) {
        throw new UnsupportedOperationException("groups are not supported");
    }

    @Override
    public int getUnitDelimiterSize() {
        return 0;
    }

    @Override
    public boolean validateBytesPerLine(int bytesPerLine) {
        return true;
    }

    @Override
    public HelpLocation getHelpLocation() {
        return new HelpLocation("ByteViewerPlugin", "Petscii");
    }

    @Override
    public void dispose() {
    }

    public boolean supportsProvider(ByteViewerComponentProvider provider) {
        return true;
    }
}

