/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.functiongraph;

import docking.action.DockingAction;
import ghidra.app.nav.LocationMemento;
import ghidra.app.nav.Navigatable;
import ghidra.app.nav.NavigatableRemovalListener;
import ghidra.app.plugin.core.colorizer.ColorizingService;
import ghidra.app.plugin.core.functiongraph.DiscoverableFGLayoutFinder;
import ghidra.app.plugin.core.functiongraph.FGColorProvider;
import ghidra.app.plugin.core.functiongraph.IndependentColorProvider;
import ghidra.app.plugin.core.functiongraph.ToolBasedColorProvider;
import ghidra.app.plugin.core.functiongraph.graph.layout.FGLayoutOptions;
import ghidra.app.plugin.core.functiongraph.graph.layout.FGLayoutProvider;
import ghidra.app.plugin.core.functiongraph.graph.layout.flowchart.FlowChartLayoutProvider;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FGControllerListener;
import ghidra.app.plugin.core.functiongraph.mvc.FgEnv;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphOptions;
import ghidra.app.services.ClipboardService;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.features.codecompare.functiongraph.FunctionGraphCodeComparisonView;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.ServiceListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.UniversalIdGenerator;
import ghidra.util.exception.AssertException;
import ghidra.util.task.SwingUpdateManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JComponent;

public class FgDisplay
implements OptionsChangeListener {
    private static final String FUNCTION_GRAPH_NAME = "Function Graph";
    private PluginTool tool;
    private String owner;
    private Program program;
    private FGController controller;
    private FgOptions fgOptions;
    private FormatManager userDefinedFormatManager;
    private ProgramLocation currentLocation;
    private FgDisplayProgramListener programListener = new FgDisplayProgramListener();
    private FgServiceListener serviceListener = new FgServiceListener();
    private FGColorProvider colorProvider;
    private List<FGLayoutProvider> layoutProviders;
    private Consumer<ProgramLocation> locationConsumer;
    private Consumer<FgDisplay> graphChangedConsumer;

    FgDisplay(FunctionGraphCodeComparisonView fgView, Consumer<ProgramLocation> locationConsumer, Consumer<FgDisplay> graphChangedConsumer) {
        this.tool = fgView.getTool();
        this.owner = fgView.getOwner();
        this.locationConsumer = locationConsumer;
        this.graphChangedConsumer = graphChangedConsumer;
        this.fgOptions = new FgOptions(this);
        this.layoutProviders = this.loadLayoutProviders();
        this.colorProvider = new IndependentColorProvider(this.tool);
        this.init();
        FgComparisonEnv env = new FgComparisonEnv();
        FgCoparisonControllerListener listener = new FgCoparisonControllerListener();
        this.controller = new FGController((FgEnv)env, (FGControllerListener)listener);
        this.setDefaultLayout();
    }

    private void setDefaultLayout() {
        FGLayoutProvider initialLayout = this.layoutProviders.get(0);
        for (FGLayoutProvider layout : this.layoutProviders) {
            if (!layout.getClass().equals(FlowChartLayoutProvider.class)) continue;
            initialLayout = layout;
            break;
        }
        this.controller.changeLayout(initialLayout);
    }

    private void init() {
        this.tool.addServiceListener((ServiceListener)this.serviceListener);
        ColorizingService colorizingService = (ColorizingService)this.tool.getService(ColorizingService.class);
        if (colorizingService != null) {
            this.colorProvider = new ToolBasedColorProvider(() -> this.program, colorizingService);
        }
    }

    private List<FGLayoutProvider> loadLayoutProviders() {
        DiscoverableFGLayoutFinder layoutFinder = new DiscoverableFGLayoutFinder();
        List instances = layoutFinder.findLayouts();
        if (instances.isEmpty()) {
            throw new AssertException("Could not find any layout providers. You project may not be configured properly.");
        }
        ArrayList<FGLayoutProvider> layouts = new ArrayList<FGLayoutProvider>(instances);
        Collections.sort(layouts, (o1, o2) -> -o1.getPriorityLevel() + o2.getPriorityLevel());
        return layouts;
    }

    private void initializeOptions() {
        ToolOptions options = this.tool.getOptions("Graph");
        options.removeOptionsChangeListener((OptionsChangeListener)this);
        options.addOptionsChangeListener((OptionsChangeListener)this);
        Options subOptions = options.getOptions(FUNCTION_GRAPH_NAME);
        this.fgOptions.registerOptions(subOptions);
        this.fgOptions.loadOptions(subOptions);
        for (FGLayoutProvider layoutProvider : this.layoutProviders) {
            String layoutName;
            Options layoutToolOptions;
            FGLayoutOptions layoutOptions = layoutProvider.createLayoutOptions(layoutToolOptions = subOptions.getOptions(layoutName = layoutProvider.getLayoutName()));
            if (layoutOptions == null) continue;
            layoutOptions.registerOptions(layoutToolOptions);
            layoutOptions.loadOptions(layoutToolOptions);
            this.fgOptions.setLayoutOptions(layoutName, layoutOptions);
        }
    }

    public FGController getController() {
        return this.controller;
    }

    public String getOwner() {
        return this.owner;
    }

    public JComponent getComponent() {
        return this.controller.getViewComponent();
    }

    public void dispose() {
        if (this.program != null) {
            this.program.removeListener((DomainObjectListener)this.programListener);
            this.program = null;
        }
        this.programListener.dispose();
        this.controller.cleanup();
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        Options subOptions = options.getOptions(FUNCTION_GRAPH_NAME);
        this.fgOptions.loadOptions(subOptions);
        this.controller.optionsChanged();
        if (this.fgOptions.optionChangeRequiresRelayout(optionName)) {
            this.controller.refresh(true);
        } else if ("View Settings".equals(optionName)) {
            this.controller.clearViewSettings();
        } else {
            this.controller.refreshDisplayWithoutRebuilding();
        }
    }

    public void showFunction(Function function) {
        this.updateProgram(function);
        if (function == null) {
            this.controller.setStatusMessage("No Function");
            return;
        }
        if (function.isExternal()) {
            String name = function.getName(true);
            this.controller.setStatusMessage("\"" + name + "\" is an external function.");
            return;
        }
        Address entry = function.getEntryPoint();
        this.currentLocation = new ProgramLocation(this.program, entry);
        this.controller.display(this.program, this.currentLocation);
    }

    public void setLocation(ProgramLocation location) {
        this.controller.setLocation(location);
    }

    public ProgramLocation getLocation() {
        return this.controller.getLocation();
    }

    private void updateProgram(Function function) {
        Program newProgram;
        Program program = newProgram = function == null ? null : function.getProgram();
        if (this.program == newProgram) {
            return;
        }
        if (this.program != null) {
            this.program.removeListener((DomainObjectListener)this.programListener);
        }
        this.program = newProgram;
        if (this.program != null) {
            this.program.addListener((DomainObjectListener)this.programListener);
            this.initializeOptions();
        }
    }

    public boolean isBusy() {
        return this.controller.isBusy();
    }

    private void refresh() {
        this.controller.refresh(true);
    }

    private class FgDisplayProgramListener
    implements DomainObjectListener {
        private SwingUpdateManager updater = new SwingUpdateManager(500, 5000, () -> FgDisplay.this.refresh());

        private FgDisplayProgramListener() {
        }

        public void domainObjectChanged(DomainObjectChangedEvent ev) {
            this.updater.update();
        }

        public void dispose() {
            this.updater.dispose();
        }
    }

    private class FgServiceListener
    implements ServiceListener {
        private FgServiceListener() {
        }

        public void serviceAdded(Class<?> interfaceClass, Object service) {
            if (interfaceClass != ClipboardService.class && interfaceClass == ColorizingService.class) {
                FgDisplay.this.colorProvider = new ToolBasedColorProvider(() -> FgDisplay.this.program, (ColorizingService)service);
                FgDisplay.this.controller.refresh(true);
            }
        }

        public void serviceRemoved(Class<?> interfaceClass, Object service) {
            if (interfaceClass == ColorizingService.class) {
                FgDisplay.this.colorProvider = new IndependentColorProvider(FgDisplay.this.tool);
                FgDisplay.this.controller.refresh(true);
            }
        }
    }

    private class FgOptions
    extends FunctionGraphOptions {
        private FgOptions(FgDisplay fgDisplay) {
        }

        public void setUseAnimation(boolean useAnimation) {
        }

        public void loadOptions(Options options) {
            super.loadOptions(options);
            this.useAnimation = false;
        }
    }

    private class FgComparisonEnv
    implements FgEnv {
        private Navigatable navigatable;

        private FgComparisonEnv() {
            this.navigatable = new DummyNavigatable();
        }

        public PluginTool getTool() {
            return FgDisplay.this.tool;
        }

        public Program getProgram() {
            return FgDisplay.this.program;
        }

        public FunctionGraphOptions getOptions() {
            return FgDisplay.this.fgOptions;
        }

        public List<FGLayoutProvider> getLayoutProviders() {
            return FgDisplay.this.layoutProviders;
        }

        public void addLocalAction(DockingAction action) {
        }

        public FGColorProvider getColorProvider() {
            return FgDisplay.this.colorProvider;
        }

        public FormatManager getUserDefinedFormat() {
            return FgDisplay.this.userDefinedFormatManager;
        }

        public void setUserDefinedFormat(FormatManager format) {
            FgDisplay.this.userDefinedFormatManager = format;
        }

        public Navigatable getNavigatable() {
            return this.navigatable;
        }

        public ProgramLocation getToolLocation() {
            return FgDisplay.this.currentLocation;
        }

        public ProgramLocation getGraphLocation() {
            return FgDisplay.this.currentLocation;
        }

        public void setSelection(ProgramSelection selection) {
            FgDisplay.this.controller.setSelection(selection);
        }
    }

    private class FgCoparisonControllerListener
    implements FGControllerListener {
        private FgCoparisonControllerListener() {
        }

        public void dataChanged() {
            FgDisplay.this.graphChangedConsumer.accept(FgDisplay.this);
        }

        public void userChangedLocation(ProgramLocation location, boolean vertexChanged) {
            FgDisplay.this.currentLocation = location;
            FgDisplay.this.locationConsumer.accept(location);
        }

        public void userChangedSelection(ProgramSelection selection) {
        }

        public void userSelectedText(String s) {
        }

        public void userNavigated(ProgramLocation location) {
        }
    }

    private class FgMemento
    extends LocationMemento {
        FgMemento(FgDisplay fgDisplay) {
            super((Program)null, null);
        }
    }

    private class DummyNavigatable
    implements Navigatable {
        private long id = UniversalIdGenerator.nextID().getValue();

        DummyNavigatable() {
        }

        public long getInstanceID() {
            return this.id;
        }

        public boolean goTo(Program p, ProgramLocation pl) {
            return false;
        }

        public ProgramLocation getLocation() {
            return null;
        }

        public Program getProgram() {
            return FgDisplay.this.program;
        }

        public LocationMemento getMemento() {
            return new FgMemento(FgDisplay.this);
        }

        public void setMemento(LocationMemento memento) {
        }

        public Icon getNavigatableIcon() {
            return null;
        }

        public boolean isConnected() {
            return false;
        }

        public boolean supportsMarkers() {
            return false;
        }

        public void requestFocus() {
        }

        public boolean isVisible() {
            return true;
        }

        public void setSelection(ProgramSelection selection) {
        }

        public void setHighlight(ProgramSelection highlight) {
        }

        public ProgramSelection getSelection() {
            return null;
        }

        public ProgramSelection getHighlight() {
            return null;
        }

        public String getTextSelection() {
            return null;
        }

        public void addNavigatableListener(NavigatableRemovalListener listener) {
        }

        public void removeNavigatableListener(NavigatableRemovalListener listener) {
        }

        public boolean isDisposed() {
            return false;
        }

        public boolean supportsHighlight() {
            return false;
        }

        public void setHighlightProvider(ListingHighlightProvider highlightProvider, Program program) {
        }

        public void removeHighlightProvider(ListingHighlightProvider highlightProvider, Program p) {
        }
    }
}

