/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import generic.theme.Gui;
import generic.theme.ThemeEvent;
import generic.theme.ThemeListener;
import ghidra.framework.options.ActionTrigger;
import ghidra.framework.options.CustomOption;
import ghidra.framework.options.EnumEditor;
import ghidra.framework.options.NoRegisteredEditorPropertyEditor;
import ghidra.framework.options.Option;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.OptionsEditor;
import ghidra.framework.options.SubOptions;
import ghidra.framework.options.ThemeColorOption;
import ghidra.framework.options.ThemeFontOption;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import ghidra.util.exception.AssertException;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.swing.KeyStroke;
import utilities.util.reflection.ReflectionUtilities;
import utility.function.Dummy;

public abstract class AbstractOptions
implements Options {
    public static final Set<Class<?>> SUPPORTED_CLASSES = AbstractOptions.buildSupportedClassSet();
    protected String name;
    protected Map<String, Option> valueMap;
    protected WeakSet<OptionsChangeListener> listeners;
    protected Map<String, OptionsEditor> optionsEditorMap;
    protected Map<String, HelpLocation> categoryHelpMap;
    protected Map<String, AliasBinding> aliasMap;
    protected ThemeListener themeListener;
    protected Map<String, String> themeToOptionMap = new HashMap<String, String>();

    private static Set<Class<?>> buildSupportedClassSet() {
        HashSet set = new HashSet();
        set.add(Byte.class);
        set.add(Short.class);
        set.add(Integer.class);
        set.add(Long.class);
        set.add(Float.class);
        set.add(Double.class);
        set.add(Boolean.class);
        set.add(String.class);
        set.add(Color.class);
        set.add(Font.class);
        set.add(KeyStroke.class);
        set.add(ActionTrigger.class);
        set.add(File.class);
        set.add(Date.class);
        return set;
    }

    protected AbstractOptions(String name) {
        this.name = name;
        this.valueMap = new HashMap<String, Option>();
        this.listeners = WeakDataStructureFactory.createCopyOnReadWeakSet();
        this.optionsEditorMap = new HashMap<String, OptionsEditor>();
        this.categoryHelpMap = new HashMap<String, HelpLocation>();
        this.aliasMap = new HashMap<String, AliasBinding>();
        this.themeListener = this::themeChanged;
        Gui.addThemeListener(this.themeListener);
    }

    protected abstract Option createRegisteredOption(String var1, OptionType var2, String var3, HelpLocation var4, Object var5, PropertyEditor var6);

    protected abstract Option createUnregisteredOption(String var1, OptionType var2, Object var3);

    protected abstract boolean notifyOptionChanged(String var1, Object var2, Object var3);

    public synchronized void registerOptionsEditor(String categoryPath, Supplier<OptionsEditor> editorSupplier) {
        OptionsEditor editor = null;
        if (!SystemUtilities.isInHeadlessMode()) {
            editor = editorSupplier.get();
        }
        this.optionsEditorMap.put(categoryPath, editor);
    }

    public synchronized OptionsEditor getOptionsEditor(String categoryPath) {
        return this.optionsEditorMap.get(categoryPath);
    }

    public void dispose() {
        this.optionsEditorMap.values().forEach(editor -> editor.dispose());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    @Override
    public void registerOption(String optionName, Object defaultValue, HelpLocation help, String description) {
        if (defaultValue == null) {
            throw new IllegalArgumentException("Attempted to register an option with a null value.  If a null value is an acceptable default, then call registerOption() that takes an OptionType.");
        }
        if (!this.isSupportedType(defaultValue)) {
            throw new IllegalArgumentException("Attempted to register an unsupported object: " + String.valueOf(defaultValue.getClass()));
        }
        OptionType type = OptionType.getOptionType(defaultValue);
        this.registerOption(optionName, type, defaultValue, help, description);
    }

    @Override
    public void registerOption(String optionName, OptionType type, Object defaultValue, HelpLocation help, String description) {
        this.registerOption(optionName, type, defaultValue, help, description, (Supplier<PropertyEditor>)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOption(String optionName, OptionType type, Object defaultValue, HelpLocation help, String description, Supplier<PropertyEditor> editorSupplier) {
        if (type == OptionType.NO_TYPE) {
            throw new IllegalArgumentException("Can't register an option of type: " + String.valueOf((Object)OptionType.NO_TYPE));
        }
        if (type == OptionType.COLOR_TYPE) {
            this.warnShouldUseTheme("Color");
        }
        if (type == OptionType.FONT_TYPE) {
            this.warnShouldUseTheme("font");
        }
        if (type == OptionType.KEYSTROKE_TYPE) {
            type = OptionType.ACTION_TRIGGER;
            if (defaultValue instanceof KeyStroke) {
                defaultValue = new ActionTrigger((KeyStroke)defaultValue);
            }
            if (editorSupplier != null) {
                Msg.error((Object)this, (Object)"Custom KeyStroke property editors are no longer supported.  Use ActionTrigger instead");
                editorSupplier = null;
            }
        }
        if (!type.isCompatible(defaultValue)) {
            throw new IllegalStateException("Given default value does not match the given OptionType! OptionType = " + String.valueOf((Object)type) + ", defaultValue = " + String.valueOf(defaultValue));
        }
        editorSupplier = Dummy.ifNull(editorSupplier);
        PropertyEditor editor = null;
        boolean isHeadless = SystemUtilities.isInHeadlessMode();
        if (!isHeadless) {
            editor = (PropertyEditor)editorSupplier.get();
        }
        if (type == OptionType.CUSTOM_TYPE && !isHeadless && editor == null) {
            throw new IllegalStateException("Can't register a custom option without a property editor");
        }
        if (description == null) {
            Msg.error((Object)this, (Object)("Registered an option without a description: " + optionName), (Throwable)ReflectionUtilities.createJavaFilteredThrowable());
        }
        AbstractOptions abstractOptions = this;
        synchronized (abstractOptions) {
            Option currentOption = this.getExistingComptibleOption(optionName, type);
            if (currentOption != null) {
                currentOption.updateRegistration(description, help, defaultValue, editor);
                return;
            }
            Option option = this.createRegisteredOption(optionName, type, description, help, defaultValue, editor);
            this.valueMap.put(optionName, option);
        }
    }

    private void warnShouldUseTheme(String optionType) {
        Throwable throwable = ReflectionUtilities.createThrowableWithStackOlderThan((Class[])new Class[]{AbstractOptions.class, SubOptions.class});
        String call = throwable.getStackTrace()[0].toString();
        Msg.warn((Object)this, (Object)("Registering a direct " + optionType + " in the options is deprecated. Use registerTheme" + optionType + "Binding() instead!\n Called from " + call + "\n"));
    }

    @Override
    public void registerThemeColorBinding(String optionName, String colorId, HelpLocation help, String description) {
        Option currentOption = this.getExistingComptibleOption(optionName, OptionType.COLOR_TYPE);
        if (currentOption != null && currentOption instanceof ThemeColorOption) {
            currentOption.updateRegistration((String)description, help, null, null);
            return;
        }
        description = (String)description + " (Theme Color: " + colorId + ")";
        ThemeColorOption option = new ThemeColorOption(optionName, colorId, (String)description, help);
        this.valueMap.put(optionName, option);
    }

    @Override
    public void registerThemeFontBinding(String optionName, String fontId, HelpLocation help, String description) {
        if (Gui.getFont(fontId) == null) {
            throw new IllegalArgumentException("Invalid theme font id: \"" + fontId + "\"");
        }
        Option currentOption = this.getExistingComptibleOption(optionName, OptionType.FONT_TYPE);
        if (currentOption != null && currentOption instanceof ThemeFontOption) {
            currentOption.updateRegistration((String)description, help, null, null);
            return;
        }
        description = (String)description + " (Theme Font: " + fontId + ")";
        ThemeFontOption option = new ThemeFontOption(optionName, fontId, (String)description, help);
        this.themeToOptionMap.put(fontId, optionName);
        this.valueMap.put(optionName, option);
    }

    private Option getExistingComptibleOption(String optionName, OptionType type) {
        Option option = this.valueMap.get(optionName);
        if (option == null) {
            return null;
        }
        OptionType existingType = option.getOptionType();
        if (existingType != type) {
            Msg.error((Object)this, (Object)("Registered option incompatible with existing option: '%s'. " + "Existing type '%s'; registered type '%s'.".formatted(new Object[]{optionName, existingType, type})), (Throwable)new AssertException());
            return null;
        }
        return option;
    }

    @Override
    public synchronized void removeOption(String optionName) {
        this.aliasMap.remove(optionName);
        this.valueMap.remove(optionName);
    }

    @Override
    public synchronized List<String> getOptionNames() {
        ArrayList<String> names = new ArrayList<String>(this.valueMap.keySet());
        names.addAll(this.aliasMap.keySet());
        Collections.sort(names);
        return names;
    }

    @Override
    public Object getObject(String optionName, Object defaultValue) {
        Option option = this.getOption(optionName, OptionType.getOptionType(defaultValue), defaultValue);
        return option.getValue(defaultValue);
    }

    public synchronized Option getOption(String optionName, OptionType type, Object defaultValue) {
        this.validateOptionName(optionName);
        if (this.aliasMap.containsKey(optionName)) {
            AliasBinding binding = this.aliasMap.get(optionName);
            return binding.options.getOption(binding.path, type, defaultValue);
        }
        Option option = this.valueMap.get(optionName);
        if (option == null && (option = this.createUnregisteredOption(optionName, type, defaultValue)).getOptionType() != OptionType.NO_TYPE) {
            this.valueMap.put(optionName, option);
        }
        this.validateOptionType(option, type);
        return option;
    }

    private void validateOptionType(Option option, OptionType type) {
        if (type == option.getOptionType() || type == OptionType.NO_TYPE) {
            return;
        }
        throw new IllegalStateException("Expected option type: " + String.valueOf((Object)type) + ", but was type: " + String.valueOf((Object)option.getOptionType()));
    }

    @Override
    public void putObject(String optionName, Object newValue) {
        if (newValue == null) {
            if (this.isNullable(optionName)) {
                this.putObject(optionName, null, OptionType.NO_TYPE);
                return;
            }
            throw new IllegalArgumentException("Attempted to put a null value in an option that does not support null values. If you wanted to removethe option, call removeOption() instead!");
        }
        if (!this.isSupportedType(newValue)) {
            throw new IllegalArgumentException("Attempted to store an object that is not supported by Options: " + String.valueOf(newValue.getClass()));
        }
        this.putObject(optionName, newValue, OptionType.getOptionType(newValue));
    }

    private boolean isNullable(String optionName) {
        Option option = this.getOption(optionName, OptionType.NO_TYPE, null);
        if (option == null) {
            return false;
        }
        OptionType type = option.getOptionType();
        return this.isNullable(type);
    }

    private boolean isNullable(OptionType type) {
        switch (type) {
            case BYTE_ARRAY_TYPE: 
            case ENUM_TYPE: 
            case COLOR_TYPE: 
            case CUSTOM_TYPE: 
            case DATE_TYPE: 
            case FILE_TYPE: 
            case FONT_TYPE: 
            case KEYSTROKE_TYPE: 
            case STRING_TYPE: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putObject(String optionName, Object newValue, OptionType type) {
        Option option = this.getOption(optionName, type, null);
        Object oldValue = option.getCurrentValue();
        option.setCurrentValue(newValue);
        boolean success = false;
        try {
            success = this.notifyOptionChanged(optionName, oldValue, newValue);
        }
        finally {
            if (!success) {
                option.setCurrentValue(oldValue);
            }
        }
    }

    @Override
    public OptionType getType(String optionName) {
        Option option = this.getOption(optionName, OptionType.NO_TYPE, null);
        return option.getOptionType();
    }

    @Override
    public boolean getBoolean(String optionName, boolean defaultValue) {
        Option option = this.getOption(optionName, OptionType.BOOLEAN_TYPE, defaultValue);
        try {
            return (Boolean)option.getValue(defaultValue);
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    @Override
    public byte[] getByteArray(String optionName, byte[] defaultValue) {
        Option option = this.getOption(optionName, OptionType.BYTE_ARRAY_TYPE, defaultValue);
        try {
            return (byte[])option.getValue(defaultValue);
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    @Override
    public int getInt(String optionName, int defaultValue) {
        Option option = this.getOption(optionName, OptionType.INT_TYPE, defaultValue);
        try {
            return (Integer)option.getValue(defaultValue);
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    @Override
    public double getDouble(String optionName, double defaultValue) {
        Option option = this.getOption(optionName, OptionType.DOUBLE_TYPE, defaultValue);
        try {
            return (Double)option.getValue(defaultValue);
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    @Override
    public float getFloat(String optionName, float defaultValue) {
        Option option = this.getOption(optionName, OptionType.FLOAT_TYPE, Float.valueOf(defaultValue));
        try {
            return ((Float)option.getValue(Float.valueOf(defaultValue))).floatValue();
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    @Override
    public long getLong(String optionName, long defaultValue) {
        Option option = this.getOption(optionName, OptionType.LONG_TYPE, defaultValue);
        try {
            return (Long)option.getValue(defaultValue);
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    @Override
    public CustomOption getCustomOption(String optionName, CustomOption defaultValue) {
        Option option = this.getOption(optionName, OptionType.CUSTOM_TYPE, defaultValue);
        try {
            return (CustomOption)option.getValue(defaultValue);
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    @Override
    public Color getColor(String optionName, Color defaultValue) {
        Option option = this.getOption(optionName, OptionType.COLOR_TYPE, defaultValue);
        try {
            return (Color)option.getValue(defaultValue);
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    @Override
    public File getFile(String optionName, File defaultValue) {
        Option option = this.getOption(optionName, OptionType.FILE_TYPE, defaultValue);
        try {
            return (File)option.getValue(defaultValue);
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    @Override
    public Font getFont(String optionName, Font defaultValue) {
        Option option = this.getOption(optionName, OptionType.FONT_TYPE, defaultValue);
        try {
            return (Font)option.getValue(defaultValue);
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    @Override
    public Date getDate(String optionName, Date defaultValue) {
        Option option = this.getOption(optionName, OptionType.DATE_TYPE, defaultValue);
        try {
            return (Date)option.getValue(defaultValue);
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    @Override
    public KeyStroke getKeyStroke(String optionName, KeyStroke defaultValue) {
        ActionTrigger defaultTrigger = null;
        if (defaultValue != null) {
            defaultTrigger = new ActionTrigger(defaultValue);
        }
        Option option = this.getOption(optionName, OptionType.ACTION_TRIGGER, defaultTrigger);
        try {
            ActionTrigger actionTrigger = (ActionTrigger)option.getValue(defaultTrigger);
            if (actionTrigger != null) {
                return actionTrigger.getKeyStroke();
            }
            return null;
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    @Override
    public ActionTrigger getActionTrigger(String optionName, ActionTrigger defaultValue) {
        Option option = this.getOption(optionName, OptionType.ACTION_TRIGGER, defaultValue);
        try {
            return (ActionTrigger)option.getValue(defaultValue);
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    @Override
    public String getString(String optionName, String defaultValue) {
        Option option = this.getOption(optionName, OptionType.STRING_TYPE, defaultValue);
        try {
            return (String)option.getValue(defaultValue);
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    @Override
    public <T extends Enum<T>> T getEnum(String optionName, T defaultValue) {
        Option option = this.getOption(optionName, OptionType.ENUM_TYPE, defaultValue);
        try {
            return (T)((Enum)option.getValue(defaultValue));
        }
        catch (ClassCastException e) {
            return defaultValue;
        }
    }

    @Override
    public void setLong(String optionName, long value) {
        this.putObject(optionName, value, OptionType.LONG_TYPE);
    }

    @Override
    public void setBoolean(String optionName, boolean value) {
        this.putObject(optionName, value, OptionType.BOOLEAN_TYPE);
    }

    @Override
    public void setInt(String optionName, int value) {
        this.putObject(optionName, value, OptionType.INT_TYPE);
    }

    @Override
    public void setDouble(String optionName, double value) {
        this.putObject(optionName, value, OptionType.DOUBLE_TYPE);
    }

    @Override
    public void setFloat(String optionName, float value) {
        this.putObject(optionName, Float.valueOf(value), OptionType.FLOAT_TYPE);
    }

    @Override
    public void setCustomOption(String optionName, CustomOption value) {
        this.putObject(optionName, value, OptionType.CUSTOM_TYPE);
    }

    @Override
    public void setByteArray(String optionName, byte[] value) {
        this.putObject(optionName, value, OptionType.BYTE_ARRAY_TYPE);
    }

    @Override
    public void setFile(String optionName, File value) {
        this.putObject(optionName, value, OptionType.FILE_TYPE);
    }

    @Override
    public void setColor(String optionName, Color value) {
        this.putObject(optionName, value, OptionType.COLOR_TYPE);
    }

    @Override
    public void setFont(String optionName, Font value) {
        this.putObject(optionName, value, OptionType.FONT_TYPE);
    }

    @Override
    public void setDate(String optionName, Date value) {
        this.putObject(optionName, value, OptionType.DATE_TYPE);
    }

    @Override
    public void setKeyStroke(String optionName, KeyStroke value) {
        ActionTrigger actionTrigger = null;
        if (value != null) {
            actionTrigger = new ActionTrigger(value);
        }
        this.setActionTrigger(optionName, actionTrigger);
    }

    @Override
    public void setActionTrigger(String optionName, ActionTrigger value) {
        this.putObject(optionName, value, OptionType.ACTION_TRIGGER);
    }

    @Override
    public void setString(String optionName, String value) {
        this.putObject(optionName, value, OptionType.STRING_TYPE);
    }

    @Override
    public <T extends Enum<T>> void setEnum(String optionName, T value) {
        this.putObject(optionName, value, OptionType.ENUM_TYPE);
    }

    @Override
    public Object getDefaultValue(String optionName) {
        Option option = this.getOption(optionName, OptionType.NO_TYPE, null);
        return option.getDefaultValue();
    }

    @Override
    public PropertyEditor getPropertyEditor(String optionName) {
        if (!Swing.isSwingThread()) {
            throw new IllegalStateException("This method must be called from the Swing thread");
        }
        Option option = this.getOption(optionName, OptionType.NO_TYPE, null);
        PropertyEditor editor = option.getPropertyEditor();
        if (editor == null) {
            editor = AbstractOptions.findPropertyEditor(option.getOptionType().getValueClass());
        }
        return editor;
    }

    @Override
    public PropertyEditor getRegisteredPropertyEditor(String optionName) {
        Option option = this.getOption(optionName, OptionType.NO_TYPE, null);
        return option.getPropertyEditor();
    }

    @Override
    public synchronized boolean contains(String optionName) {
        return this.valueMap.containsKey(optionName) || this.aliasMap.containsKey(optionName);
    }

    @Override
    public String getDescription(String optionName) {
        Option option = this.getOption(optionName, OptionType.NO_TYPE, null);
        return option.getDescription();
    }

    @Override
    public HelpLocation getHelpLocation(String optionName) {
        Option option = this.getOption(optionName, OptionType.NO_TYPE, null);
        return option.getHelpLocation();
    }

    @Override
    public boolean isRegistered(String optionName) {
        Option option = this.valueMap.get(optionName);
        if (option == null) {
            return false;
        }
        return option.isRegistered();
    }

    @Override
    public boolean isDefaultValue(String optionName) {
        Option option = this.getOption(optionName, OptionType.NO_TYPE, null);
        return option.isDefault();
    }

    @Override
    public void restoreDefaultValues() {
        List<String> optionNames = this.getOptionNames();
        for (String optionName : optionNames) {
            this.restoreDefaultValue(optionName);
        }
    }

    @Override
    public void restoreDefaultValue(String optionName) {
        Option option = this.getOption(optionName, OptionType.NO_TYPE, null);
        if (option.isDefault()) {
            return;
        }
        Object previousValue = option.getCurrentValue();
        option.restoreDefault();
        this.notifyOptionChanged(optionName, previousValue, option.getCurrentValue());
    }

    @Override
    public synchronized List<Options> getChildOptions() {
        Set<String> childNames = AbstractOptions.getChildCategories(this.getOptionNames());
        ArrayList<Options> optionsList = new ArrayList<Options>(childNames.size());
        for (String childName : childNames) {
            optionsList.add(new SubOptions(this, childName, childName + DELIMITER_STRING));
        }
        return optionsList;
    }

    @Override
    public Options getOptions(String path) {
        return new SubOptions(this, path, path + ".");
    }

    @Override
    public synchronized void setOptionsHelpLocation(HelpLocation helpLocation) {
        this.categoryHelpMap.put("", helpLocation);
    }

    @Override
    public synchronized HelpLocation getOptionsHelpLocation() {
        return this.categoryHelpMap.get("");
    }

    @Override
    public synchronized void registerOptionsEditor(Supplier<OptionsEditor> editor) {
        this.registerOptionsEditor("", editor);
    }

    @Override
    public synchronized OptionsEditor getOptionsEditor() {
        return this.optionsEditorMap.get("");
    }

    @Override
    public synchronized void createAlias(String aliasName, Options options, String optionsName) {
        if (options instanceof SubOptions) {
            SubOptions subOptions = (SubOptions)options;
            options = subOptions.getOptions();
            optionsName = subOptions.getPrefix() + (String)optionsName;
        }
        if (options instanceof AbstractOptions) {
            this.aliasMap.put(aliasName, new AliasBinding((AbstractOptions)options, (String)optionsName));
            return;
        }
        throw new IllegalArgumentException("Can only alias options that extend AbstractOptions or is a SubOptions of an AbstractOptions");
    }

    @Override
    public synchronized boolean isAlias(String aliasName) {
        return this.aliasMap.containsKey(aliasName);
    }

    static Set<String> getChildCategories(Collection<String> optionPaths) {
        HashSet<String> childNames = new HashSet<String>();
        for (String path : optionPaths) {
            int index = path.indexOf(46);
            if (index < 0) continue;
            childNames.add(path.substring(0, index));
        }
        return childNames;
    }

    static Set<String> getLeaves(Collection<String> optionPaths) {
        HashSet<String> childNames = new HashSet<String>();
        for (String path : optionPaths) {
            int index = path.indexOf(46);
            if (index >= 0) continue;
            childNames.add(path);
        }
        return childNames;
    }

    private boolean isSupportedType(Object obj) {
        if (obj instanceof byte[]) {
            return true;
        }
        if (obj instanceof Enum) {
            return true;
        }
        if (obj instanceof CustomOption) {
            return true;
        }
        if (SUPPORTED_CLASSES.contains(obj.getClass())) {
            return true;
        }
        for (Class<?> class1 : SUPPORTED_CLASSES) {
            if (!class1.isAssignableFrom(obj.getClass())) continue;
            return true;
        }
        return false;
    }

    private void validateOptionName(String optionName) {
        if (AbstractOptions.containsUnquotedText(optionName, ILLEGAL_DELIMITER)) {
            throw new IllegalArgumentException("Name cannot contain consecutive delimiters: " + optionName + " in Options " + this.name);
        }
        if (optionName.startsWith(DELIMITER_STRING)) {
            throw new IllegalArgumentException("Name cannot start with a delimiter: " + optionName + " in Options " + this.name);
        }
        if (optionName.endsWith(DELIMITER_STRING)) {
            throw new IllegalArgumentException("Name cannot end with a delimiter: " + optionName + " in Options " + this.name);
        }
    }

    private static boolean containsUnquotedText(String stringToSearch, String textToLocate) {
        StringBuffer buffer = new StringBuffer();
        boolean inQuotes = false;
        for (int i = 0; i < stringToSearch.length(); ++i) {
            char c = stringToSearch.charAt(i);
            if (c == '\"') {
                inQuotes = !inQuotes;
                continue;
            }
            if (inQuotes) continue;
            buffer.append(c);
        }
        return buffer.indexOf(textToLocate) != -1;
    }

    public synchronized void setCategoryHelpLocation(String categoryPath, HelpLocation helpLocation) {
        this.categoryHelpMap.put(categoryPath, helpLocation);
    }

    public synchronized HelpLocation getCategoryHelpLocation(String categoryPath) {
        return this.categoryHelpMap.get(categoryPath);
    }

    @Override
    public String getID(String optionName) {
        if (this.name.length() == 0) {
            return optionName;
        }
        return this.name + "." + optionName;
    }

    @Override
    public String getValueAsString(String optionName) {
        Object value = this.getObject(optionName, null);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public String getDefaultValueAsString(String optionName) {
        Object value = this.getDefaultValue(optionName);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public String toString() {
        List<String> optionNames = this.getOptionNames();
        TreeMap<String, Object> sortedOptionsMap = new TreeMap<String, Object>();
        for (String string : optionNames) {
            sortedOptionsMap.put(string, this.getObject(string, null));
        }
        return "Options: " + sortedOptionsMap.toString();
    }

    @Override
    public List<String> getLeafOptionNames() {
        Set<String> leafNames = AbstractOptions.getLeaves(this.getOptionNames());
        return new ArrayList<String>(leafNames);
    }

    private void themeChanged(ThemeEvent e) {
        if (!e.hasAnyFontChanged()) {
            return;
        }
        for (String fontId : this.themeToOptionMap.keySet()) {
            if (!e.isFontChanged(fontId)) continue;
            String optionName = this.themeToOptionMap.get(fontId);
            this.notifyOptionChanged(optionName, null, Gui.getFont(fontId));
        }
    }

    public static PropertyEditor findPropertyEditor(Class<?> originalValueClass) {
        if (originalValueClass == null) {
            return null;
        }
        for (Class<?> valueClass = originalValueClass; valueClass != null; valueClass = valueClass.getSuperclass()) {
            PropertyEditor editor;
            if (valueClass.getEnumConstants() != null) {
                PropertyEditorManager.registerEditor(originalValueClass, EnumEditor.class);
            }
            if ((editor = PropertyEditorManager.findEditor(valueClass)) instanceof NoRegisteredEditorPropertyEditor) {
                return null;
            }
            if (editor == null) continue;
            PropertyEditorManager.registerEditor(originalValueClass, editor.getClass());
            return editor;
        }
        PropertyEditorManager.registerEditor(originalValueClass, NoRegisteredEditorPropertyEditor.class);
        return null;
    }

    public static class AliasBinding {
        AbstractOptions options;
        String path;

        AliasBinding(AbstractOptions options, String path) {
            this.options = options;
            this.path = path;
        }
    }
}

